/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.statesystem.core.backend.historytree;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferReader;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferWriter;
import org.eclipse.tracecompass.datastore.core.serialization.SafeByteBufferFactory;
import org.eclipse.tracecompass.internal.provisional.statesystem.core.statevalue.CustomStateValue;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;

public final class HTInterval
implements ITmfStateInterval {
    private static final Charset CHARSET = Charset.forName("UTF-8");
    private static final String errMsg = "Invalid interval data. Maybe your file is corrupt?";
    private static final byte TYPE_NULL = -1;
    private static final byte TYPE_INTEGER = 0;
    private static final byte TYPE_STRING = 1;
    private static final byte TYPE_LONG = 2;
    private static final byte TYPE_DOUBLE = 3;
    private static final byte TYPE_CUSTOM = 20;
    private final long start;
    private final long end;
    private final int attribute;
    private final @Nullable Object sv;
    private final int fSizeOnDisk;

    public HTInterval(long intervalStart, long intervalEnd, int attribute, Object value) throws TimeRangeException {
        if (intervalStart > intervalEnd) {
            throw new TimeRangeException("Start:" + intervalStart + ", End:" + intervalEnd);
        }
        this.start = intervalStart;
        this.end = intervalEnd;
        this.attribute = attribute;
        this.sv = value instanceof TmfStateValue ? ((ITmfStateValue)value).unboxValue() : value;
        this.fSizeOnDisk = HTInterval.computeSizeOnDisk(this.sv);
    }

    private static int computeSizeOnDisk(Object sv) {
        int minSize = 21;
        if (sv == null) {
            return minSize;
        }
        if (sv instanceof Integer) {
            return minSize + 4;
        }
        if (sv instanceof Long) {
            return minSize + 8;
        }
        if (sv instanceof Double) {
            return minSize + 8;
        }
        if (sv instanceof String) {
            String str = (String)sv;
            int strLength = str.getBytes(CHARSET).length;
            if (strLength > Short.MAX_VALUE) {
                throw new IllegalArgumentException("String is too long to be stored in state system: " + str);
            }
            return minSize + strLength + 3;
        }
        if (sv instanceof CustomStateValue) {
            return minSize + 2 + ((CustomStateValue)sv).getSerializedSize();
        }
        throw new IllegalStateException();
    }

    private HTInterval(long intervalStart, long intervalEnd, int attribute, Object value, int size) throws TimeRangeException {
        if (intervalStart > intervalEnd) {
            throw new TimeRangeException("Start:" + intervalStart + ", End:" + intervalEnd);
        }
        this.start = intervalStart;
        this.end = intervalEnd;
        this.attribute = attribute;
        this.sv = value;
        this.fSizeOnDisk = size;
    }

    public static final HTInterval readFrom(ByteBuffer buffer) throws IOException {
        Object value;
        int posStart = buffer.position();
        long intervalStart = buffer.getLong();
        long intervalEnd = buffer.getLong();
        int attribute = buffer.getInt();
        byte valueType = buffer.get();
        switch (valueType) {
            case -1: {
                value = null;
                break;
            }
            case 0: {
                value = buffer.getInt();
                break;
            }
            case 1: {
                short valueSize = buffer.getShort();
                byte[] array = new byte[valueSize];
                buffer.get(array);
                value = new String(array, CHARSET);
                byte res = buffer.get();
                if (res == 0) break;
                throw new IOException(errMsg);
            }
            case 2: {
                value = buffer.getLong();
                break;
            }
            case 3: {
                value = buffer.getDouble();
                break;
            }
            case 20: {
                short valueSize = buffer.getShort();
                ISafeByteBufferReader safeBuffer = SafeByteBufferFactory.wrapReader((ByteBuffer)buffer, (int)valueSize);
                value = CustomStateValue.readSerializedValue(safeBuffer);
                break;
            }
            default: {
                throw new IOException(errMsg);
            }
        }
        try {
            return new HTInterval(intervalStart, intervalEnd, attribute, value, buffer.position() - posStart);
        }
        catch (TimeRangeException e) {
            throw new IOException(errMsg);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeInterval(ByteBuffer buffer) {
        buffer.putLong(this.start);
        buffer.putLong(this.end);
        buffer.putInt(this.attribute);
        if (this.sv != null) {
            @NonNull Object value = this.sv;
            if (value instanceof Integer) {
                buffer.put((byte)0);
                buffer.putInt((Integer)value);
                return;
            } else if (value instanceof Long) {
                buffer.put((byte)2);
                buffer.putLong((Long)value);
                return;
            } else if (value instanceof Double) {
                buffer.put((byte)3);
                buffer.putDouble((Double)value);
                return;
            } else if (value instanceof String) {
                buffer.put((byte)1);
                String string = (String)value;
                byte[] strArray = string.getBytes(CHARSET);
                buffer.putShort((short)strArray.length);
                buffer.put(strArray);
                buffer.put((byte)0);
                return;
            } else {
                if (!(value instanceof CustomStateValue)) throw new IllegalStateException("Type: " + value.getClass() + " is not implemented in the state system");
                buffer.put((byte)20);
                int size = ((CustomStateValue)value).getSerializedSize();
                buffer.putShort((short)size);
                ISafeByteBufferWriter safeBuffer = SafeByteBufferFactory.wrapWriter((ByteBuffer)buffer, (int)size);
                ((CustomStateValue)value).serialize(safeBuffer);
            }
            return;
        } else {
            buffer.put((byte)-1);
        }
    }

    @Override
    public long getStartTime() {
        return this.start;
    }

    @Override
    public long getEndTime() {
        return this.end;
    }

    @Override
    public int getAttribute() {
        return this.attribute;
    }

    @Override
    public ITmfStateValue getStateValue() {
        return TmfStateValue.newValue(this.sv);
    }

    @Override
    public Object getValue() {
        return this.sv;
    }

    @Override
    public boolean intersects(long timestamp) {
        return this.start <= timestamp && this.end >= timestamp;
    }

    public int getSizeOnDisk() {
        return this.fSizeOnDisk;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HTInterval other = (HTInterval)obj;
        return this.start == other.start && this.end == other.end && this.attribute == other.attribute && Objects.equals(this.sv, other.sv);
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end, this.attribute, this.sv);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append(this.start);
        sb.append(", ");
        sb.append(this.end);
        sb.append(']');
        sb.append(", attribute = ");
        sb.append(this.attribute);
        sb.append(", value = ");
        sb.append(String.valueOf(this.sv));
        return sb.toString();
    }
}

