/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.statesystem.core.interval;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;

public final class TmfStateInterval
implements ITmfStateInterval {
    private final long fStart;
    private final long fEnd;
    private final int fAttribute;
    private final @Nullable Object fValue;

    public TmfStateInterval(long start, long end, int attribute, @Nullable Object value) {
        this.fStart = start;
        this.fEnd = end;
        this.fAttribute = attribute;
        this.fValue = value;
    }

    @Override
    public long getStartTime() {
        return this.fStart;
    }

    @Override
    public long getEndTime() {
        return this.fEnd;
    }

    @Override
    public int getAttribute() {
        return this.fAttribute;
    }

    @Override
    public ITmfStateValue getStateValue() {
        return TmfStateValue.newValue(this.fValue);
    }

    @Override
    public boolean intersects(long timestamp) {
        return this.fStart <= timestamp && this.fEnd >= timestamp;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("start", this.fStart).append("end", this.fEnd).append("key", this.fAttribute).append("value", (Object)String.valueOf(this.fValue)).toString();
    }
}

