/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.Activator;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.AnalysisCompilationData;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.IDataDrivenCompilationUnit;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlStateValueCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenCondition;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.w3c.dom.Element;

public abstract class TmfXmlConditionCu
implements IDataDrivenCompilationUnit {
    @Override
    public abstract DataDrivenCondition generate();

    public static @Nullable TmfXmlConditionCu compile(AnalysisCompilationData analysisData, Element conditionEl) {
        switch (conditionEl.getNodeName()) {
            case "condition": {
                return TmfXmlConditionCu.compileValueCondition(analysisData, conditionEl);
            }
            case "not": {
                List<@Nullable Element> childElements = XmlUtils.getChildElements(conditionEl);
                if (childElements.size() != 1) {
                    Activator.logError("Compiling condition: NOT condition must have 1 and only 1 child");
                    return null;
                }
                Element element = Objects.requireNonNull(childElements.get(0));
                TmfXmlConditionCu compile = TmfXmlConditionCu.compile(analysisData, element);
                return compile == null ? null : new TmfXmlNotConditionCu(compile);
            }
            case "and": {
                List<TmfXmlConditionCu> childConditions = TmfXmlConditionCu.getCompiledChildConditions(analysisData, conditionEl);
                return childConditions == null ? null : new TmfXmlAndConditionCu(childConditions);
            }
            case "or": {
                List<TmfXmlConditionCu> childConditions = TmfXmlConditionCu.getCompiledChildConditions(analysisData, conditionEl);
                return childConditions == null ? null : new TmfXmlOrConditionCu(childConditions);
            }
        }
        Activator.logError("Xml condition: Unsupported condition type: " + conditionEl.getNodeName());
        return null;
    }

    private static @Nullable List<TmfXmlConditionCu> getCompiledChildConditions(AnalysisCompilationData analysisData, Element conditionEl) {
        List<@Nullable Element> childElements = XmlUtils.getChildElements(conditionEl);
        if (childElements.isEmpty()) {
            Activator.logError("Compiling condition: AND and OR condition must have at least 1 element");
            return null;
        }
        ArrayList<TmfXmlConditionCu> childConditions = new ArrayList<TmfXmlConditionCu>();
        for (Element element : childElements) {
            TmfXmlConditionCu condition = TmfXmlConditionCu.compile(analysisData, Objects.requireNonNull(element));
            if (condition == null) {
                return null;
            }
            childConditions.add(condition);
        }
        return childConditions;
    }

    private static @Nullable TmfXmlConditionCu compileValueCondition(AnalysisCompilationData analysisData, Element conditionEl) {
        DataDrivenCondition.ConditionOperator conditionOperator = TmfXmlConditionCu.getConditionOperator(conditionEl);
        List<Element> childElements = TmfXmlUtils.getChildElements(conditionEl, "stateValue");
        if (childElements.size() == 2) {
            TmfXmlStateValueCu firstValue = TmfXmlStateValueCu.compileValue(analysisData, childElements.get(0));
            TmfXmlStateValueCu secondValue = TmfXmlStateValueCu.compileValue(analysisData, childElements.get(1));
            if (firstValue == null || secondValue == null) {
                return null;
            }
            return new TmfXmlCompareConditionCu(firstValue, secondValue, conditionOperator);
        }
        if (childElements.size() == 1) {
            TmfXmlStateValueCu secondValue = TmfXmlStateValueCu.compileValue(analysisData, childElements.get(0));
            TmfXmlStateValueCu firstValue = null;
            List<Element> attributes = TmfXmlUtils.getChildElements(conditionEl, "stateAttribute");
            if (!attributes.isEmpty()) {
                ArrayList<TmfXmlStateValueCu> attributesCu = new ArrayList<TmfXmlStateValueCu>();
                for (Element stateAttributeEl : attributes) {
                    List<TmfXmlStateValueCu> attrib = TmfXmlStateValueCu.compileAttribute(analysisData, stateAttributeEl);
                    if (attrib == null) {
                        return null;
                    }
                    attributesCu.addAll(attrib);
                }
                firstValue = TmfXmlStateValueCu.compileAsQuery(attributesCu);
            } else {
                attributes = TmfXmlUtils.getChildElements(conditionEl, "field");
                if (attributes.size() != 1) {
                    Activator.logError("Condition: There should be either 2 state values or 1 attribute or field and 1 state value");
                    return null;
                }
                firstValue = TmfXmlStateValueCu.compileField(analysisData, attributes.get(0));
            }
            if (firstValue == null || secondValue == null) {
                return null;
            }
            return new TmfXmlCompareConditionCu(firstValue, secondValue, conditionOperator);
        }
        return null;
    }

    private static DataDrivenCondition.ConditionOperator getConditionOperator(Element rootNode) {
        String equationType;
        switch (equationType = rootNode.getAttribute("operator")) {
            case "eq": {
                return DataDrivenCondition.ConditionOperator.EQ;
            }
            case "ne": {
                return DataDrivenCondition.ConditionOperator.NE;
            }
            case "ge": {
                return DataDrivenCondition.ConditionOperator.GE;
            }
            case "gt": {
                return DataDrivenCondition.ConditionOperator.GT;
            }
            case "le": {
                return DataDrivenCondition.ConditionOperator.LE;
            }
            case "lt": {
                return DataDrivenCondition.ConditionOperator.LT;
            }
            case "": {
                return DataDrivenCondition.ConditionOperator.EQ;
            }
        }
        throw new IllegalArgumentException("TmfXmlCondition: invalid comparison operator.");
    }

    private static class TmfXmlAndConditionCu
    extends TmfXmlConditionCu {
        private final List<TmfXmlConditionCu> fConditions;

        TmfXmlAndConditionCu(List<TmfXmlConditionCu> childConditions) {
            this.fConditions = childConditions;
        }

        @Override
        public DataDrivenCondition generate() {
            List<DataDrivenCondition> conditions = this.fConditions.stream().map(TmfXmlConditionCu::generate).collect(Collectors.toList());
            return new DataDrivenCondition.DataDrivenAndCondition(conditions);
        }
    }

    private static class TmfXmlCompareConditionCu
    extends TmfXmlConditionCu {
        private final TmfXmlStateValueCu fFirstValue;
        private final TmfXmlStateValueCu fSecondValue;
        private final DataDrivenCondition.ConditionOperator fOperator;

        TmfXmlCompareConditionCu(TmfXmlStateValueCu firstValue, TmfXmlStateValueCu secondValue, DataDrivenCondition.ConditionOperator conditionOperator) {
            this.fFirstValue = firstValue;
            this.fSecondValue = secondValue;
            this.fOperator = conditionOperator;
        }

        @Override
        public DataDrivenCondition generate() {
            return new DataDrivenCondition.DataDrivenComparisonCondition(this.fFirstValue.generate(), this.fSecondValue.generate(), this.fOperator);
        }
    }

    private static class TmfXmlNotConditionCu
    extends TmfXmlConditionCu {
        private final TmfXmlConditionCu fCondition;

        TmfXmlNotConditionCu(TmfXmlConditionCu compile) {
            this.fCondition = compile;
        }

        @Override
        public DataDrivenCondition generate() {
            return new DataDrivenCondition.TmfDdNotCondition(this.fCondition.generate());
        }
    }

    private static class TmfXmlOrConditionCu
    extends TmfXmlConditionCu {
        private final List<TmfXmlConditionCu> fConditions;

        TmfXmlOrConditionCu(List<TmfXmlConditionCu> childConditions) {
            this.fConditions = childConditions;
        }

        @Override
        public DataDrivenCondition generate() {
            List<DataDrivenCondition> conditions = this.fConditions.stream().map(TmfXmlConditionCu::generate).collect(Collectors.toList());
            return new DataDrivenCondition.DataDrivenOrCondition(conditions);
        }
    }
}

