/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.Activator;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlCondition;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlModelFactory;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlStateAttribute;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlStateValue;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlScenarioInfo;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlTimestampCondition;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.IXmlStateSystemContainer;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.w3c.dom.Element;

public class TmfXmlCondition
implements ITmfXmlCondition {
    private final List<TmfXmlCondition> fConditions = new ArrayList<TmfXmlCondition>();
    private final List<ITmfXmlStateValue> fStateValues;
    private final LogicalOperator fOperator;
    private final IXmlStateSystemContainer fContainer;
    private final ConditionOperator fConditionOperator;
    private ConditionType fType;
    private @Nullable TmfXmlTimestampCondition fTimeCondition;

    public static TmfXmlCondition create(ITmfXmlModelFactory modelFactory, Element node, IXmlStateSystemContainer container) {
        Element rootNode = node;
        List<@Nullable Element> childElements = XmlUtils.getChildElements(rootNode);
        if (node.getNodeName().equals("if")) {
            if (childElements.isEmpty()) {
                throw new IllegalArgumentException("TmfXmlCondition constructor: IF node with no child element");
            }
            rootNode = (Element)NonNullUtils.checkNotNull((Object)childElements.get(0));
            childElements = XmlUtils.getChildElements(rootNode);
        }
        ArrayList<@NonNull TmfXmlCondition> conditions = new ArrayList<TmfXmlCondition>();
        switch (rootNode.getNodeName()) {
            case "condition": {
                return TmfXmlCondition.createPatternCondition(modelFactory, container, rootNode, childElements);
            }
            case "not": {
                return TmfXmlCondition.createMultipleCondition(modelFactory, container, childElements, LogicalOperator.NOT, conditions);
            }
            case "and": {
                return TmfXmlCondition.createMultipleCondition(modelFactory, container, childElements, LogicalOperator.AND, conditions);
            }
            case "or": {
                return TmfXmlCondition.createMultipleCondition(modelFactory, container, childElements, LogicalOperator.OR, conditions);
            }
        }
        throw new IllegalArgumentException("TmfXmlCondition constructor: XML node " + rootNode.getNodeName() + " is of the wrong type");
    }

    private static TmfXmlCondition createPatternCondition(ITmfXmlModelFactory modelFactory, IXmlStateSystemContainer container, Element rootNode, List<@Nullable Element> childElements) {
        TmfXmlTimestampCondition timeCondition = null;
        int size = TmfXmlUtils.getChildElements(rootNode, "stateValue").size();
        if (size != 0) {
            ConditionOperator conditionOperator;
            ArrayList<ITmfXmlStateValue> stateValues = new ArrayList<ITmfXmlStateValue>(size);
            if (size == 1) {
                conditionOperator = TmfXmlCondition.getConditionOperator(rootNode);
                TmfXmlCondition.getStateValuesForXmlCondition(modelFactory, (List)NonNullUtils.checkNotNull(childElements), stateValues, container);
            } else {
                conditionOperator = ConditionOperator.EQ;
                stateValues.add(modelFactory.createStateValue((Element)NonNullUtils.checkNotNull((Object)childElements.get(0)), container, new ArrayList<ITmfXmlStateAttribute>()));
                stateValues.add(modelFactory.createStateValue((Element)NonNullUtils.checkNotNull((Object)childElements.get(1)), container, new ArrayList<ITmfXmlStateAttribute>()));
            }
            return new TmfXmlCondition(ConditionType.DATA, stateValues, LogicalOperator.NONE, conditionOperator, null, new ArrayList<TmfXmlCondition>(), container);
        }
        Element firstElement = (Element)NonNullUtils.checkNotNull((Object)childElements.get(0));
        timeCondition = modelFactory.createTimestampsCondition(firstElement, container);
        return new TmfXmlCondition(ConditionType.TIME, new ArrayList<ITmfXmlStateValue>(), LogicalOperator.NONE, ConditionOperator.EQ, timeCondition, new ArrayList<TmfXmlCondition>(), container);
    }

    private static TmfXmlCondition createMultipleCondition(ITmfXmlModelFactory modelFactory, IXmlStateSystemContainer container, List<@Nullable Element> childElements, LogicalOperator op, List<@NonNull TmfXmlCondition> conditions) {
        for (Element condition : childElements) {
            if (condition == null) continue;
            conditions.add(modelFactory.createCondition(condition, container));
        }
        return new TmfXmlCondition(ConditionType.NONE, new ArrayList<ITmfXmlStateValue>(), op, ConditionOperator.NONE, null, conditions, container);
    }

    private TmfXmlCondition(ConditionType type, ArrayList<@NonNull ITmfXmlStateValue> stateValues, LogicalOperator operator, ConditionOperator conditionOperator, @Nullable TmfXmlTimestampCondition timeCondition, List<@NonNull TmfXmlCondition> conditions, IXmlStateSystemContainer container) {
        this.fType = type;
        this.fStateValues = stateValues;
        this.fOperator = operator;
        this.fTimeCondition = timeCondition;
        this.fContainer = container;
        this.fConditions.addAll(conditions);
        this.fConditionOperator = conditionOperator;
    }

    private static void getStateValuesForXmlCondition(ITmfXmlModelFactory modelFactory, List<@Nullable Element> childElements, List<ITmfXmlStateValue> stateValues, IXmlStateSystemContainer container) {
        Element stateValueElement = (Element)NonNullUtils.checkNotNull((Object)childElements.remove(childElements.size() - 1));
        Element firstElement = (Element)NonNullUtils.checkNotNull((Object)childElements.get(0));
        if (childElements.size() == 1 && firstElement.getNodeName().equals("field")) {
            String attribute = firstElement.getAttribute("name");
            stateValues.add(modelFactory.createStateValue(stateValueElement, container, attribute));
        } else {
            ArrayList<ITmfXmlStateAttribute> attributes = new ArrayList<ITmfXmlStateAttribute>();
            for (Element element : childElements) {
                if (element == null) {
                    throw new NullPointerException("There should be at list one element");
                }
                if (!element.getNodeName().equals("stateAttribute")) {
                    throw new IllegalArgumentException("TmfXmlCondition: a condition either has a eventField element or a number of TmfXmlStateAttribute elements before the state value");
                }
                ITmfXmlStateAttribute attribute = modelFactory.createStateAttribute(element, container);
                attributes.add(attribute);
            }
            stateValues.add(modelFactory.createStateValue(stateValueElement, container, attributes));
        }
    }

    private static ConditionOperator getConditionOperator(Element rootNode) {
        String equationType;
        switch (equationType = rootNode.getAttribute("operator")) {
            case "eq": {
                return ConditionOperator.EQ;
            }
            case "ne": {
                return ConditionOperator.NE;
            }
            case "ge": {
                return ConditionOperator.GE;
            }
            case "gt": {
                return ConditionOperator.GT;
            }
            case "le": {
                return ConditionOperator.LE;
            }
            case "lt": {
                return ConditionOperator.LT;
            }
            case "": {
                return ConditionOperator.EQ;
            }
        }
        throw new IllegalArgumentException("TmfXmlCondition: invalid comparison operator.");
    }

    @Override
    public boolean test(ITmfEvent event, @Nullable TmfXmlScenarioInfo scenarioInfo) {
        ITmfStateSystem ss = this.fContainer.getStateSystem();
        if (this.fType == ConditionType.DATA) {
            try {
                return this.testForEvent(event, (ITmfStateSystem)NonNullUtils.checkNotNull((Object)ss), scenarioInfo);
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
                Activator.logError("Attribute not found", attributeNotFoundException);
                return false;
            }
        }
        if (this.fType == ConditionType.TIME) {
            if (this.fTimeCondition != null) {
                return this.fTimeCondition.test(event, scenarioInfo);
            }
        } else if (!this.fConditions.isEmpty()) {
            switch (this.fOperator) {
                case AND: {
                    for (ITmfXmlCondition iTmfXmlCondition : this.fConditions) {
                        if (iTmfXmlCondition.test(event, scenarioInfo)) continue;
                        return false;
                    }
                    return true;
                }
                case NONE: {
                    break;
                }
                case NOT: {
                    return !this.fConditions.get(0).test(event, scenarioInfo);
                }
                case OR: {
                    for (ITmfXmlCondition iTmfXmlCondition : this.fConditions) {
                        if (!iTmfXmlCondition.test(event, scenarioInfo)) continue;
                        return true;
                    }
                    return false;
                }
            }
        }
        return true;
    }

    private boolean testForEvent(ITmfEvent event, ITmfStateSystem ss, @Nullable TmfXmlScenarioInfo scenarioInfo) throws AttributeNotFoundException {
        if (this.fStateValues.size() == 1) {
            ITmfXmlStateValue filter = this.fStateValues.get(0);
            int quark = -1;
            for (ITmfXmlStateAttribute attribute : filter.getAttributes()) {
                quark = attribute.getAttributeQuark(event, quark, scenarioInfo);
                if (quark != -1) continue;
                throw new AttributeNotFoundException(String.valueOf(ss.getSSID()) + " Attribute:" + attribute);
            }
            ITmfStateValue valueState = quark != -1 ? ss.queryOngoingState(quark) : filter.getEventFieldValue(event);
            ITmfStateValue valueXML = filter.getValue(event, scenarioInfo);
            return this.compare(valueState, valueXML, this.fConditionOperator);
        }
        ITmfStateValue valuesXML1 = this.fStateValues.get(0).getValue(event, scenarioInfo);
        ITmfStateValue valuesXML2 = this.fStateValues.get(1).getValue(event, scenarioInfo);
        return valuesXML1.equals(valuesXML2);
    }

    public String toString() {
        StringBuilder output = new StringBuilder("TmfXmlCondition: ");
        if (this.fOperator != LogicalOperator.NONE) {
            output.append((Object)this.fOperator).append(" on ").append(this.fConditions);
        } else {
            output.append((Object)this.fConditionOperator).append(" {").append(this.fStateValues.get(0));
            if (this.fStateValues.size() == 2) {
                output.append(", ").append(this.fStateValues.get(1));
            }
            output.append("}");
        }
        return output.toString();
    }

    public boolean compare(ITmfStateValue source, ITmfStateValue dest, ConditionOperator comparisonOperator) {
        switch (comparisonOperator) {
            case EQ: {
                return source.compareTo((Object)dest) == 0;
            }
            case NE: {
                return source.compareTo((Object)dest) != 0;
            }
            case GE: {
                return source.compareTo((Object)dest) >= 0;
            }
            case GT: {
                return source.compareTo((Object)dest) > 0;
            }
            case LE: {
                return source.compareTo((Object)dest) <= 0;
            }
            case LT: {
                return source.compareTo((Object)dest) < 0;
            }
        }
        throw new IllegalArgumentException("TmfXmlCondition: invalid comparison operator.");
    }

    private static enum ConditionOperator {
        NONE,
        EQ,
        NE,
        GE,
        GT,
        LE,
        LT;

    }

    private static enum ConditionType {
        DATA,
        TIME,
        NONE;

    }

    private static enum LogicalOperator {
        NONE,
        NOT,
        AND,
        OR;

    }
}

