/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.model;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filter.parser.FilterCu;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.TimeGraphStateQueryFilter;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public abstract class AbstractTmfTraceDataProvider {
    private final ITmfTrace fTrace;

    public AbstractTmfTraceDataProvider(ITmfTrace trace) {
        this.fTrace = trace;
    }

    protected ITmfTrace getTrace() {
        return this.fTrace;
    }

    protected Map<Integer, Predicate<@NonNull Map<@NonNull String, @NonNull String>>> computeRegexPredicate(TimeGraphStateQueryFilter queryFilter) {
        Multimap<@NonNull Integer, @NonNull String> regexes = queryFilter.getRegexes();
        HashMap<@NonNull Integer, @NonNull Predicate<@NonNull Map<@NonNull String, @NonNull String>>> predicates = new HashMap<Integer, Predicate<Map<String, String>>>();
        for (Map.Entry entry : regexes.asMap().entrySet()) {
            Predicate<Map<String, String>> predicate;
            String regex = Joiner.on((String)"&&").skipNulls().join(Iterables.filter((Iterable)Objects.requireNonNull((Collection)entry.getValue()), s -> !s.isEmpty()));
            FilterCu cu = FilterCu.compile(regex);
            Predicate<Map<String, String>> predicate2 = predicate = cu != null ? cu.generate() : null;
            if (predicate == null) continue;
            predicates.put((Integer)entry.getKey(), predicate);
        }
        return predicates;
    }
}

