/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.planner.cost.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.query.runtime.localsearch.planner.cost.IConstraintEvaluationContext;
import org.eclipse.viatra.query.runtime.localsearch.planner.cost.ICostFunction;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryMetaContext;
import org.eclipse.viatra.query.runtime.matchers.context.InputKeyImplication;
import org.eclipse.viatra.query.runtime.matchers.planning.helpers.FunctionalDependencyHelper;
import org.eclipse.viatra.query.runtime.matchers.psystem.PConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.analysis.QueryAnalyzer;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.AggregatorConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.ExpressionEvaluation;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.Inequality;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.NegativePatternCall;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.PatternMatchCounter;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.TypeFilterConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.BinaryReflexiveTransitiveClosure;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.BinaryTransitiveClosure;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.ConstantValue;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;

public abstract class StatisticsBasedConstraintCostFunction
implements ICostFunction {
    protected static final double MAX_COST = 250.0;
    protected static final double DEFAULT_COST = 150.0;

    public abstract long countTuples(IConstraintEvaluationContext var1, IInputKey var2);

    @Override
    public double apply(IConstraintEvaluationContext input) {
        return this.calculateCost(input.getConstraint(), input);
    }

    protected double _calculateCost(ConstantValue constant, IConstraintEvaluationContext input) {
        return 0.0;
    }

    protected double _calculateCost(TypeConstraint constraint, IConstraintEvaluationContext input) {
        Collection<PVariable> freeMaskVariables = input.getFreeVariables();
        Collection<PVariable> boundMaskVariables = input.getBoundVariables();
        IInputKey supplierKey = (IInputKey)constraint.getSupplierKey();
        long arity = supplierKey.getArity();
        if (arity == 1L) {
            return this.calculateUnaryConstraintCost(constraint, input);
        }
        if (arity == 2L) {
            long edgeCount = this.countTuples(input, supplierKey);
            PVariable srcVariable = (PVariable)constraint.getVariablesTuple().get(0);
            PVariable dstVariable = (PVariable)constraint.getVariablesTuple().get(1);
            boolean isInverse = false;
            if (freeMaskVariables.contains(srcVariable) && boundMaskVariables.contains(dstVariable)) {
                isInverse = true;
            }
            double binaryExtendCost = this.calculateBinaryExtendCost(supplierKey, srcVariable, dstVariable, isInverse, edgeCount, input);
            return isInverse ? binaryExtendCost + 1.0 : binaryExtendCost;
        }
        throw new UnsupportedOperationException("Cost calculation for arity " + arity + " is not implemented yet");
    }

    protected double calculateBinaryExtendCost(IInputKey supplierKey, PVariable srcVariable, PVariable dstVariable, boolean isInverse, long edgeCount, IConstraintEvaluationContext input) {
        double dstNodeCount;
        Collection<PVariable> freeMaskVariables = input.getFreeVariables();
        PConstraint constraint = input.getConstraint();
        IQueryMetaContext metaContext = input.getRuntimeContext().getMetaContext();
        Collection implications = metaContext.getImplications(supplierKey);
        double srcCount = -1.0;
        double dstCount = -1.0;
        for (InputKeyImplication implication : implications) {
            List impliedIndices = implication.getImpliedIndices();
            if (impliedIndices.size() == 1 && impliedIndices.contains(0)) {
                srcCount = this.countTuples(input, implication.getImpliedKey());
                continue;
            }
            if (impliedIndices.size() != 1 || !impliedIndices.contains(1)) continue;
            dstCount = this.countTuples(input, implication.getImpliedKey());
        }
        if (freeMaskVariables.contains(srcVariable) && freeMaskVariables.contains(dstVariable)) {
            return dstCount * srcCount;
        }
        double srcNodeCount = isInverse ? dstCount : srcCount;
        double d = dstNodeCount = isInverse ? srcCount : dstCount;
        if (srcNodeCount > -1.0 && edgeCount > -1L) {
            return srcNodeCount == 0.0 ? 0.0 : (double)edgeCount / srcNodeCount;
        }
        if (srcCount > -1.0 && dstCount > -1.0) {
            return srcCount != 0.0 ? dstNodeCount / srcNodeCount : 1.0;
        }
        return this.navigatesThroughFunctionalDependency(input, constraint) ? 1.0 : 150.0;
    }

    protected boolean navigatesThroughFunctionalDependency(IConstraintEvaluationContext input, PConstraint constraint) {
        QueryAnalyzer queryAnalyzer = input.getQueryAnalyzer();
        Map functionalDependencies = queryAnalyzer.getFunctionalDependencies(Collections.singleton(constraint), false);
        Set impliedVariables = FunctionalDependencyHelper.closureOf(input.getBoundVariables(), (Map)functionalDependencies);
        return impliedVariables != null && impliedVariables.containsAll(input.getFreeVariables());
    }

    protected double calculateUnaryConstraintCost(TypeConstraint constraint, IConstraintEvaluationContext input) {
        PVariable variable = (PVariable)constraint.getVariablesTuple().get(0);
        if (input.getBoundVariables().contains(variable)) {
            return 0.9;
        }
        return (double)this.countTuples(input, (IInputKey)constraint.getSupplierKey()) + 150.0;
    }

    protected double _calculateCost(ExportedParameter exportedParam, IConstraintEvaluationContext input) {
        return 0.0;
    }

    protected double _calculateCost(TypeFilterConstraint exportedParam, IConstraintEvaluationContext input) {
        return 0.0;
    }

    protected double _calculateCost(PositivePatternCall patternCall, IConstraintEvaluationContext input) {
        Map dependencies = input.getQueryAnalyzer().getFunctionalDependencies(Collections.singleton(patternCall), false);
        Set boundOrImplied = FunctionalDependencyHelper.closureOf(input.getBoundVariables(), (Map)dependencies);
        List parameters = patternCall.getReferredQuery().getParameters();
        double result = 1.0;
        int i = 0;
        while (i < parameters.size()) {
            PVariable variable = patternCall.getVariableInTuple(i);
            IInputKey type = ((PParameter)parameters.get(i)).getDeclaredUnaryType();
            double multiplier = boundOrImplied.contains(variable) ? 0.9 : (type == null ? 150.0 : (double)this.countTuples(input, type));
            result *= multiplier;
            ++i;
        }
        return result;
    }

    protected double _calculateCost(ExpressionEvaluation evaluation, IConstraintEvaluationContext input) {
        return this._calculateCost((PConstraint)evaluation, input);
    }

    protected double _calculateCost(Inequality inequality, IConstraintEvaluationContext input) {
        return this._calculateCost((PConstraint)inequality, input);
    }

    protected double _calculateCost(AggregatorConstraint aggregator, IConstraintEvaluationContext input) {
        return this._calculateCost((PConstraint)aggregator, input);
    }

    protected double _calculateCost(NegativePatternCall call, IConstraintEvaluationContext input) {
        return this._calculateCost((PConstraint)call, input);
    }

    protected double _calculateCost(PatternMatchCounter counter, IConstraintEvaluationContext input) {
        return this._calculateCost((PConstraint)counter, input);
    }

    protected double _calculateCost(BinaryTransitiveClosure closure, IConstraintEvaluationContext input) {
        return this._calculateCost((PConstraint)closure, input);
    }

    protected double _calculateCost(BinaryReflexiveTransitiveClosure closure, IConstraintEvaluationContext input) {
        return this._calculateCost((PConstraint)closure, input);
    }

    protected double _calculateCost(PConstraint constraint, IConstraintEvaluationContext input) {
        if (input.getFreeVariables().isEmpty()) {
            return 1.0;
        }
        return 150.0;
    }

    public double calculateCost(PConstraint constraint, IConstraintEvaluationContext input) {
        Preconditions.checkArgument((constraint != null ? 1 : 0) != 0, (String)"Set constraint value correctly");
        if (constraint instanceof ExportedParameter) {
            return this._calculateCost((ExportedParameter)constraint, input);
        }
        if (constraint instanceof TypeFilterConstraint) {
            return this._calculateCost((TypeFilterConstraint)constraint, input);
        }
        if (constraint instanceof ConstantValue) {
            return this._calculateCost((ConstantValue)constraint, input);
        }
        if (constraint instanceof PositivePatternCall) {
            return this._calculateCost((PositivePatternCall)constraint, input);
        }
        if (constraint instanceof TypeConstraint) {
            return this._calculateCost((TypeConstraint)constraint, input);
        }
        if (constraint instanceof ExpressionEvaluation) {
            return this._calculateCost((ExpressionEvaluation)constraint, input);
        }
        if (constraint instanceof Inequality) {
            return this._calculateCost((Inequality)constraint, input);
        }
        if (constraint instanceof AggregatorConstraint) {
            return this._calculateCost((AggregatorConstraint)constraint, input);
        }
        if (constraint instanceof NegativePatternCall) {
            return this._calculateCost((NegativePatternCall)constraint, input);
        }
        if (constraint instanceof PatternMatchCounter) {
            return this._calculateCost((PatternMatchCounter)constraint, input);
        }
        if (constraint instanceof BinaryTransitiveClosure) {
            return this._calculateCost((BinaryTransitiveClosure)constraint, input);
        }
        if (constraint instanceof BinaryReflexiveTransitiveClosure) {
            return this._calculateCost((BinaryReflexiveTransitiveClosure)constraint, input);
        }
        return this._calculateCost(constraint, input);
    }
}

