/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.support;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.draw2d.geometry.Dimension;
import org.eclipse.wb.draw2d.geometry.Insets;
import org.eclipse.wb.internal.swt.support.ContainerSupport;
import org.eclipse.wb.internal.swt.support.ControlSupport;

public final class CoordinateUtils {
    public static org.eclipse.wb.draw2d.geometry.Rectangle getRectangle(Rectangle r) {
        return new org.eclipse.wb.draw2d.geometry.Rectangle(r.x, r.y, r.width, r.height);
    }

    public static org.eclipse.wb.draw2d.geometry.Point getPoint(Point point) {
        return new org.eclipse.wb.draw2d.geometry.Point(point.x, point.y);
    }

    public static org.eclipse.wb.draw2d.geometry.Rectangle getBounds(Control control) throws Exception {
        Rectangle bounds = control.getBounds();
        return CoordinateUtils.getRectangle(bounds);
    }

    public static org.eclipse.wb.draw2d.geometry.Point toDisplay(Control control, int x, int y) throws Exception {
        Point location = control.toDisplay(x, y);
        return CoordinateUtils.getPoint(location);
    }

    public static Dimension getPreferredSize(Control control) throws Exception {
        Point size = control.computeSize(-1, -1);
        org.eclipse.wb.draw2d.geometry.Point pointSize = CoordinateUtils.getPoint(size);
        return new Dimension(pointSize.x, pointSize.y);
    }

    public static Dimension computeTrimSize(Composite composite, int width, int height) throws Exception {
        Rectangle trim = composite.computeTrim(0, 0, width, height);
        return new Dimension(trim.width, trim.height);
    }

    public static org.eclipse.wb.draw2d.geometry.Rectangle getClientArea(Scrollable composite) {
        Rectangle rectangle = composite.getClientArea();
        return CoordinateUtils.getRectangle(rectangle);
    }

    public static org.eclipse.wb.draw2d.geometry.Point getDisplayLocation(Control control) throws Exception {
        org.eclipse.wb.draw2d.geometry.Rectangle bounds = CoordinateUtils.getBounds(control);
        int x = bounds.x;
        int y = bounds.y;
        return CoordinateUtils.getDisplayLocation(control, x, y);
    }

    public static org.eclipse.wb.draw2d.geometry.Point getDisplayLocation(Control control, int x, int y) throws Exception {
        Composite parent;
        if (!(control instanceof Shell) && (parent = control.getParent()) != null) {
            org.eclipse.wb.draw2d.geometry.Point location = CoordinateUtils.toDisplay((Control)parent, x, y);
            x = location.x;
            y = location.y;
        }
        return new org.eclipse.wb.draw2d.geometry.Point(x, y);
    }

    public static Insets getClientAreaInsets(Composite composite) throws Exception {
        org.eclipse.wb.draw2d.geometry.Point displayLocation = CoordinateUtils.getDisplayLocation((Control)composite);
        org.eclipse.wb.draw2d.geometry.Point clientAreaLocation = CoordinateUtils.toDisplay((Control)composite, 0, 0);
        int top = Math.abs(clientAreaLocation.y - displayLocation.y);
        int left = Math.abs(clientAreaLocation.x - displayLocation.x);
        if (top == 0 && left == 0) {
            return Insets.ZERO_INSETS;
        }
        org.eclipse.wb.draw2d.geometry.Rectangle bounds = CoordinateUtils.getBounds((Control)composite);
        org.eclipse.wb.draw2d.geometry.Rectangle clientArea = CoordinateUtils.getClientArea((Scrollable)composite);
        int bottom = bounds.height - top - clientArea.height;
        int right = bounds.width - left - clientArea.width;
        return new Insets(top, left, bottom, right);
    }

    public static Insets getClientAreaInsets2(Composite composite) throws Exception {
        Insets trimInsets = CoordinateUtils.getClientAreaInsets(composite);
        if (trimInsets.top != 0 || trimInsets.left != 0) {
            return Insets.ZERO_INSETS;
        }
        org.eclipse.wb.draw2d.geometry.Rectangle bounds = ControlSupport.getBounds((Object)composite);
        org.eclipse.wb.draw2d.geometry.Rectangle clientArea = ContainerSupport.getClientArea((Object)composite);
        int top = clientArea.y;
        int left = clientArea.x;
        int bottom = bounds.height - top - clientArea.height;
        int right = bounds.width - left - clientArea.width;
        return new Insets(top, left, bottom, right);
    }
}

