/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.internal.doubleclick;

import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.xml.ui.internal.doubleclick.XMLDoubleClickStrategy;

public class XSLDoubleClickStrategy
extends XMLDoubleClickStrategy {
    static final char[] XML_DELIMITERS = new char[]{' ', '\'', '\"', '[', ']', '|', '(', ')', '{', '}', '=', '!'};
    static final char[] XML_PARENTHESIS = new char[]{'[', ']', '(', ')', '{', '}'};

    protected Point getWord(String string, int cursor) {
        if (string == null) {
            return null;
        }
        int wordStart = 0;
        int wordEnd = string.length();
        wordStart = this.startOfWord(string, cursor, wordStart);
        wordEnd = this.endOfWord(string, cursor, wordEnd);
        if (wordStart == (wordEnd = this.checkXPathExpression(string, wordEnd)) && !this.isQuoted(string)) {
            wordStart = 0;
            wordEnd = string.length();
        }
        return new Point(wordStart, wordEnd);
    }

    private int checkXPathExpression(String string, int wordEnd) {
        if (wordEnd < string.length() - 1) {
            boolean unbalanced;
            boolean stop;
            int[] flags = new int[XML_PARENTHESIS.length / 2];
            boolean found = false;
            int pos = wordEnd;
            do {
                char cur = string.charAt(pos);
                int i = 0;
                while (i < XML_PARENTHESIS.length) {
                    if (cur == XML_PARENTHESIS[i]) {
                        int n = i / 2;
                        flags[n] = flags[n] + (i % 2 == 0 ? 1 : -1);
                        found = true;
                    }
                    ++i;
                }
                stop = true;
                unbalanced = false;
                int i2 = 0;
                while (i2 < flags.length) {
                    stop = stop && flags[i2] == 0;
                    unbalanced |= flags[i2] < 0;
                    ++i2;
                }
                if (unbalanced) continue;
                ++pos;
            } while (!(stop | unbalanced) && pos < string.length());
            if (found) {
                wordEnd = Math.min(string.length() - 1, pos);
            }
        }
        return wordEnd;
    }

    private int endOfWord(String string, int cursor, int wordEnd) {
        int i = 0;
        while (i < XML_DELIMITERS.length) {
            char delim = XML_DELIMITERS[i];
            int end = string.indexOf(delim, cursor);
            wordEnd = Math.min(wordEnd, end == -1 ? string.length() : end);
            ++i;
        }
        if (wordEnd == string.length()) {
            wordEnd = cursor;
        }
        return wordEnd;
    }

    protected int startOfWord(String string, int cursor, int wordStart) {
        int i = 0;
        while (i < XML_DELIMITERS.length) {
            char delim = XML_DELIMITERS[i];
            wordStart = Math.max(wordStart, string.lastIndexOf(delim, cursor - 1));
            ++i;
        }
        wordStart = wordStart == -1 ? cursor : ++wordStart;
        return wordStart;
    }
}

