/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.birt.emitters.excel.handlers;

import java.util.Collection;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.HeaderFooter;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.ITaskOption;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.content.impl.CellContent;
import org.eclipse.birt.report.engine.presentation.ContentEmitterVisitor;
import uk.co.spudsoft.birt.emitters.excel.CellImage;
import uk.co.spudsoft.birt.emitters.excel.ClientAnchorConversions;
import uk.co.spudsoft.birt.emitters.excel.Coordinate;
import uk.co.spudsoft.birt.emitters.excel.EmitterServices;
import uk.co.spudsoft.birt.emitters.excel.HandlerState;
import uk.co.spudsoft.birt.emitters.excel.StyleManagerUtils;
import uk.co.spudsoft.birt.emitters.excel.framework.Logger;
import uk.co.spudsoft.birt.emitters.excel.handlers.AbstractHandler;
import uk.co.spudsoft.birt.emitters.excel.handlers.IHandler;
import uk.co.spudsoft.birt.emitters.excel.handlers.StringCellHandler;
import uk.co.spudsoft.birt.emitters.excel.handlers.TopLevelContentHandler;
import uk.co.spudsoft.birt.emitters.excel.handlers.TopLevelListHandler;
import uk.co.spudsoft.birt.emitters.excel.handlers.TopLevelTableHandler;

public class PageHandler
extends AbstractHandler {
    public PageHandler(Logger log, IPageContent page) {
        super(log, null, (IContent)page);
    }

    private void setupPageSize(HandlerState state, IPageContent page) {
        PrintSetup printSetup = state.currentSheet.getPrintSetup();
        printSetup.setPaperSize(state.getSmu().getPaperSizeFromString(page.getPageType()));
        if (page.getOrientation() != null && "landscape".equals(page.getOrientation())) {
            printSetup.setLandscape(true);
        }
    }

    private String contentAsString(HandlerState state, Object obj) throws BirtException {
        StringCellHandler stringCellHandler = new StringCellHandler(state.getEmitter(), this.log, this, (ICellContent)(obj instanceof CellContent ? (CellContent)obj : null));
        state.setHandler(stringCellHandler);
        stringCellHandler.visit(obj);
        state.setHandler(this);
        return stringCellHandler.getString();
    }

    private void processHeaderFooter(HandlerState state, Collection birtHeaderFooter, HeaderFooter poiHeaderFooter) throws BirtException {
        boolean handledAsGrid = false;
        for (Object ftrObject : birtHeaderFooter) {
            Object child;
            ITableContent ftrTable;
            if (ftrObject instanceof ITableContent && (ftrTable = (ITableContent)ftrObject).getChildren().size() == 1 && (child = ftrTable.getChildren().toArray()[0]) instanceof IRowContent) {
                IRowContent row = (IRowContent)child;
                if (ftrTable.getColumnCount() <= 3) {
                    Object[] cellObjects = row.getChildren().toArray();
                    if (ftrTable.getColumnCount() == 1) {
                        poiHeaderFooter.setLeft(this.contentAsString(state, cellObjects[0]));
                        handledAsGrid = true;
                    } else if (ftrTable.getColumnCount() == 2) {
                        poiHeaderFooter.setLeft(this.contentAsString(state, cellObjects[0]));
                        poiHeaderFooter.setRight(this.contentAsString(state, cellObjects[1]));
                        handledAsGrid = true;
                    } else if (ftrTable.getColumnCount() == 3) {
                        poiHeaderFooter.setLeft(this.contentAsString(state, cellObjects[0]));
                        poiHeaderFooter.setCenter(this.contentAsString(state, cellObjects[1]));
                        poiHeaderFooter.setRight(this.contentAsString(state, cellObjects[2]));
                        handledAsGrid = true;
                    }
                }
            }
            if (handledAsGrid) continue;
            poiHeaderFooter.setLeft(this.contentAsString(state, ftrObject));
        }
    }

    private void outputStructuredHeaderFooter(HandlerState state, Collection birtHeaderFooter) throws BirtException {
        ContentEmitterVisitor visitor = new ContentEmitterVisitor(state.getEmitter());
        for (Object content : birtHeaderFooter) {
            if (!(content instanceof IContent)) continue;
            visitor.visit((IContent)content, null);
        }
    }

    @Override
    public void startPage(HandlerState state, IPageContent page) throws BirtException {
        int printScale;
        int pagesWide;
        int pagesHigh;
        if (state.getWb().getNumberOfSheets() > 0) {
            if (EmitterServices.booleanOption((ITaskOption)state.getRenderOptions(), (IContent)page, "ExcelEmitter.SingleSheetWithPageBreaks", false)) {
                state.currentSheet.setRowBreak(state.rowNum - 1);
            }
            if (EmitterServices.booleanOption((ITaskOption)state.getRenderOptions(), (IContent)page, "ExcelEmitter.SingleSheet", false)) {
                return;
            }
        }
        state.currentSheet = state.getWb().createSheet();
        this.log.debug("Page type: ", page.getPageType());
        if (page.getPageType() != null) {
            this.setupPageSize(state, page);
        }
        if (EmitterServices.booleanOption((ITaskOption)state.getRenderOptions(), (IContent)page, "ExcelEmitter.DisplayFormulas", false)) {
            state.currentSheet.setDisplayFormulas(true);
        }
        if (!EmitterServices.booleanOption((ITaskOption)state.getRenderOptions(), (IContent)page, "ExcelEmitter.DisplayGridlines", true)) {
            state.currentSheet.setDisplayGridlines(false);
        }
        if (!EmitterServices.booleanOption((ITaskOption)state.getRenderOptions(), (IContent)page, "ExcelEmitter.DisplayRowColHeadings", true)) {
            state.currentSheet.setDisplayRowColHeadings(false);
        }
        if (!EmitterServices.booleanOption((ITaskOption)state.getRenderOptions(), (IContent)page, "ExcelEmitter.DisplayZeros", true)) {
            state.currentSheet.setDisplayZeros(false);
        }
        if ((pagesHigh = EmitterServices.integerOption((ITaskOption)state.getRenderOptions(), (IContent)page, "ExcelEmitter.PrintPagesHigh", -1)) > 0 && pagesHigh < Short.MAX_VALUE) {
            state.currentSheet.getPrintSetup().setFitHeight((short)pagesHigh);
            state.currentSheet.setAutobreaks(true);
        }
        if ((pagesWide = EmitterServices.integerOption((ITaskOption)state.getRenderOptions(), (IContent)page, "ExcelEmitter.PrintPagesWide", -1)) > 0 && pagesWide < Short.MAX_VALUE) {
            state.currentSheet.getPrintSetup().setFitWidth((short)pagesWide);
            state.currentSheet.setAutobreaks(true);
        }
        if ((printScale = EmitterServices.integerOption((ITaskOption)state.getRenderOptions(), (IContent)page, "ExcelEmitter.PrintScale", -1)) > 0 && printScale < Short.MAX_VALUE) {
            state.currentSheet.getPrintSetup().setScale((short)printScale);
        }
        if (EmitterServices.booleanOption((ITaskOption)state.getRenderOptions(), (IContent)page, "ExcelEmitter.StructuredHeader", false)) {
            this.outputStructuredHeaderFooter(state, page.getHeader());
        } else {
            this.processHeaderFooter(state, page.getHeader(), (HeaderFooter)state.currentSheet.getHeader());
            this.processHeaderFooter(state, page.getFooter(), (HeaderFooter)state.currentSheet.getFooter());
        }
        state.getSmu().prepareMarginDimensions(state.currentSheet, page);
    }

    private String prepareSheetName(HandlerState state) {
        if (state.sheetName != null) {
            String preparedName = state.sheetName;
            Integer nameCount = state.sheetNames.get(preparedName);
            if (nameCount != null) {
                nameCount = nameCount + 1;
                state.sheetNames.put(preparedName, nameCount);
                preparedName = String.valueOf(preparedName) + " " + nameCount;
            } else {
                state.sheetNames.put(preparedName, 1);
            }
            return preparedName;
        }
        return null;
    }

    @Override
    public void endPage(HandlerState state, IPageContent page) throws BirtException {
        String sheetName;
        if (EmitterServices.booleanOption((ITaskOption)state.getRenderOptions(), (IContent)page, "ExcelEmitter.SingleSheet", false) && !state.reportEnding) {
            return;
        }
        if (EmitterServices.booleanOption((ITaskOption)state.getRenderOptions(), (IContent)page, "ExcelEmitter.StructuredHeader", false)) {
            this.outputStructuredHeaderFooter(state, page.getFooter());
        }
        if ((sheetName = this.prepareSheetName(state)) != null) {
            this.log.debug("Attempting to name sheet ", state.getWb().getNumberOfSheets() - 1, " \"", sheetName, "\" ");
            int existingSheetIndex = -1;
            int i = 0;
            while (i < state.getWb().getNumberOfSheets() - 1) {
                if (state.getWb().getSheetName(i).equals(sheetName)) {
                    this.log.debug("Found matching sheet at ", i, " \"", state.getWb().getSheetName(i), "\"");
                    existingSheetIndex = i;
                    break;
                }
                ++i;
            }
            if (existingSheetIndex >= 0) {
                this.log.debug("Deleting sheet at ", existingSheetIndex, " \"", state.getWb().getSheetName(existingSheetIndex), "\"");
                state.getWb().removeSheetAt(existingSheetIndex);
            }
            state.getWb().setSheetName(state.getWb().getNumberOfSheets() - 1, sheetName);
            if (existingSheetIndex >= 0) {
                state.getWb().setSheetOrder(sheetName, existingSheetIndex);
            }
            state.sheetName = null;
        }
        if (state.sheetPassword != null) {
            this.log.debug("Attempting to protect sheet ", state.getWb().getNumberOfSheets() - 1);
            state.currentSheet.protectSheet(state.sheetPassword);
            state.sheetPassword = null;
        }
        Drawing drawing = null;
        if (!state.images.isEmpty()) {
            drawing = state.currentSheet.createDrawingPatriarch();
        }
        for (CellImage cellImage : state.images) {
            this.processCellImage(state, drawing, cellImage);
        }
        state.images.clear();
        state.rowNum = 0;
        state.colNum = 0;
        state.clearRowSpans();
        state.areaBorders.clear();
        state.currentSheet = null;
    }

    private CellRangeAddress getMergedRegionBegunBy(Sheet sheet, int row, int col) {
        int i = 0;
        while (i < sheet.getNumMergedRegions()) {
            CellRangeAddress range = sheet.getMergedRegion(i);
            if (range.getFirstColumn() == col && range.getFirstRow() == row) {
                return range;
            }
            ++i;
        }
        return null;
    }

    private void processCellImage(HandlerState state, Drawing drawing, CellImage cellImage) {
        Coordinate location = cellImage.location;
        Cell cell = state.currentSheet.getRow(location.getRow()).getCell(location.getCol());
        IImageContent image = cellImage.image;
        StyleManagerUtils smu = state.getSmu();
        float ptHeight = cell.getRow().getHeightInPoints();
        if (image.getHeight() != null) {
            ptHeight = smu.fontSizeInPoints(image.getHeight().toString());
        }
        int endCol = cell.getColumnIndex();
        double lastColWidth = ClientAnchorConversions.widthUnits2Millimetres((short)state.currentSheet.getColumnWidth(endCol)) + 2.0;
        int dx = smu.anchorDxFromMM(lastColWidth, lastColWidth);
        double mmWidth = 0.0;
        if (smu.isAbsolute(image.getWidth())) {
            mmWidth = image.getWidth().convertTo("mm");
        } else if (smu.isPixels(image.getWidth())) {
            mmWidth = ClientAnchorConversions.pixels2Millimetres(image.getWidth().getMeasure());
        }
        CellRangeAddress mergedRegion = this.getMergedRegionBegunBy(state.currentSheet, location.getRow(), location.getCol());
        if (cellImage.spanColumns || mergedRegion != null) {
            this.log.debug("Image size: ", image.getWidth(), " translates as mmWidth = ", mmWidth);
            if (mmWidth > 0.0) {
                double mmAccumulatedWidth = 0.0;
                int endColLimit = cellImage.spanColumns ? 256 : mergedRegion.getLastColumn();
                endCol = cell.getColumnIndex();
                while (mmAccumulatedWidth < mmWidth && endCol < endColLimit) {
                    lastColWidth = ClientAnchorConversions.widthUnits2Millimetres((short)state.currentSheet.getColumnWidth(endCol)) + 2.0;
                    this.log.debug("lastColWidth = ", lastColWidth, "; mmAccumulatedWidth = ", mmAccumulatedWidth += lastColWidth);
                    ++endCol;
                }
                if (mmAccumulatedWidth > mmWidth) {
                    --endCol;
                    double mmShort = mmWidth - (mmAccumulatedWidth -= lastColWidth);
                    dx = smu.anchorDxFromMM(mmShort, lastColWidth);
                }
            }
        } else {
            float widthRatio = (float)(mmWidth / lastColWidth);
            ptHeight /= widthRatio;
        }
        int rowsSpanned = state.findRowsSpanned(cell.getRowIndex(), cell.getColumnIndex());
        float neededRowHeightPoints = ptHeight;
        int i = 0;
        while (i < rowsSpanned) {
            int rowIndex = cell.getRowIndex() + 1 + i;
            neededRowHeightPoints -= state.currentSheet.getRow(rowIndex).getHeightInPoints();
            ++i;
        }
        if (neededRowHeightPoints > cell.getRow().getHeightInPoints()) {
            cell.getRow().setHeightInPoints(neededRowHeightPoints);
        }
        ClientAnchor anchor = state.getWb().getCreationHelper().createClientAnchor();
        anchor.setCol1(cell.getColumnIndex());
        anchor.setRow1(cell.getRowIndex());
        anchor.setCol2(endCol);
        anchor.setRow2(cell.getRowIndex() + rowsSpanned);
        anchor.setDx2(dx);
        anchor.setDy2(smu.anchorDyFromPoints(ptHeight, cell.getRow().getHeightInPoints()));
        anchor.setAnchorType(2);
        drawing.createPicture(anchor, cellImage.imageIdx);
    }

    @Override
    public void startList(HandlerState state, IListContent list) throws BirtException {
        state.setHandler(new TopLevelListHandler(this.log, (IHandler)this, list));
        state.getHandler().startList(state, list);
    }

    @Override
    public void startTable(HandlerState state, ITableContent table) throws BirtException {
        state.setHandler(new TopLevelTableHandler(this.log, (IHandler)this, table));
        state.getHandler().startTable(state, table);
    }

    @Override
    public void emitText(HandlerState state, ITextContent text) throws BirtException {
        state.setHandler(new TopLevelContentHandler(state.getEmitter(), this.log, this));
        state.getHandler().emitText(state, text);
    }

    @Override
    public void emitData(HandlerState state, IDataContent data) throws BirtException {
        state.setHandler(new TopLevelContentHandler(state.getEmitter(), this.log, this));
        state.getHandler().emitData(state, data);
    }

    @Override
    public void emitLabel(HandlerState state, ILabelContent label) throws BirtException {
        state.setHandler(new TopLevelContentHandler(state.getEmitter(), this.log, this));
        state.getHandler().emitLabel(state, label);
    }

    @Override
    public void emitAutoText(HandlerState state, IAutoTextContent autoText) throws BirtException {
        state.setHandler(new TopLevelContentHandler(state.getEmitter(), this.log, this));
        state.getHandler().emitAutoText(state, autoText);
    }

    @Override
    public void emitForeign(HandlerState state, IForeignContent foreign) throws BirtException {
        state.setHandler(new TopLevelContentHandler(state.getEmitter(), this.log, this));
        state.getHandler().emitForeign(state, foreign);
    }

    @Override
    public void emitImage(HandlerState state, IImageContent image) throws BirtException {
        state.setHandler(new TopLevelContentHandler(state.getEmitter(), this.log, this));
        state.getHandler().emitImage(state, image);
    }
}

