/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.communication.core.proxyselector;

import java.io.IOException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.riena.internal.communication.core.proxyselector.ProxySelectorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManualProxySelector
extends ProxySelector
implements IExecutableExtension {
    public static final String RIENA_MANUAL_PROXIES = "riena.manualproxies";
    private final List<Proxy> universalProxies = new ArrayList<Proxy>();
    private final Map<String, List<Proxy>> protocolSpecificProxies = new HashMap<String, List<Proxy>>();

    public ManualProxySelector() throws CoreException {
        String data = System.getProperty(RIENA_MANUAL_PROXIES);
        this.setInitializationData(null, null, data);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (!(data != null && data instanceof String && this.universalProxies.isEmpty() && this.protocolSpecificProxies.isEmpty())) {
            return;
        }
        try {
            ProxySelectorUtils.fillProxies((String)data, this.universalProxies, this.protocolSpecificProxies);
        }
        catch (IllegalArgumentException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.riena.communication.core", "Bad configuration.", (Throwable)e));
        }
    }

    @Override
    public List<Proxy> select(URI uri) {
        if (!this.protocolSpecificProxies.isEmpty()) {
            List<Proxy> proxies = this.protocolSpecificProxies.get(uri.getScheme());
            return proxies != null ? proxies : ProxySelectorUtils.NO_PROXY_LIST;
        }
        if (!this.universalProxies.isEmpty()) {
            return this.universalProxies;
        }
        return ProxySelectorUtils.NO_PROXY_LIST;
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
    }
}

