/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.communication.factory.hessian;

import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.riena.communication.core.RemoteServiceDescription;
import org.eclipse.riena.communication.core.factory.IRemoteServiceFactory;
import org.eclipse.riena.communication.core.factory.RemoteServiceReference;
import org.eclipse.riena.communication.core.hooks.ICallMessageContext;
import org.eclipse.riena.communication.core.hooks.ICallMessageContextAccessor;
import org.eclipse.riena.communication.core.progressmonitor.IRemoteProgressMonitorList;
import org.eclipse.riena.communication.core.progressmonitor.IRemoteProgressMonitorRegistry;
import org.eclipse.riena.core.wire.WireWith;
import org.eclipse.riena.internal.communication.factory.hessian.RemoteServiceFactoryHessianWiring;
import org.eclipse.riena.internal.communication.factory.hessian.RienaHessianProxyFactory;

@WireWith(value=RemoteServiceFactoryHessianWiring.class)
public class RemoteServiceFactoryHessian
implements IRemoteServiceFactory {
    private IRemoteProgressMonitorRegistry remoteProgressMonitorRegistry;
    private final ICallMessageContextAccessor messageContextAccessor = new CallMsgCtxAcc();
    private final RienaHessianProxyFactory rienaHessianProxyFactory = new RienaHessianProxyFactory();
    private static final String PROTOCOL = "hessian";
    private static final SecureRandom RANDOM = new SecureRandom();
    private static final long BASE_LONG = 115825100000L;

    public RemoteServiceFactoryHessian() {
        this.rienaHessianProxyFactory.setCallMessageContextAccessor(this.messageContextAccessor);
    }

    public RemoteServiceReference createProxy(RemoteServiceDescription endpoint) {
        String uri = endpoint.getURL();
        if (uri == null) {
            uri = "http://localhost/hessian" + endpoint.getPath();
        }
        try {
            Object proxy = this.rienaHessianProxyFactory.create(endpoint.getServiceInterfaceClass(), uri);
            RemoteServiceReference serviceReference = new RemoteServiceReference(endpoint);
            serviceReference.setServiceInstance(proxy);
            return serviceReference;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("MalformedURLException", e);
        }
    }

    public void bind(IRemoteProgressMonitorRegistry pmr) {
        this.remoteProgressMonitorRegistry = pmr;
    }

    public void unbind(IRemoteProgressMonitorRegistry pmr) {
        if (this.remoteProgressMonitorRegistry == pmr) {
            this.remoteProgressMonitorRegistry = null;
        }
    }

    public String getProtocol() {
        return PROTOCOL;
    }

    public ICallMessageContextAccessor getMessageContextAccessor() {
        return this.messageContextAccessor;
    }

    class CallMsgCtxAcc
    implements ICallMessageContextAccessor {
        private ThreadLocal<ICallMessageContext> contexts = new ThreadLocal();

        CallMsgCtxAcc() {
        }

        public ICallMessageContext createMessageContext(Object proxy, String methodName, String requestId) {
            MsgCtx mc = new MsgCtx(proxy, methodName, requestId);
            this.contexts.set(mc);
            return mc;
        }

        public ICallMessageContext getMessageContext() {
            return this.contexts.get();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MsgCtx
        implements ICallMessageContext {
            private HashMap<String, List<String>> customRequestHeader;
            private IRemoteProgressMonitorList remoteProgressMonitorList;
            private int bytesRead;
            private int totalBytesRead = 0;
            private int bytesWritten;
            private int totalBytesWritten = 0;
            private boolean firstEvent = true;
            private String methodName;
            private String requestId = null;

            public MsgCtx(Object proxy, String methodName, String requestId) {
                this.methodName = methodName;
                this.requestId = requestId;
                this.remoteProgressMonitorList = RemoteServiceFactoryHessian.this.remoteProgressMonitorRegistry != null ? RemoteServiceFactoryHessian.this.remoteProgressMonitorRegistry.getProgressMonitors(proxy) : null;
            }

            public List<String> getResponseHeaderValues(String name) {
                Map<String, List<String>> headers = this.listResponseHeaders();
                if (headers == null) {
                    return null;
                }
                return headers.get(name);
            }

            public Map<String, List<String>> listRequestHeaders() {
                return this.customRequestHeader;
            }

            public Map<String, List<String>> listResponseHeaders() {
                HttpURLConnection httpUrlConnection = RienaHessianProxyFactory.getHttpURLConnection();
                if (httpUrlConnection == null) {
                    return null;
                }
                return httpUrlConnection.getHeaderFields();
            }

            public void addRequestHeader(String name, String value) {
                List<String> hValues;
                if (this.customRequestHeader == null) {
                    this.customRequestHeader = new HashMap();
                }
                if ((hValues = this.customRequestHeader.get(name)) == null) {
                    hValues = new ArrayList<String>();
                    this.customRequestHeader.put(name, hValues);
                }
                hValues.add(value);
            }

            public IRemoteProgressMonitorList getProgressMonitorList() {
                return this.remoteProgressMonitorList;
            }

            public void fireStartCall() {
                this.remoteProgressMonitorList.fireStartEvent();
                this.firstEvent = false;
            }

            public void fireEndCall() {
                if (this.totalBytesRead == 0 && this.totalBytesWritten == 0 && this.bytesRead == 0 && this.bytesWritten == 0) {
                    return;
                }
                if (this.bytesRead != 0) {
                    this.internalFireReadEvent();
                }
                this.remoteProgressMonitorList.fireEndEvent(this.totalBytesRead + this.totalBytesWritten);
            }

            public void fireReadEvent(int parmBytesRead) {
                if (this.firstEvent) {
                    this.remoteProgressMonitorList.fireStartEvent();
                    this.firstEvent = false;
                }
                if (this.bytesWritten != 0) {
                    this.internalFireWriteEvent();
                }
                this.bytesRead += parmBytesRead;
                if (this.bytesRead >= 512) {
                    this.internalFireReadEvent();
                }
            }

            private void internalFireReadEvent() {
                this.totalBytesRead += this.bytesRead;
                this.bytesRead = 0;
                this.remoteProgressMonitorList.fireReadEvent(-1, this.totalBytesRead);
            }

            public void fireWriteEvent(int parmBytesWritten) {
                if (this.firstEvent) {
                    this.fireStartCall();
                }
                this.bytesWritten += parmBytesWritten;
                if (this.bytesWritten >= 512) {
                    this.internalFireWriteEvent();
                }
            }

            private void internalFireWriteEvent() {
                this.totalBytesWritten += this.bytesWritten;
                this.bytesWritten = 0;
                this.remoteProgressMonitorList.fireWriteEvent(-1, this.totalBytesWritten);
            }

            public String getMethodName() {
                return this.methodName;
            }

            public String getRequestId() {
                if (this.requestId == null || this.requestId.length() == 0) {
                    int i = RANDOM.nextInt();
                    if (i == Integer.MIN_VALUE) {
                        ++i;
                    }
                    this.requestId = "RID-" + Long.toString(System.currentTimeMillis() - 115825100000L + (long)Math.abs(i), 36);
                }
                return this.requestId;
            }
        }
    }
}

