/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core;

import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.RienaStatus;
import org.eclipse.riena.core.logging.ConsoleLogger;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Log4r {
    private Log4r() {
    }

    public static Logger getLogger(IRienaActivator activator, Class<?> clazz) {
        if (activator != null) {
            return activator.getLogger(clazz);
        }
        return Log4r.getEmergencyLogger(clazz.getName());
    }

    public static Logger getLogger(IRienaActivator activator, String className) {
        if (activator != null) {
            return activator.getLogger(className);
        }
        return Log4r.getEmergencyLogger(className);
    }

    private static Logger getEmergencyLogger(String className) {
        return RienaStatus.isDevelopment() ? new ConsoleLogger(className) : new NullLogger();
    }

    private static class NullLogger
    implements Logger {
        private NullLogger() {
        }

        public String getName() {
            return "NullLogger";
        }

        public boolean isLoggable(int level) {
            return false;
        }

        public void log(int level, String message) {
        }

        public void log(int level, String message, Throwable exception) {
        }

        public void log(ServiceReference sr, int level, String message) {
        }

        public void log(ServiceReference sr, int level, String message, Throwable exception) {
        }

        public void log(Object context, int level, String message) {
        }

        public void log(Object context, int level, String message, Throwable exception) {
        }
    }
}

