/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.cache;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.cache.IGenericObjectCache;
import org.eclipse.riena.internal.core.Activator;
import org.eclipse.riena.internal.core.cache.ICacheEntry;
import org.eclipse.riena.internal.core.cache.SoftCacheEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericObjectCache<K, V>
implements IGenericObjectCache<K, V> {
    private HashMap<K, ICacheEntry<K, V>> cacheEntries;
    private long timeout;
    private int minimumSize;
    private LinkedList<V> hardLinks;
    private ReferenceQueue<V> queue;
    private int statHit;
    private int statNotFound;
    private int statMiss;
    private int statTimeout;
    private static int statDisplayCount;
    private String name = "Cache : ";
    private static final Logger LOGGER;

    static {
        LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), GenericObjectCache.class);
    }

    public GenericObjectCache() {
        LOGGER.log(4, "creating new GenericObjectCache instance");
        this.cacheEntries = new HashMap();
        this.queue = new ReferenceQueue();
        this.hardLinks = new LinkedList();
        this.setTimeout(60000);
    }

    @Override
    public void setName(String name) {
        this.name = String.valueOf(name) + " : ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) {
        LOGGER.log(4, "get = " + key);
        long timestamp = 0L;
        V value = null;
        HashMap<K, ICacheEntry<K, V>> hashMap = this.cacheEntries;
        synchronized (hashMap) {
            ICacheEntry<K, V> entry;
            block7: {
                block6: {
                    entry = this.cacheEntries.get(key);
                    if (entry != null) break block6;
                    ++this.statNotFound;
                    this.printStat();
                    return null;
                }
                timestamp = entry.getTimestamp();
                long timePassed = System.currentTimeMillis() - timestamp;
                if (timePassed <= this.timeout) break block7;
                this.remove(key);
                ++this.statTimeout;
                this.printStat();
                return null;
            }
            value = entry.getValue();
        }
        if (value != null) {
            this.touchValue(value);
            ++this.statHit;
            this.printStat();
            return value;
        }
        this.remove(key);
        ++this.statMiss;
        this.printStat();
        return null;
    }

    private void printStat() {
        if (++statDisplayCount > 100) {
            LOGGER.log(3, String.valueOf(this.name) + "Hit / NotFound / Miss / Timeout " + this.statHit + " / " + this.statNotFound + " / " + this.statMiss + " / " + this.statTimeout);
            statDisplayCount = 0;
        }
    }

    @Override
    public String getStatistic() {
        return String.valueOf(this.name) + "Hit / NotFound / Miss / Timeout " + this.statHit + " / " + this.statNotFound + " / " + this.statMiss + " / " + this.statTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void touchValue(V value) {
        if (this.minimumSize > 0) {
            LinkedList<V> linkedList = this.hardLinks;
            synchronized (linkedList) {
                this.hardLinks.addFirst(value);
                if (this.hardLinks.size() > this.minimumSize) {
                    this.hardLinks.removeLast();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K key, V value) {
        LOGGER.log(4, "put = " + key + " , " + value);
        this.processQueue();
        SoftCacheEntry<K, V> entry = new SoftCacheEntry<K, V>(value, key, this.queue);
        HashMap<K, ICacheEntry<K, V>> hashMap = this.cacheEntries;
        synchronized (hashMap) {
            this.cacheEntries.put(key, entry);
        }
        this.touchValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        LOGGER.log(4, "clear");
        Cloneable cloneable = this.hardLinks;
        synchronized (cloneable) {
            this.hardLinks.clear();
        }
        this.processQueue();
        cloneable = this.cacheEntries;
        synchronized (cloneable) {
            this.cacheEntries.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(K key) {
        LOGGER.log(4, "remove = " + key);
        this.processQueue();
        HashMap<K, ICacheEntry<K, V>> hashMap = this.cacheEntries;
        synchronized (hashMap) {
            this.cacheEntries.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        this.processQueue();
        HashMap<K, ICacheEntry<K, V>> hashMap = this.cacheEntries;
        synchronized (hashMap) {
            LOGGER.log(4, "size returned = " + this.cacheEntries.size());
            return this.cacheEntries.size();
        }
    }

    @Override
    public void setTimeout(int milliseconds) {
        LOGGER.log(4, "setTimeout = " + milliseconds);
        this.timeout = milliseconds;
    }

    @Override
    public int getTimeout() {
        return (int)this.timeout;
    }

    @Override
    public int getMinimumSize() {
        return this.minimumSize;
    }

    @Override
    public int getSize() {
        return this.size();
    }

    @Override
    public void setMinimumSize(int minSize) {
        LOGGER.log(4, "setMinSize = " + minSize);
        this.minimumSize = minSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processQueue() {
        LOGGER.log(4, "processQueue");
        int count = 0;
        HashMap<K, ICacheEntry<K, V>> hashMap = this.cacheEntries;
        synchronized (hashMap) {
            SoftReference ref;
            while ((ref = (SoftReference)this.queue.poll()) != null) {
                ICacheEntry entry = (ICacheEntry)ref.get();
                if (entry == null) continue;
                this.cacheEntries.remove(entry.getKey());
                ++count;
            }
        }
        if (count > 0) {
            LOGGER.log(3, "processQueue removed " + count + " entries");
        }
    }
}

