/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.controllers;

import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.ApplicationController;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.core.marker.ValidationTime;
import org.eclipse.riena.ui.ridgets.IBasicMarkableRidget;
import org.eclipse.riena.ui.ridgets.IStatuslineRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.riena.ui.ridgets.marker.StatuslineMessageMarkerViewer;
import org.eclipse.riena.ui.ridgets.marker.TooltipMessageMarkerViewer;
import org.eclipse.riena.ui.ridgets.validation.MaxLength;
import org.eclipse.riena.ui.ridgets.validation.MinLength;
import org.eclipse.riena.ui.ridgets.validation.RequiredField;
import org.eclipse.riena.ui.ridgets.validation.ValidCharacters;
import org.eclipse.riena.ui.ridgets.validation.ValidDate;
import org.eclipse.riena.ui.ridgets.validation.ValidEmailAddress;
import org.eclipse.riena.ui.ridgets.validation.ValidExpression;
import org.eclipse.riena.ui.ridgets.validation.ValidIntermediateDate;
import org.eclipse.riena.ui.ridgets.validation.ValidRange;

public class ValidationSubModuleController
extends SubModuleController {
    private static final String DATE_PATTERN = "dd.MM.yyyy";

    public ValidationSubModuleController() {
        this(null);
    }

    public ValidationSubModuleController(ISubModuleNode navigationNode) {
        super(navigationNode);
    }

    public void configureRidgets() {
        ITextRidget txtNumbersOnly = (ITextRidget)this.getRidget("txtNumbersOnly");
        ITextRidget txtNumbersOnlyDW = (ITextRidget)this.getRidget("txtNumbersOnlyDW");
        ITextRidget txtCharactersOnly = (ITextRidget)this.getRidget("txtCharactersOnly");
        ITextRidget txtExpression = (ITextRidget)this.getRidget("txtExpression");
        ITextRidget txtLengthLessThan5 = (ITextRidget)this.getRidget("txtLengthLessThan5");
        ITextRidget txtRequiredLowercase = (ITextRidget)this.getRidget("txtRequiredLowercase");
        ITextRidget txtRange18to80 = (ITextRidget)this.getRidget("txtRange18to80");
        ITextRidget txtLength5to10 = (ITextRidget)this.getRidget("txtLength5to10");
        ITextRidget txtDate = (ITextRidget)this.getRidget("txtDate");
        ITextRidget txtEmail = (ITextRidget)this.getRidget("txtEmail");
        ITextRidget lblNumbersOnly = (ITextRidget)this.getRidget("lblNumbersOnly");
        ITextRidget lblNumbersOnlyDW = (ITextRidget)this.getRidget("lblNumbersOnlyDW");
        ITextRidget lblCharactersOnly = (ITextRidget)this.getRidget("lblCharactersOnly");
        ITextRidget lblExpression = (ITextRidget)this.getRidget("lblExpression");
        ITextRidget lblLengthLessThan5 = (ITextRidget)this.getRidget("lblLengthLessThan5");
        ITextRidget lblRequiredLowercase = (ITextRidget)this.getRidget("lblRequiredLowercase");
        ITextRidget lblRange18to80 = (ITextRidget)this.getRidget("lblRange18to80");
        ITextRidget lblLength5to10 = (ITextRidget)this.getRidget("lblLength5to10");
        ITextRidget lblDate = (ITextRidget)this.getRidget("lblDate");
        ITextRidget lblEmail = (ITextRidget)this.getRidget("lblEmail");
        this.makeOutputOnly(lblNumbersOnly, lblNumbersOnlyDW, lblCharactersOnly, lblExpression, lblLengthLessThan5, lblRequiredLowercase, lblRange18to80, lblLength5to10, lblDate, lblEmail);
        txtNumbersOnly.addValidationRule((IValidator)new ValidCharacters("0123456789"), ValidationTime.ON_UI_CONTROL_EDIT);
        txtNumbersOnly.addValidationMessage("Only numbers are allowed!");
        txtNumbersOnly.bindToModel(this.getTextValue(lblNumbersOnly));
        txtNumbersOnlyDW.addValidationRule((IValidator)new ValidCharacters("0123456789"), ValidationTime.ON_UI_CONTROL_EDIT);
        txtNumbersOnlyDW.addValidationMessage("Only numbers are allowed!");
        txtNumbersOnlyDW.setDirectWriting(true);
        txtNumbersOnlyDW.bindToModel(this.getTextValue(lblNumbersOnlyDW));
        txtCharactersOnly.addValidationRule((IValidator)new ValidCharacters("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz"), ValidationTime.ON_UI_CONTROL_EDIT);
        txtCharactersOnly.addValidationMessage("Only characters are allowed!");
        txtCharactersOnly.bindToModel(this.getTextValue(lblCharactersOnly));
        txtExpression.addValidationRule((IValidator)new ValidExpression("^PDX[0-9]{2}$", new ValidExpression.Option[0]), ValidationTime.ON_UI_CONTROL_EDIT);
        txtExpression.addValidationMessage("The text does not match with the expression (PDX##)!");
        txtExpression.bindToModel(this.getTextValue(lblExpression));
        txtExpression.setText("PDX97");
        txtLengthLessThan5.addValidationRule((IValidator)new MaxLength(5), ValidationTime.ON_UI_CONTROL_EDIT);
        txtLengthLessThan5.addValidationMessage("The text is longer than 5 characters!");
        txtLengthLessThan5.bindToModel(this.getTextValue(lblLengthLessThan5));
        txtRequiredLowercase.addValidationRule((IValidator)new RequiredField(), ValidationTime.ON_UI_CONTROL_EDIT);
        txtRequiredLowercase.addValidationRule((IValidator)new ValidCharacters("abcdefghijklmnopqrstuvwxyz"), ValidationTime.ON_UI_CONTROL_EDIT);
        txtRequiredLowercase.addValidationMessage("Only lowercase characters are allowed!");
        txtRequiredLowercase.bindToModel(this.getTextValue(lblRequiredLowercase));
        txtRange18to80.addValidationRule((IValidator)new RequiredField(), ValidationTime.ON_UPDATE_TO_MODEL);
        txtRange18to80.addValidationRule((IValidator)new ValidRange((Number)18, (Number)80), ValidationTime.ON_UPDATE_TO_MODEL);
        txtRange18to80.bindToModel(this.getTextValue(lblRange18to80));
        txtLength5to10.addValidationRule((IValidator)new MinLength(5), ValidationTime.ON_UPDATE_TO_MODEL);
        txtLength5to10.addValidationRule((IValidator)new MaxLength(10), ValidationTime.ON_UPDATE_TO_MODEL);
        txtLength5to10.bindToModel(this.getTextValue(lblLength5to10));
        txtDate.addValidationRule((IValidator)new ValidIntermediateDate(DATE_PATTERN), ValidationTime.ON_UI_CONTROL_EDIT);
        txtDate.addValidationRule((IValidator)new ValidDate(DATE_PATTERN), ValidationTime.ON_UPDATE_TO_MODEL);
        txtDate.setText("25.12.2008");
        txtDate.bindToModel(this.getTextValue(lblDate));
        txtEmail.addValidationRule((IValidator)new ValidEmailAddress(), ValidationTime.ON_UI_CONTROL_EDIT);
        txtEmail.bindToModel(this.getTextValue(lblEmail));
        txtEmail.setText("elmer@foo.bar");
        IStatuslineRidget statuslineRidget = this.getApplicationController().getStatusline();
        StatuslineMessageMarkerViewer statuslineMessageMarkerViewer = new StatuslineMessageMarkerViewer(statuslineRidget);
        statuslineMessageMarkerViewer.addRidget((IBasicMarkableRidget)txtNumbersOnly);
        statuslineMessageMarkerViewer.addRidget((IBasicMarkableRidget)txtNumbersOnlyDW);
        statuslineMessageMarkerViewer.addRidget((IBasicMarkableRidget)txtCharactersOnly);
        statuslineMessageMarkerViewer.addRidget((IBasicMarkableRidget)txtExpression);
        statuslineMessageMarkerViewer.addRidget((IBasicMarkableRidget)txtLengthLessThan5);
        statuslineMessageMarkerViewer.addRidget((IBasicMarkableRidget)txtRequiredLowercase);
        TooltipMessageMarkerViewer tooltipMessageMarkerViewer = new TooltipMessageMarkerViewer();
        tooltipMessageMarkerViewer.addRidget((IBasicMarkableRidget)txtNumbersOnly);
    }

    private IObservableValue getTextValue(ITextRidget bean) {
        return BeansObservables.observeValue((Object)bean, (String)"text");
    }

    private ApplicationController getApplicationController() {
        return (ApplicationController)((IApplicationNode)((ISubModuleNode)this.getNavigationNode()).getParentOfType(IApplicationNode.class)).getNavigationNodeController();
    }

    private void makeOutputOnly(ITextRidget ... ridgets) {
        ITextRidget[] iTextRidgetArray = ridgets;
        int n = ridgets.length;
        int n2 = 0;
        while (n2 < n) {
            ITextRidget ridget = iTextRidgetArray[n2];
            ridget.setOutputOnly(true);
            ridget.setEnabled(false);
            ++n2;
        }
    }
}

