/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.model;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.injector.Inject;
import org.eclipse.riena.internal.navigation.Activator;
import org.eclipse.riena.navigation.IAssemblerProvider;
import org.eclipse.riena.navigation.IGenericNavigationAssembler;
import org.eclipse.riena.navigation.IModuleGroupNodeExtension;
import org.eclipse.riena.navigation.IModuleNodeExtension;
import org.eclipse.riena.navigation.INavigationAssembler;
import org.eclipse.riena.navigation.INavigationAssemblyExtension;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.INavigationNodeProvider;
import org.eclipse.riena.navigation.ISubApplicationNodeExtension;
import org.eclipse.riena.navigation.ISubModuleNodeExtension;
import org.eclipse.riena.navigation.NavigationArgument;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.model.ExtensionPointFailure;
import org.eclipse.riena.navigation.model.GenericNavigationAssembler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigationNodeProvider
implements INavigationNodeProvider,
IAssemblerProvider {
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), NavigationNodeProvider.class);
    private static Random random = null;
    private Map<String, INavigationAssembler> assemblyId2AssemblerCache = new HashMap<String, INavigationAssembler>();

    public NavigationNodeProvider() {
        Inject.extension((String)this.getNavigationAssemblyExtensionPointSafe()).useType(this.getNavigationAssemblyExtensionIFSafe()).into((Object)this).andStart(Activator.getDefault().getContext());
    }

    private String getNavigationAssemblyExtensionPointSafe() {
        if (this.getNavigationAssemblyExtensionPoint() != null && this.getNavigationAssemblyExtensionPoint().trim().length() != 0) {
            return this.getNavigationAssemblyExtensionPoint();
        }
        return "org.eclipse.riena.navigation.assemblies";
    }

    public String getNavigationAssemblyExtensionPoint() {
        return "org.eclipse.riena.navigation.assemblies";
    }

    private Class<? extends INavigationAssemblyExtension> getNavigationAssemblyExtensionIFSafe() {
        if (this.getNavigationAssemblyExtensionIF() != null && this.getNavigationAssemblyExtensionIF().isInterface()) {
            return this.getNavigationAssemblyExtensionIF();
        }
        return INavigationAssemblyExtension.class;
    }

    public Class<? extends INavigationAssemblyExtension> getNavigationAssemblyExtensionIF() {
        return INavigationAssemblyExtension.class;
    }

    protected INavigationNode<?> provideNodeHook(INavigationNode<?> sourceNode, NavigationNodeId targetId, NavigationArgument argument) {
        INavigationNode<?> targetNode = this.findNode(this.getRootNode(sourceNode), targetId);
        if (targetNode == null) {
            INavigationAssembler assembler;
            if (LOGGER.isLoggable(4)) {
                LOGGER.log(4, "createNode: " + targetId);
            }
            if ((assembler = this.getNavigationAssembler(targetId, argument)) != null) {
                NavigationNodeId parentTypeId = this.getParentTypeId(argument, assembler);
                INavigationNode<?> parentNode = this.findNode(this.provideNodeHook(sourceNode, parentTypeId, null), parentTypeId);
                this.prepareNavigationAssembler(targetId, assembler, parentNode);
                targetNode = assembler.buildNode(targetId, argument);
                parentNode.addChild(targetNode);
            } else {
                throw new ExtensionPointFailure("No assembler found for ID=" + targetId.getTypeId());
            }
        }
        if (argument != null) {
            targetNode.setContext("riena.navigation.argument", argument);
        }
        return targetNode;
    }

    private NavigationNodeId getParentTypeId(NavigationArgument argument, INavigationAssembler assembler) {
        if (argument != null && argument.getParentNodeId() != null) {
            return argument.getParentNodeId();
        }
        String parentTypeId = assembler.getAssembly().getParentTypeId();
        if (parentTypeId == null || parentTypeId.length() == 0) {
            throw new ExtensionPointFailure("parentTypeId cannot be null or blank for assembly ID=" + assembler.getAssembly().getId());
        }
        return new NavigationNodeId(parentTypeId);
    }

    protected GenericNavigationAssembler createDefaultAssembler() {
        return new GenericNavigationAssembler();
    }

    @Override
    public INavigationNode<?> provideNode(INavigationNode<?> sourceNode, NavigationNodeId targetId, NavigationArgument argument) {
        return this.provideNodeHook(sourceNode, targetId, argument);
    }

    protected void prepareNavigationAssembler(NavigationNodeId targetId, INavigationAssembler assembler, INavigationNode<?> parentNode) {
        if (assembler instanceof IGenericNavigationAssembler) {
            ((IGenericNavigationAssembler)assembler).setAssemblerProvider(this);
        }
    }

    public Collection<INavigationAssembler> getNavigationAssemblers() {
        return this.assemblyId2AssemblerCache.values();
    }

    public void registerNavigationAssembler(String id, INavigationAssembler assembler) {
        this.assemblyId2AssemblerCache.put(id, assembler);
    }

    @Override
    public INavigationAssembler getNavigationAssembler(String assemblyId) {
        return this.assemblyId2AssemblerCache.get(assemblyId);
    }

    public INavigationAssembler getNavigationAssembler(NavigationNodeId nodeId, NavigationArgument argument) {
        if (nodeId != null && nodeId.getTypeId() != null) {
            for (INavigationAssembler probe : this.getNavigationAssemblers()) {
                if (!probe.acceptsToBuildNode(nodeId, argument)) continue;
                return probe;
            }
        }
        return null;
    }

    protected INavigationNode<?> getRootNode(INavigationNode<?> node) {
        if (node.getParent() == null) {
            return node;
        }
        return this.getRootNode(node.getParent());
    }

    protected INavigationNode<?> findNode(INavigationNode<?> node, NavigationNodeId targetId) {
        if (targetId == null) {
            return null;
        }
        if (targetId.equals(node.getNodeId())) {
            return node;
        }
        for (INavigationNode child : node.getChildren()) {
            INavigationNode<?> foundNode = this.findNode(child, targetId);
            if (foundNode == null) continue;
            return foundNode;
        }
        return null;
    }

    public void register(INavigationAssemblyExtension assembly) {
        INavigationAssembler assembler;
        String assemblyId = assembly.getId();
        if (assemblyId == null) {
            if (random == null) {
                try {
                    random = SecureRandom.getInstance("SHA1PRNG");
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    random = new Random(System.currentTimeMillis());
                }
            }
            assemblyId = "Riena.random.assemblyid." + Long.valueOf(random.nextLong()).toString();
            LOGGER.log(2, "Assembly has no id. Generated a random '" + assemblyId + "'. For Assembler=" + assembly.getNavigationAssembler());
        }
        if ((assembler = assembly.createNavigationAssembler()) == null) {
            assembler = this.createDefaultAssembler();
        }
        assembler.setAssembly(assembly);
        this.registerNavigationAssembler(assemblyId, assembler);
        if (assembly.getSubApplicationNode() != null) {
            this.register(assembly.getSubApplicationNode(), assembler, assembly);
        }
        if (assembly.getModuleGroupNode() != null) {
            this.register(assembly.getModuleGroupNode(), assembler, assembly);
        }
        if (assembly.getModuleNode() != null) {
            this.register(assembly.getModuleNode(), assembler, assembly);
        }
        if (assembly.getSubModuleNode() != null) {
            this.register(assembly.getSubModuleNode(), assembler, assembly);
        }
    }

    public void register(ISubApplicationNodeExtension subapplication, INavigationAssembler assembler, INavigationAssemblyExtension assembly) {
        IModuleGroupNodeExtension[] iModuleGroupNodeExtensionArray = subapplication.getModuleGroupNodes();
        int n = iModuleGroupNodeExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IModuleGroupNodeExtension group = iModuleGroupNodeExtensionArray[n2];
            this.register(group, assembler, assembly);
            ++n2;
        }
    }

    public void register(IModuleGroupNodeExtension group, INavigationAssembler assembler, INavigationAssemblyExtension assembly) {
        IModuleNodeExtension[] iModuleNodeExtensionArray = group.getModuleNodes();
        int n = iModuleNodeExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IModuleNodeExtension module = iModuleNodeExtensionArray[n2];
            this.register(module, assembler, assembly);
            ++n2;
        }
    }

    public void register(IModuleNodeExtension module, INavigationAssembler assembler, INavigationAssemblyExtension assembly) {
        ISubModuleNodeExtension[] iSubModuleNodeExtensionArray = module.getSubModuleNodes();
        int n = iSubModuleNodeExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISubModuleNodeExtension submodule = iSubModuleNodeExtensionArray[n2];
            this.register(submodule, assembler, assembly);
            ++n2;
        }
    }

    public void register(ISubModuleNodeExtension submodule, INavigationAssembler assembler, INavigationAssemblyExtension assembly) {
        ISubModuleNodeExtension[] iSubModuleNodeExtensionArray = submodule.getSubModuleNodes();
        int n = iSubModuleNodeExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISubModuleNodeExtension nestedSubmodule = iSubModuleNodeExtensionArray[n2];
            this.register(nestedSubmodule, assembler, assembly);
            ++n2;
        }
    }

    @Override
    public void cleanUp() {
    }

    public void update(INavigationAssemblyExtension[] data) {
        this.cleanUp();
        INavigationAssemblyExtension[] iNavigationAssemblyExtensionArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            INavigationAssemblyExtension assembly = iNavigationAssemblyExtensionArray[n2];
            this.register(assembly);
            ++n2;
        }
    }
}

