/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.model;

import org.eclipse.riena.core.injector.extension.ExtensionInterface;
import org.eclipse.riena.core.wire.Wire;
import org.eclipse.riena.core.wire.WireWith;
import org.eclipse.riena.internal.navigation.Activator;
import org.eclipse.riena.navigation.INavigationNodeProvider;
import org.eclipse.riena.navigation.model.NavigationNodeProviderAccessorWiring;

@WireWith(value=NavigationNodeProviderAccessorWiring.class)
public final class NavigationNodeProviderAccessor {
    private static boolean initialized;
    private static final NavigationNodeProviderAccessor NNPA;
    private INavigationNodeProvider provider;

    static {
        NNPA = new NavigationNodeProviderAccessor();
    }

    private NavigationNodeProviderAccessor() {
    }

    public static INavigationNodeProvider getNavigationNodeProvider() {
        return NNPA.getProvider();
    }

    private synchronized INavigationNodeProvider getProvider() {
        if (!initialized) {
            this.initialize();
            initialized = true;
        }
        return this.provider;
    }

    private void initialize() {
        Wire.instance((Object)this).andStart(Activator.getDefault().getContext());
    }

    public void update(INavigationNodeProviderExtension[] availableExtensions) {
        if (this.provider != null) {
            this.provider.cleanUp();
        }
        INavigationNodeProviderExtension found = null;
        int maxPriority = Integer.MIN_VALUE;
        this.provider = null;
        INavigationNodeProviderExtension[] iNavigationNodeProviderExtensionArray = availableExtensions;
        int n = availableExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            INavigationNodeProviderExtension probe = iNavigationNodeProviderExtensionArray[n2];
            int p = probe.getPriority();
            if (found == null || p > maxPriority) {
                found = probe;
                maxPriority = p;
            }
            ++n2;
        }
        if (found != null) {
            this.provider = found.createClass();
        }
    }

    @ExtensionInterface
    public static interface INavigationNodeProviderExtension {
        public String getId();

        public int getPriority();

        public INavigationNodeProvider createClass();
    }
}

