/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.communication.core.attachment;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import org.eclipse.riena.communication.core.IRemoteServiceRegistration;
import org.eclipse.riena.communication.core.factory.Register;
import org.eclipse.riena.sample.app.common.calendar.ITestGregorianCalendar;
import org.eclipse.riena.tests.RienaTestCase;
import org.eclipse.riena.tests.collect.ManualTestCase;

@ManualTestCase
public final class GregorianCalendarITest
extends RienaTestCase {
    private ITestGregorianCalendar calendarService;
    private IRemoteServiceRegistration regCalenderService;

    public void setUp() throws Exception {
        super.setUp();
        this.regCalenderService = Register.remoteProxy(ITestGregorianCalendar.class).usingUrl("http://localhost:8080/hessian/TestGregorianCalendarWS").withProtocol("hessian").andStart(this.getContext());
        this.calendarService = (ITestGregorianCalendar)this.getContext().getService(this.getContext().getServiceReference(ITestGregorianCalendar.class.getName()));
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.regCalenderService.unregister();
        this.calendarService = null;
    }

    public void testDiffGregorian() {
        GregorianCalendar from = new GregorianCalendar(2007, 1, 6);
        GregorianCalendar till = new GregorianCalendar(2007, 1, 7);
        long diff = this.calendarService.diffTimes1(from, till);
        GregorianCalendarITest.assertEquals((long)86400000L, (long)diff);
    }

    public void testDiffDate() throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");
        Date from = dateFormat.parse("6.1.2007");
        Date till = dateFormat.parse("7.1.2007");
        long diff = this.calendarService.diffTimes2(from, till);
        GregorianCalendarITest.assertEquals((long)86400000L, (long)diff);
    }
}

