/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.communication.core.ssl;

import java.io.File;
import java.io.IOException;
import org.eclipse.riena.core.wire.Wire;
import org.eclipse.riena.internal.communication.core.ssl.ISSLProperties;
import org.eclipse.riena.internal.communication.core.ssl.SSLConfiguration;
import org.eclipse.riena.internal.tests.Activator;
import org.eclipse.riena.tests.RienaTestCase;
import org.eclipse.riena.tests.collect.NonUITestCase;
import org.eclipse.riena.tests.nanohttp.TestServer;
import org.osgi.framework.Bundle;

@NonUITestCase
public class SSLConfigurationTest
extends RienaTestCase {
    public void testZeroConfiguration() {
        this.printTestName();
        SSLConfiguration config = new SSLConfiguration();
        SSLConfigurationTest.assertEquals((String)"SSLConfiguration: null, null", (String)config.toString());
    }

    public void testOneConfiguration() {
        this.printTestName();
        this.addPluginXml(SSLConfigurationTest.class, "plugin.xml");
        SSLConfiguration config = new SSLConfiguration();
        Wire.instance((Object)config).andStart(this.getContext());
        SSLConfigurationTest.assertEquals((String)"SSLConfiguration: TLSv1, #jre-cacerts#", (String)config.toString());
        this.removeExtension("org.eclipse.riena.communication.core.ssl.test");
    }

    public void testLocateKeystoreJreCacerts() {
        this.printTestName();
        SSLProperties properties = new SSLProperties("TLSv1", "#jre-cacerts#", "changeit");
        SSLConfiguration config = new SSLConfiguration();
        config.configure((ISSLProperties)properties);
        SSLConfigurationTest.assertTrue((boolean)config.isConfigured());
    }

    public void testLocateKeystoreFile() {
        this.printTestName();
        String jreDir = System.getProperty("java.home");
        File cacertFile = new File(new File(new File(new File(jreDir), "lib"), "security"), "cacerts");
        SSLProperties properties = new SSLProperties("TLSv1", cacertFile.toString(), "changeit");
        SSLConfiguration config = new SSLConfiguration();
        config.configure((ISSLProperties)properties);
        SSLConfigurationTest.assertTrue((boolean)config.isConfigured());
    }

    public void testLocateKeystoreResource() {
        this.printTestName();
        SSLProperties properties = new SSLProperties("TLSv1", "/org/eclipse/riena/communication/core/ssl/cacerts", "changeit");
        SSLConfiguration config = new SSLConfiguration();
        config.configure((ISSLProperties)properties);
        SSLConfigurationTest.assertTrue((boolean)config.isConfigured());
    }

    public void testLocateKeystoreUrl() throws IOException {
        this.printTestName();
        String jreDir = System.getProperty("java.home");
        File cacertDir = new File(new File(new File(jreDir), "lib"), "security");
        TestServer nano = new TestServer(8888, cacertDir);
        SSLProperties properties = new SSLProperties("TLSv1", "http://localhost:8888/cacerts", "changeit");
        SSLConfiguration config = new SSLConfiguration();
        config.configure((ISSLProperties)properties);
        SSLConfigurationTest.assertTrue((boolean)config.isConfigured());
        nano.stop();
    }

    private static class SSLProperties
    implements ISSLProperties {
        private String protocol;
        private String keystore;
        private String password;

        public SSLProperties(String protocol, String keystore, String password) {
            this.protocol = protocol;
            this.keystore = keystore;
            this.password = password;
        }

        public String getKeystore() {
            return this.keystore;
        }

        public String getPassword() {
            return this.password;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public Bundle getContributingBundle() {
            return Activator.getDefault().getBundle();
        }
    }
}

