/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.util;

import junit.framework.TestCase;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.tests.collect.NonUITestCase;

@NonUITestCase
public class StringUtilsTest
extends TestCase {
    public void testIsEmpty() {
        StringUtilsTest.assertTrue((boolean)StringUtils.isEmpty(null));
        StringUtilsTest.assertTrue((boolean)StringUtils.isEmpty((CharSequence)""));
        StringUtilsTest.assertFalse((boolean)StringUtils.isEmpty((CharSequence)" "));
        StringUtilsTest.assertFalse((boolean)StringUtils.isEmpty((CharSequence)" a "));
    }

    public void testIsGiven() {
        StringUtilsTest.assertFalse((boolean)StringUtils.isGiven(null));
        StringUtilsTest.assertFalse((boolean)StringUtils.isGiven((CharSequence)""));
        StringUtilsTest.assertTrue((boolean)StringUtils.isGiven((CharSequence)" "));
        StringUtilsTest.assertTrue((boolean)StringUtils.isGiven((CharSequence)" a "));
    }

    public void testIsDeepEmpty() {
        StringUtilsTest.assertTrue((boolean)StringUtils.isDeepEmpty(null));
        StringUtilsTest.assertTrue((boolean)StringUtils.isDeepEmpty((String)""));
        StringUtilsTest.assertTrue((boolean)StringUtils.isDeepEmpty((String)" "));
        StringUtilsTest.assertFalse((boolean)StringUtils.isDeepEmpty((String)" a "));
    }

    public void testEquals() {
        StringUtilsTest.assertTrue((boolean)StringUtils.equals(null, null));
        StringUtilsTest.assertFalse((boolean)StringUtils.equals(null, (CharSequence)""));
        StringUtilsTest.assertFalse((boolean)StringUtils.equals((CharSequence)"", null));
        String c = "c";
        StringUtilsTest.assertTrue((boolean)StringUtils.equals((CharSequence)c, (CharSequence)c));
        StringUtilsTest.assertTrue((boolean)StringUtils.equals((CharSequence)"c", (CharSequence)"c"));
        StringUtilsTest.assertFalse((boolean)StringUtils.equals(null, (CharSequence)"a"));
        StringUtilsTest.assertFalse((boolean)StringUtils.equals((CharSequence)"a", null));
        StringUtilsTest.assertFalse((boolean)StringUtils.equals((CharSequence)"b", (CharSequence)"a"));
        StringUtilsTest.assertFalse((boolean)StringUtils.equals((CharSequence)"a", (CharSequence)"b"));
    }

    public void testCount() {
        StringUtilsTest.assertEquals((int)1, (int)StringUtils.count((String)"abb", (char)'a'));
        StringUtilsTest.assertEquals((int)1, (int)StringUtils.count((String)"bba", (char)'a'));
        StringUtilsTest.assertEquals((int)1, (int)StringUtils.count((String)"bab", (char)'a'));
        StringUtilsTest.assertEquals((int)3, (int)StringUtils.count((String)"aaa", (char)'a'));
        StringUtilsTest.assertEquals((int)0, (int)StringUtils.count((String)"", (char)'a'));
        StringUtilsTest.assertEquals((int)0, (int)StringUtils.count(null, (char)'a'));
        StringUtilsTest.assertEquals((int)0, (int)StringUtils.count((String)"bcd", (char)'a'));
    }
}

