/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.util;

import java.lang.reflect.Field;
import org.eclipse.core.internal.variables.StringVariableManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.riena.core.util.VariableManagerUtil;
import org.eclipse.riena.tests.RienaTestCase;
import org.eclipse.riena.tests.collect.NonUITestCase;

@NonUITestCase
public class VariableManagerUtilTest
extends RienaTestCase {
    private static Field fgManager;
    private static final String WWW_ECLIPSE_ORG = "www.eclipse.org";

    static {
        try {
            fgManager = StringVariableManager.class.getDeclaredField("fgManager");
            fgManager.setAccessible(true);
        }
        catch (Throwable throwable) {
            VariableManagerUtilTest.fail((String)"Could not access field \u00b4fgManager\u00b4 from StringVariableManager!");
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        fgManager.set(null, null);
    }

    public void testUpdatedWrongKey() throws CoreException {
        VariableManagerUtil.addVariable((String)"host", (String)"${host");
        VariableManagerUtilTest.assertEquals((String)"${host", (String)VariableManagerUtil.substitute((String)"${host}"));
    }

    public void testUpdatedRecursiveKeyDirectly() {
        try {
            VariableManagerUtil.addVariable((String)"host", (String)"${host}");
            VariableManagerUtil.substitute((String)"${host}");
            VariableManagerUtilTest.fail();
        }
        catch (CoreException e) {
            VariableManagerUtilTest.assertTrue((boolean)e.getMessage().contains("host"));
        }
    }

    public void testUpdatedRecursiveKeyIndirectly1() {
        try {
            VariableManagerUtil.addVariable((String)"a", (String)"${b}");
            VariableManagerUtil.addVariable((String)"b", (String)"${a}");
            VariableManagerUtil.substitute((String)"${a}");
            VariableManagerUtilTest.fail();
        }
        catch (CoreException e) {
            String problemVariableList = e.getMessage().substring(e.getMessage().indexOf(",") - 1, e.getMessage().indexOf(",") + 3);
            VariableManagerUtilTest.assertTrue((boolean)problemVariableList.contains("a"));
            VariableManagerUtilTest.assertTrue((boolean)problemVariableList.contains("b"));
        }
    }

    public void testUpdatedRecursiveKeyIndirectly2() {
        try {
            VariableManagerUtil.addVariable((String)"a", (String)"${b}");
            VariableManagerUtil.addVariable((String)"b", (String)"${c}");
            VariableManagerUtil.addVariable((String)"c", (String)"${a}");
            VariableManagerUtil.substitute((String)"${a}");
            VariableManagerUtilTest.fail();
        }
        catch (CoreException e) {
            String problemVariableList = e.getMessage().substring(e.getMessage().indexOf(",") - 1, e.getMessage().indexOf(",") + 6);
            VariableManagerUtilTest.assertTrue((boolean)problemVariableList.contains("a"));
            VariableManagerUtilTest.assertTrue((boolean)problemVariableList.contains("b"));
            VariableManagerUtilTest.assertTrue((boolean)problemVariableList.contains("c"));
        }
    }

    public void testModifyWrongKey() throws CoreException {
        VariableManagerUtil.addVariable((String)"host", (String)WWW_ECLIPSE_ORG);
        VariableManagerUtilTest.assertEquals((String)"${host", (String)VariableManagerUtil.substitute((String)"${host"));
    }

    public void testModifyEmptyKey() throws CoreException {
        VariableManagerUtil.addVariable((String)"", (String)WWW_ECLIPSE_ORG);
        VariableManagerUtilTest.assertEquals((String)WWW_ECLIPSE_ORG, (String)VariableManagerUtil.substitute((String)"${}"));
    }

    public void testModifySingle() throws CoreException {
        VariableManagerUtil.addVariable((String)"host", (String)WWW_ECLIPSE_ORG);
        VariableManagerUtilTest.assertEquals((String)WWW_ECLIPSE_ORG, (String)VariableManagerUtil.substitute((String)"${host}"));
    }

    public void testModifyDoubleSequentialy() throws CoreException {
        VariableManagerUtil.addVariable((String)"host", (String)WWW_ECLIPSE_ORG);
        VariableManagerUtilTest.assertEquals((String)"www.eclipse.orgwww.eclipse.org", (String)VariableManagerUtil.substitute((String)"${host}${host}"));
    }

    public void testModifyDoubleNested() throws CoreException {
        VariableManagerUtil.addVariable((String)"url", (String)"http://${host}/path");
        VariableManagerUtil.addVariable((String)"host", (String)WWW_ECLIPSE_ORG);
        VariableManagerUtilTest.assertEquals((String)"http://www.eclipse.org/path", (String)VariableManagerUtil.substitute((String)"${url}"));
    }

    public void testRemoveVariable() throws CoreException {
        VariableManagerUtil.addVariable((String)"a", (String)"1");
        VariableManagerUtilTest.assertEquals((String)"1", (String)VariableManagerUtil.substitute((String)"${a}"));
        VariableManagerUtil.removeVariable((String)"a");
        try {
            VariableManagerUtil.substitute((String)"${a}");
            VariableManagerUtilTest.fail();
        }
        catch (CoreException coreException) {
            this.ok();
        }
    }
}

