/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import org.eclipse.core.databinding.BindingException;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractSWTRidgetTest;
import org.eclipse.riena.internal.ui.ridgets.swt.ActionRidget;
import org.eclipse.riena.ui.core.marker.ErrorMarker;
import org.eclipse.riena.ui.core.marker.MandatoryMarker;
import org.eclipse.riena.ui.core.marker.NegativeMarker;
import org.eclipse.riena.ui.core.marker.OutputMarker;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.swt.uibinding.SwtControlRidgetMapper;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;

public class ActionRidgetTest
extends AbstractSWTRidgetTest {
    private static final String PLUGIN_ID = "org.eclipse.riena.tests:";
    private static final String ICON_ECLIPSE = "org.eclipse.riena.tests:/icons/eclipse.gif";
    private static final String LABEL = "testlabel";
    private static final String LABEL2 = "testlabel2";

    protected Button createWidget(Composite parent) {
        return new Button(parent, 8);
    }

    protected IActionRidget createRidget() {
        return new ActionRidget();
    }

    protected Button getWidget() {
        return (Button)super.getWidget();
    }

    protected IActionRidget getRidget() {
        return (IActionRidget)super.getRidget();
    }

    public void testSetFocusable() {
    }

    public void testRidgetMapping() {
        SwtControlRidgetMapper mapper = SwtControlRidgetMapper.getInstance();
        ActionRidgetTest.assertSame(ActionRidget.class, (Object)mapper.getRidgetClass((Object)this.getWidget()));
    }

    public void testSetUIControl() {
        IActionRidget ridget = this.getRidget();
        ridget.setUIControl(null);
        ActionRidgetTest.assertNull((Object)ridget.getUIControl());
        ridget.setUIControl((Object)this.getWidget());
        ActionRidgetTest.assertSame((Object)this.getWidget(), (Object)ridget.getUIControl());
    }

    public void testSetUIControlInvalid() {
        IActionRidget ridget = this.getRidget();
        try {
            ridget.setUIControl((Object)this.getShell());
            ActionRidgetTest.fail();
        }
        catch (BindingException bindingException) {
            this.ok();
        }
    }

    public void testAddListenerInvalid() {
        try {
            this.getRidget().addListener(null);
            ActionRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
    }

    public void testAddListener() {
        Button control = this.getWidget();
        IActionRidget ridget = this.getRidget();
        FTActionListener listener1 = new FTActionListener();
        FTActionListener listener2 = new FTActionListener();
        ridget.addListener((IActionListener)listener1);
        ridget.addListener((IActionListener)listener2);
        ridget.addListener((IActionListener)listener2);
        this.fireSelectionEvent(control);
        ActionRidgetTest.assertEquals((int)1, (int)listener1.getCount());
        ActionRidgetTest.assertEquals((int)1, (int)listener2.getCount());
        ridget.removeListener((IActionListener)listener1);
        this.fireSelectionEvent(control);
        ActionRidgetTest.assertEquals((int)1, (int)listener1.getCount());
        ActionRidgetTest.assertEquals((int)2, (int)listener2.getCount());
        ridget.removeListener((IActionListener)listener2);
        this.fireSelectionEvent(control);
        ActionRidgetTest.assertEquals((int)1, (int)listener1.getCount());
        ActionRidgetTest.assertEquals((int)2, (int)listener2.getCount());
        ridget.removeListener((IActionListener)listener2);
        this.fireSelectionEvent(control);
        ActionRidgetTest.assertEquals((int)1, (int)listener1.getCount());
        ActionRidgetTest.assertEquals((int)2, (int)listener2.getCount());
    }

    public final void testSetText() throws Exception {
        IActionRidget ridget = this.getRidget();
        Button control = this.getWidget();
        ridget.setText("");
        ActionRidgetTest.assertEquals((String)"", (String)ridget.getText());
        ActionRidgetTest.assertEquals((String)"", (String)control.getText());
        try {
            ridget.setText(null);
            ActionRidgetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.ok();
        }
        ridget.setText(LABEL);
        ActionRidgetTest.assertEquals((String)LABEL, (String)ridget.getText());
        ActionRidgetTest.assertEquals((String)LABEL, (String)control.getText());
        ridget.setUIControl(null);
        ridget.setText(LABEL2);
        ActionRidgetTest.assertEquals((String)LABEL2, (String)ridget.getText());
        ActionRidgetTest.assertEquals((String)LABEL, (String)control.getText());
        ridget.setUIControl((Object)control);
        ActionRidgetTest.assertEquals((String)LABEL2, (String)ridget.getText());
        ActionRidgetTest.assertEquals((String)LABEL2, (String)control.getText());
    }

    public final void testSetIcon() {
        IActionRidget ridget = this.getRidget();
        Button control = (Button)ridget.getUIControl();
        ridget.setIcon(ICON_ECLIPSE);
        ActionRidgetTest.assertEquals((String)ICON_ECLIPSE, (String)ridget.getIcon());
        ActionRidgetTest.assertNotNull((Object)control.getImage());
        ridget.setIcon(null);
        ActionRidgetTest.assertNull((Object)ridget.getIcon());
        ActionRidgetTest.assertNull((Object)control.getImage());
        Button button = this.createWidget((Composite)this.getShell());
        Image buttonImage = button.getDisplay().getSystemImage(2);
        button.setImage(buttonImage);
        IActionRidget buttonRidget = this.createRidget();
        buttonRidget.setUIControl((Object)button);
        ActionRidgetTest.assertSame((Object)buttonImage, (Object)button.getImage());
        buttonRidget.setIcon(null);
        ActionRidgetTest.assertNull((Object)buttonRidget.getIcon());
        ActionRidgetTest.assertNull((Object)button.getImage());
        buttonRidget.setIcon(ICON_ECLIPSE);
        ActionRidgetTest.assertEquals((String)ICON_ECLIPSE, (String)buttonRidget.getIcon());
        ActionRidgetTest.assertNotNull((Object)button.getImage());
        ActionRidgetTest.assertNotSame((Object)buttonImage, (Object)button.getImage());
        button = this.createWidget((Composite)this.getShell());
        button.setImage(buttonImage);
        buttonRidget = this.createRidget();
        buttonRidget.setIcon(ICON_ECLIPSE);
        buttonRidget.setUIControl((Object)button);
        ActionRidgetTest.assertNotNull((Object)button.getImage());
        ActionRidgetTest.assertNotSame((Object)buttonImage, (Object)button.getImage());
    }

    public void testInitText() {
        IActionRidget ridget = this.getRidget();
        Button control = (Button)ridget.getUIControl();
        ReflectionUtils.setHidden((Object)ridget, (String)"textAlreadyInitialized", (Object)false);
        ReflectionUtils.setHidden((Object)ridget, (String)"text", null);
        control.setText("Hello!");
        ReflectionUtils.invokeHidden((Object)ridget, (String)"initText", (Object[])new Object[0]);
        ActionRidgetTest.assertEquals((String)"Hello!", (String)ridget.getText());
        ActionRidgetTest.assertEquals((String)"Hello!", (String)control.getText());
        ActionRidgetTest.assertTrue((boolean)((Boolean)ReflectionUtils.getHidden((Object)ridget, (String)"textAlreadyInitialized")));
        control.setText("World");
        ReflectionUtils.invokeHidden((Object)ridget, (String)"initText", (Object[])new Object[0]);
        ActionRidgetTest.assertEquals((String)"Hello!", (String)ridget.getText());
        ActionRidgetTest.assertEquals((String)"World", (String)control.getText());
    }

    public void testUnsupportedMarkersIgnored() {
        this.assertMarkerIgnored((IMarker)new ErrorMarker());
        this.assertMarkerIgnored((IMarker)new MandatoryMarker());
        this.assertMarkerIgnored((IMarker)new OutputMarker());
        this.assertMarkerIgnored((IMarker)new NegativeMarker());
    }

    private void fireSelectionEvent(Button control) {
        Event event = new Event();
        event.type = 13;
        event.widget = control;
        control.notifyListeners(13, event);
    }

    private static final class FTActionListener
    implements IActionListener {
        private int count;

        private FTActionListener() {
        }

        public void callback() {
            ++this.count;
        }

        int getCount() {
            return this.count;
        }
    }
}

