/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.marker;

import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.internal.ui.ridgets.swt.TextRidget;
import org.eclipse.riena.tests.collect.UITestCase;
import org.eclipse.riena.ui.core.marker.ErrorMessageMarker;
import org.eclipse.riena.ui.core.marker.MessageMarker;
import org.eclipse.riena.ui.ridgets.IBasicMarkableRidget;
import org.eclipse.riena.ui.ridgets.IMessageBoxRidget;
import org.eclipse.riena.ui.ridgets.marker.MessageBoxMessageMarkerViewer;
import org.eclipse.riena.ui.ridgets.swt.DefaultRealm;
import org.eclipse.swt.widgets.Shell;

@UITestCase
public class MessageBoxMessageMarkerViewerTest
extends TestCase {
    private DefaultRealm realm;
    private Shell shell;
    private MessageBoxMessageMarkerViewer messageMarkerViewer;
    private IMessageBoxRidget messageBoxRidget;
    private TextRidget ridget;
    private String errorMessage;
    private ErrorMessageMarker errorMessageMarker;

    protected void setUp() throws Exception {
        super.setUp();
        this.realm = new DefaultRealm();
        this.shell = new Shell();
        this.ridget = new TextRidget();
        this.messageBoxRidget = (IMessageBoxRidget)EasyMock.createMock(IMessageBoxRidget.class);
        this.messageMarkerViewer = new MessageBoxMessageMarkerViewer(this.messageBoxRidget);
        this.messageMarkerViewer.addRidget((IBasicMarkableRidget)this.ridget);
        this.errorMessage = "TestErrorMessage";
        this.errorMessageMarker = new ErrorMessageMarker(this.errorMessage);
    }

    protected void tearDown() throws Exception {
        this.shell.dispose();
        this.shell = null;
        this.realm.dispose();
        this.realm = null;
        super.tearDown();
    }

    public void testSetVisible() throws Exception {
        MessageBoxMessageMarkerViewerTest.assertFalse((boolean)this.messageMarkerViewer.isVisible());
        EasyMock.replay((Object[])new Object[]{this.messageBoxRidget});
        this.messageMarkerViewer.setVisible(true);
        EasyMock.verify((Object[])new Object[]{this.messageBoxRidget});
        MessageBoxMessageMarkerViewerTest.assertFalse((boolean)this.messageMarkerViewer.isVisible());
        EasyMock.reset((Object[])new Object[]{this.messageBoxRidget});
        EasyMock.replay((Object[])new Object[]{this.messageBoxRidget});
        this.ridget.addMarker((IMarker)this.errorMessageMarker);
        EasyMock.verify((Object[])new Object[]{this.messageBoxRidget});
        MessageBoxMessageMarkerViewerTest.assertFalse((boolean)this.messageMarkerViewer.isVisible());
        EasyMock.reset((Object[])new Object[]{this.messageBoxRidget});
        this.messageBoxRidget.setText(this.errorMessage);
        EasyMock.expect((Object)this.messageBoxRidget.show()).andReturn((Object)IMessageBoxRidget.OK);
        EasyMock.replay((Object[])new Object[]{this.messageBoxRidget});
        this.messageMarkerViewer.setVisible(true);
        EasyMock.verify((Object[])new Object[]{this.messageBoxRidget});
        MessageBoxMessageMarkerViewerTest.assertFalse((boolean)this.messageMarkerViewer.isVisible());
        EasyMock.reset((Object[])new Object[]{this.messageBoxRidget});
        this.messageBoxRidget.setText(this.errorMessage);
        EasyMock.expect((Object)this.messageBoxRidget.show()).andReturn((Object)IMessageBoxRidget.OK);
        EasyMock.replay((Object[])new Object[]{this.messageBoxRidget});
        TextRidget anotherRidget = new TextRidget();
        String anotherMessage = String.valueOf(this.errorMessage) + "2";
        anotherRidget.addMarker((IMarker)new MessageMarker(anotherMessage));
        this.messageMarkerViewer.addRidget((IBasicMarkableRidget)anotherRidget);
        this.messageMarkerViewer.setVisible(true);
        EasyMock.verify((Object[])new Object[]{this.messageBoxRidget});
        MessageBoxMessageMarkerViewerTest.assertFalse((boolean)this.messageMarkerViewer.isVisible());
        EasyMock.reset((Object[])new Object[]{this.messageBoxRidget});
        this.messageBoxRidget.setText(String.valueOf(this.errorMessage) + "\n" + anotherMessage);
        EasyMock.expect((Object)this.messageBoxRidget.show()).andReturn((Object)IMessageBoxRidget.OK);
        EasyMock.replay((Object[])new Object[]{this.messageBoxRidget});
        this.messageMarkerViewer.addMarkerType(MessageMarker.class);
        this.messageMarkerViewer.setVisible(true);
        EasyMock.verify((Object[])new Object[]{this.messageBoxRidget});
        MessageBoxMessageMarkerViewerTest.assertFalse((boolean)this.messageMarkerViewer.isVisible());
    }
}

