/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.core.uiprocess;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.riena.ui.core.uiprocess.IUIMonitor;
import org.eclipse.riena.ui.core.uiprocess.IUIMonitorContainer;
import org.eclipse.riena.ui.core.uiprocess.IUISynchronizer;
import org.eclipse.riena.ui.core.uiprocess.ProcessInfo;
import org.eclipse.riena.ui.core.uiprocess.ProgressProviderBridge;
import org.eclipse.riena.ui.core.uiprocess.UICallbackDispatcher;

public class UIProcess
extends PlatformObject
implements IUIMonitor {
    public static final QualifiedName PROPERTY_CONTEXT = new QualifiedName("uiProcess", "context");
    protected static final String EXTENSION_POINT_ID = "org.riena.ui.core.uiprocess";
    protected static final String EXTENSION_POINT_UI_SYNCHRONIZER_ELEMENT = "uisynchronizer";
    private UICallbackDispatcher callbackDispatcher;
    private Job job;

    public UIProcess(String name) {
        this(name, false);
    }

    public UIProcess(String name, boolean user) {
        this(name, user, new Object());
    }

    public UIProcess(String name, boolean user, Object context) {
        this(name, UIProcess.getSynchronizerFromExtensionPoint(), user, context);
    }

    public static IUISynchronizer getSynchronizerFromExtensionPoint() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] configurations = extensionRegistry.getConfigurationElementsFor(EXTENSION_POINT_ID);
        if (configurations.length == 0) {
            throw new IllegalStateException("No configuration element for extension point 'org.riena.ui.core.uiprocess'");
        }
        IConfigurationElement[] iConfigurationElementArray = configurations;
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configuration = iConfigurationElementArray[n2];
            if (EXTENSION_POINT_UI_SYNCHRONIZER_ELEMENT.equals(configuration.getName())) {
                try {
                    return (IUISynchronizer)configuration.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    throw new IllegalStateException("Could not create object from attribute 'class' in element 'uisynchronizer' in extension point 'org.riena.ui.core.uiprocess'", e);
                }
            }
            ++n2;
        }
        throw new IllegalStateException("No element 'uisynchronizer' in extension point 'org.riena.ui.core.uiprocess'");
    }

    public UIProcess(String name, IUISynchronizer syncher, boolean user, Object context) {
        this(name, new UICallbackDispatcher(syncher), user, context);
    }

    private UIProcess(String name, UICallbackDispatcher dispatcher, boolean user, Object context) {
        this.callbackDispatcher = dispatcher;
        this.createJob(name, user, context);
        this.configure();
    }

    public UIProcess(Job job) {
        this.callbackDispatcher = new UICallbackDispatcher(UIProcess.getSynchronizerFromExtensionPoint());
        this.job = job;
        this.configure();
    }

    private void configure() {
        this.register();
        this.configureProcessInfo();
    }

    private void configureProcessInfo() {
        if (this.callbackDispatcher != null) {
            ProcessInfo processInfo = this.callbackDispatcher.getProcessInfo();
            processInfo.setContext(this.job.getProperty(PROPERTY_CONTEXT));
            processInfo.addPropertyChangeListener(new CancelListener());
            processInfo.setDialogVisible(this.job.isUser());
            processInfo.setNote(this.job.getName());
            processInfo.setTitle(this.job.getName());
        }
    }

    private void createJob(String name, boolean user, Object context) {
        this.job = new InternalJob(name);
        this.job.setUser(user);
        this.job.setProperty(PROPERTY_CONTEXT, context);
    }

    protected boolean forceMonitorBegin() {
        return true;
    }

    protected Job getJob() {
        return this.job;
    }

    protected void beforeRun(IProgressMonitor monitor) {
    }

    protected void afterRun(IProgressMonitor monitor) {
    }

    protected int getTotalWork() {
        return 0;
    }

    private void register() {
        this.callbackDispatcher.addUIMonitor(this);
        ProgressProviderBridge.instance().registerMapping(this.job, this);
    }

    public UICallbackDispatcher getCallbackDispatcher() {
        return this.callbackDispatcher;
    }

    public void updateProgress(int progress) {
    }

    public void initialUpdateUI(int totalWork) {
    }

    public void finalUpdateUI() {
    }

    public boolean runJob(IProgressMonitor monitor) {
        return true;
    }

    public void start() {
        this.job.schedule();
    }

    public Object getAdapter(Class adapter) {
        Object adapted = super.getAdapter(adapter);
        if (adapted == null) {
            if (adapter.isInstance(this)) {
                adapted = this;
            }
            if (adapter.equals(UICallbackDispatcher.class)) {
                adapted = this.getCallbackDispatcher();
            }
        }
        return adapted;
    }

    public void setNote(String note) {
        this.getProcessInfo().setNote(note);
    }

    public void setTitle(String title) {
        this.getProcessInfo().setTitle(title);
    }

    public void setIcon(String icon) {
        this.getProcessInfo().setIcon(icon);
    }

    private ProcessInfo getProcessInfo() {
        return this.getCallbackDispatcher().getProcessInfo();
    }

    public boolean isActive(IUIMonitorContainer container) {
        return true;
    }

    protected void notifyUpdateUI() {
        this.getCallbackDispatcher().getSyncher().synchronize(new Runnable(){

            public void run() {
                UIProcess.this.updateUi();
            }
        });
    }

    public void updateUi() {
    }

    private final class CancelListener
    implements PropertyChangeListener {
        private CancelListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if ("cancel".equals(event.getPropertyName())) {
                UIProcess.this.job.cancel();
            }
        }
    }

    private final class InternalJob
    extends Job {
        public InternalJob(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            UIProcess.this.beforeRun(monitor);
            if (UIProcess.this.forceMonitorBegin()) {
                monitor.beginTask(this.getName(), UIProcess.this.getTotalWork());
            }
            boolean state = true;
            try {
                state = UIProcess.this.runJob(monitor);
            }
            catch (Throwable throwable) {
                state = false;
            }
            monitor.done();
            UIProcess.this.afterRun(monitor);
            return state ? Status.OK_STATUS : Status.CANCEL_STATUS;
        }
    }
}

