/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.riena.internal.ui.ridgets.swt.Activator;
import org.eclipse.riena.ui.ridgets.IColumnFormatter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class TableRidgetLabelProvider
extends ObservableMapLabelProvider
implements ITableColorProvider,
ITableFontProvider {
    private final IObservableMap[] attributeMap;
    private IColumnFormatter[] formatters;

    public TableRidgetLabelProvider(IObservableMap[] attributeMap, IColumnFormatter[] formatters) {
        this(attributeMap, formatters, attributeMap.length);
    }

    protected TableRidgetLabelProvider(IObservableMap[] attributeMap, IColumnFormatter[] formatters, int numColumns) {
        super(attributeMap);
        Assert.isLegal((numColumns == formatters.length ? 1 : 0) != 0, (String)String.format("expected %d formatters, got %d", numColumns, formatters.length));
        this.attributeMap = new IObservableMap[attributeMap.length];
        System.arraycopy(attributeMap, 0, this.attributeMap, 0, this.attributeMap.length);
        this.formatters = new IColumnFormatter[formatters.length];
        System.arraycopy(formatters, 0, this.formatters, 0, this.formatters.length);
    }

    public Image getImage(Object element) {
        return this.getColumnImage(element, 0);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Image result = null;
        if (columnIndex < this.attributeMap.length) {
            Object value;
            IColumnFormatter formatter = this.formatters[columnIndex];
            if (formatter != null) {
                result = (Image)formatter.getImage(element);
            }
            if (result == null && (value = this.attributeMap[columnIndex].get(element)) instanceof Boolean) {
                String key = (Boolean)value != false ? "IMG_CHECKED" : "IMG_UNCHECKED";
                result = Activator.getSharedImage(key);
            }
        }
        return result;
    }

    public String getColumnText(Object element, int columnIndex) {
        IColumnFormatter formatter;
        String result = null;
        if (columnIndex < this.formatters.length && (formatter = this.formatters[columnIndex]) != null) {
            result = formatter.getText(element);
        }
        if (result == null) {
            result = super.getColumnText(element, columnIndex);
        }
        return result;
    }

    public Color getForeground(Object element, int columnIndex) {
        IColumnFormatter formatter;
        if (columnIndex < this.formatters.length && (formatter = this.formatters[columnIndex]) != null) {
            return (Color)formatter.getForeground(element);
        }
        return null;
    }

    public Color getBackground(Object element, int columnIndex) {
        IColumnFormatter formatter;
        if (columnIndex < this.formatters.length && (formatter = this.formatters[columnIndex]) != null) {
            return (Color)formatter.getBackground(element);
        }
        return null;
    }

    public Font getFont(Object element, int columnIndex) {
        IColumnFormatter formatter;
        if (columnIndex < this.formatters.length && (formatter = this.formatters[columnIndex]) != null) {
            return (Font)formatter.getFont(element);
        }
        return null;
    }

    public Object getColumnValue(Object element, int columnIndex) {
        if (columnIndex < this.attributeMap.length) {
            return this.attributeMap[columnIndex].get(element);
        }
        return null;
    }

    protected IColumnFormatter getFormatter(int columnIndex) {
        return columnIndex < this.formatters.length ? this.formatters[columnIndex] : null;
    }

    int getColumnCount() {
        return this.formatters.length;
    }

    void setFormatters(IColumnFormatter[] formatters) {
        Assert.isLegal((this.attributeMap.length == formatters.length ? 1 : 0) != 0);
        this.formatters = new IColumnFormatter[formatters.length];
        System.arraycopy(formatters, 0, this.formatters, 0, this.formatters.length);
    }
}

