/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.swt;

import java.beans.EventHandler;
import org.eclipse.riena.internal.ui.ridgets.swt.ActionObserver;
import org.eclipse.riena.internal.ui.ridgets.swt.BasicMarkerSupport;
import org.eclipse.riena.ui.ridgets.AbstractMarkerSupport;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractSWTRidget;
import org.eclipse.swt.graphics.Image;

public abstract class AbstractActionRidget
extends AbstractSWTRidget
implements IActionRidget {
    private static final String EMPTY_STRING = "";
    private String text;
    private String icon;
    protected ActionObserver actionObserver = new ActionObserver();
    private boolean textAlreadyInitialized = false;
    private boolean useRidgetIcon = false;

    protected AbstractMarkerSupport createMarkerSupport() {
        return new BasicMarkerSupport(this, this.propertyChangeSupport);
    }

    protected void initText() {
        if (this.text == null && !this.textAlreadyInitialized && this.getUIControl() != null && !this.getUIControl().isDisposed()) {
            this.text = this.getUIControlText();
            if (this.text == null) {
                this.text = EMPTY_STRING;
            }
            this.textAlreadyInitialized = true;
        }
    }

    protected abstract String getUIControlText();

    public final void addListener(IActionListener listener) {
        this.actionObserver.addListener(listener);
    }

    public final void addListener(Object target, String action) {
        this.addListener(EventHandler.create(IActionListener.class, target, action));
    }

    public final void removeListener(IActionListener listener) {
        this.actionObserver.removeListener(listener);
    }

    public boolean isDisableMandatoryMarker() {
        return true;
    }

    public String getIcon() {
        return this.icon;
    }

    public final String getText() {
        return this.text;
    }

    public void setIcon(String icon) {
        boolean oldUseRidgetIcon = this.useRidgetIcon;
        this.useRidgetIcon = true;
        String oldIcon = this.icon;
        this.icon = icon;
        if (this.hasChanged(oldIcon, icon) || !oldUseRidgetIcon) {
            this.updateUIIcon();
        }
    }

    public final void setText(String newText) {
        this.text = newText;
        this.updateUIText();
    }

    protected void updateUIText() {
        if (this.getUIControl() != null) {
            this.setUIControlText(this.getText());
        }
    }

    protected abstract void setUIControlText(String var1);

    protected void updateUIIcon() {
        if (this.getUIControl() != null) {
            Image image = null;
            if (this.icon != null) {
                image = this.getManagedImage(this.icon);
            }
            if (image != null || this.useRidgetIcon) {
                this.setUIControlImage(image);
            }
        }
    }

    protected abstract void setUIControlImage(Image var1);
}

