/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.swt.uibinding;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.riena.ui.ridgets.IRidgetContainer;
import org.eclipse.riena.ui.ridgets.controller.IController;
import org.eclipse.riena.ui.ridgets.uibinding.DefaultBindingManager;
import org.eclipse.riena.ui.ridgets.uibinding.IBindingManager;
import org.eclipse.riena.ui.ridgets.uibinding.IBindingPropertyLocator;
import org.eclipse.riena.ui.ridgets.uibinding.IControlRidgetMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractViewBindingDelegate {
    private List<Object> uiControls;
    private IBindingManager bindingManager;
    private IControlRidgetMapper<Object> mapper;

    public AbstractViewBindingDelegate(IBindingPropertyLocator propertyStrategy, IControlRidgetMapper<Object> mapper) {
        this.bindingManager = this.createBindingManager(propertyStrategy, mapper);
        this.uiControls = new ArrayList<Object>();
    }

    protected IBindingManager createBindingManager(IBindingPropertyLocator propertyStrategy, IControlRidgetMapper<Object> mapper) {
        this.mapper = mapper;
        return new DefaultBindingManager(propertyStrategy, mapper);
    }

    public void addUIControl(Object uiControl) {
        if (!this.uiControls.contains(uiControl)) {
            this.uiControls.add(uiControl);
        }
    }

    public void addUIControl(Object uiControl, String bindingId) {
        this.addUIControl(uiControl);
    }

    public void injectAndBind(IController controller) {
        this.injectRidgets(controller);
        this.bind(controller);
    }

    public void injectRidgets(IController controller) {
        this.bindingManager.injectRidgets((IRidgetContainer)controller, this.uiControls);
    }

    public void bind(IController controller) {
        this.bindingManager.bind((IRidgetContainer)controller, this.uiControls);
    }

    public void unbind(IController controller) {
        this.bindingManager.unbind((IRidgetContainer)controller, this.uiControls);
    }

    public void addSpecialMapping(String controlName, Class<? extends Object> ridgetClazz) {
        this.mapper.addSpecialMapping(controlName, ridgetClazz);
    }
}

