/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.swt.views;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.riena.ui.ridgets.controller.AbstractWindowController;
import org.eclipse.riena.ui.ridgets.swt.views.AbstractControlledView;
import org.eclipse.riena.ui.swt.RienaDialog;
import org.eclipse.riena.ui.swt.lnf.LnFUpdater;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DialogView
extends AbstractControlledView<AbstractWindowController> {
    private static final LnFUpdater LNF_UPDATER = new LnFUpdater();
    protected Dialog dialog;
    private Shell parentShell;

    public DialogView(Composite parent) {
        if (parent != null) {
            this.parentShell = parent.getShell();
        }
    }

    protected ControlledRienaDialog createDialog() {
        return new ControlledRienaDialog(this.getParentShell());
    }

    protected void createAndBindController() {
        AbstractWindowController controller = this.createController();
        this.initialize(controller);
        this.bind(controller);
    }

    protected Control buildView(Composite parent) {
        this.addUIControl(this.dialog.getShell(), "windowRidget");
        return parent;
    }

    protected abstract AbstractWindowController createController();

    public void build() {
        if (this.dialog == null) {
            this.dialog = this.createDialog();
        }
        this.dialog.open();
    }

    private Shell getParentShell() {
        return this.parentShell;
    }

    protected void onClose() {
    }

    private final class ControlledRienaDialog
    extends RienaDialog {
        private boolean closing;

        private ControlledRienaDialog(Shell shell) {
            super(shell);
            this.closing = false;
        }

        public boolean close() {
            this.closing = true;
            DialogView.this.onClose();
            DialogView.this.unbind((AbstractWindowController)DialogView.this.getController());
            boolean result = super.close();
            this.closing = false;
            return result;
        }

        public void create() {
            super.create();
            DialogView.this.createAndBindController();
            LNF_UPDATER.updateUIControlsAfterBind((Composite)this.getShell());
            this.getShell().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (!ControlledRienaDialog.this.closing) {
                        ControlledRienaDialog.this.close();
                    }
                }
            });
            this.getShell().pack();
        }

        protected Control createDialogArea(Composite parent) {
            Control dlgContente = DialogView.this.buildView(parent);
            LNF_UPDATER.updateUIControls(parent);
            return dlgContente;
        }
    }
}

