/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.databinding.AggregateValidationStatus;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.riena.core.marker.IMarkable;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.ui.core.marker.ErrorMarker;
import org.eclipse.riena.ui.core.marker.IMessageMarker;
import org.eclipse.riena.ui.core.marker.MessageMarker;
import org.eclipse.riena.ui.core.marker.ValidationTime;
import org.eclipse.riena.ui.ridgets.IValidationCallback;
import org.eclipse.riena.ui.ridgets.databinding.RidgetUpdateValueStrategy;
import org.eclipse.riena.ui.ridgets.marker.ValidationMessageMarker;
import org.eclipse.riena.ui.ridgets.validation.ValidationRuleStatus;
import org.eclipse.riena.ui.ridgets.validation.ValidatorCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueBindingSupport
implements IValidationCallback {
    private DataBindingContext context;
    private IObservableValue targetOV;
    private IObservableValue modelOV;
    private Binding modelBinding;
    private ValidatorCollection afterGetValidators;
    private ValidatorCollection onEditValidators;
    private IConverter uiControlToModelConverter;
    private IConverter modelToUIControlConverter;
    private ErrorMarker errorMarker = new ErrorMarker();
    private IMarkable markable;
    private Collection<ValidationMessageMarker> validationMessageMarkers = new ArrayList<ValidationMessageMarker>(0);
    private IStatus lastValidationStatus;

    public ValueBindingSupport(IObservableValue target) {
        this.bindToTarget(target);
        this.afterGetValidators = new ValidatorCollection();
        this.onEditValidators = new ValidatorCollection();
    }

    public ValueBindingSupport(IObservableValue target, IObservableValue model) {
        this(target);
        this.bindToModel(model);
    }

    public IConverter getUIControlToModelConverter() {
        return this.uiControlToModelConverter;
    }

    public void setUIControlToModelConverter(IConverter uiControlToModelConverter) {
        this.uiControlToModelConverter = uiControlToModelConverter;
    }

    public IConverter getModelToUIControlConverter() {
        return this.modelToUIControlConverter;
    }

    public void setModelToUIControlConverter(IConverter modelToUIControlConverter) {
        this.modelToUIControlConverter = modelToUIControlConverter;
    }

    public Collection<IValidator> getValidationRules() {
        ArrayList<IValidator> allValidationRules = new ArrayList<IValidator>(this.onEditValidators.getValidators());
        allValidationRules.addAll(this.afterGetValidators.getValidators());
        return allValidationRules;
    }

    public ValidatorCollection getOnEditValidators() {
        return this.onEditValidators;
    }

    public ValidatorCollection getAfterGetValidators() {
        return this.afterGetValidators;
    }

    public boolean addValidationRule(IValidator validationRule, ValidationTime validationTime) {
        Assert.isNotNull((Object)validationRule);
        if (validationTime == ValidationTime.ON_UI_CONTROL_EDIT) {
            this.onEditValidators.add(validationRule);
            return true;
        }
        if (validationTime == ValidationTime.ON_UPDATE_TO_MODEL) {
            this.afterGetValidators.add(validationRule);
            return false;
        }
        throw new UnsupportedOperationException();
    }

    public boolean removeValidationRule(IValidator validationRule) {
        if (validationRule == null) {
            return false;
        }
        this.afterGetValidators.remove(validationRule);
        if (this.onEditValidators.contains(validationRule)) {
            this.onEditValidators.remove(validationRule);
            return true;
        }
        return false;
    }

    public void bindToTarget(IObservableValue observableValue) {
        this.targetOV = observableValue;
        this.rebindToModel();
    }

    public void bindToModel(IObservableValue observableValue) {
        this.modelOV = observableValue;
        this.rebindToModel();
    }

    public void bindToModel(Object valueHolder, String valuePropertyName) {
        this.modelOV = PojoObservables.observeValue((Object)valueHolder, (String)valuePropertyName);
        this.rebindToModel();
    }

    public void rebindToModel() {
        if (this.modelOV == null || this.targetOV == null) {
            return;
        }
        RidgetUpdateValueStrategy uiControlToModelStrategy = new RidgetUpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE);
        RidgetUpdateValueStrategy modelToUIControlStrategy = new RidgetUpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST);
        uiControlToModelStrategy.setAfterGetValidator(this.afterGetValidators);
        if (this.uiControlToModelConverter != null && this.targetOV.getValueType() == this.uiControlToModelConverter.getFromType() && this.modelOV.getValueType() == this.uiControlToModelConverter.getToType()) {
            uiControlToModelStrategy.setConverter(this.uiControlToModelConverter);
        }
        if (this.modelToUIControlConverter != null && this.targetOV.getValueType() == this.modelToUIControlConverter.getToType() && this.modelOV.getValueType() == this.modelToUIControlConverter.getFromType()) {
            modelToUIControlStrategy.setConverter(this.modelToUIControlConverter);
        }
        if (this.modelBinding != null) {
            this.modelBinding.dispose();
            this.getContext().removeBinding(this.modelBinding);
        }
        this.modelBinding = this.getContext().bindValue(this.targetOV, this.modelOV, (UpdateValueStrategy)uiControlToModelStrategy, (UpdateValueStrategy)modelToUIControlStrategy);
        AggregateValidationStatus validationStatus = new AggregateValidationStatus((IObservableCollection)this.getContext().getBindings(), 2);
        validationStatus.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                IStatus newStatus = (IStatus)((ComputedValue)event.getSource()).getValue();
                if (newStatus.isOK()) {
                    ValueBindingSupport.this.markable.removeMarker((IMarker)ValueBindingSupport.this.errorMarker);
                } else {
                    ValueBindingSupport.this.markable.addMarker((IMarker)ValueBindingSupport.this.errorMarker);
                }
                ValueBindingSupport.this.updateValidationMessageMarkers(newStatus);
            }
        });
    }

    public IObservableValue getModelObservable() {
        return this.modelOV;
    }

    public Binding getModelBinding() {
        return this.modelBinding;
    }

    public void setMarkable(IMarkable markable) {
        this.markable = markable;
    }

    public void updateFromModel() {
        if (this.modelBinding != null) {
            this.modelBinding.updateModelToTarget();
        }
    }

    public void updateFromTarget() {
        if (this.modelBinding != null) {
            this.modelBinding.updateTargetToModel();
        }
    }

    public DataBindingContext getContext() {
        if (this.context == null) {
            this.context = new DataBindingContext();
        }
        return this.context;
    }

    @Override
    public void validationRulesChecked(IStatus status) {
        this.updateValidationMessageMarkers(status);
    }

    public void addValidationMessage(String message) {
        this.addValidationMessage((IMessageMarker)new MessageMarker(message));
    }

    public void addValidationMessage(IMessageMarker messageMarker) {
        ValidationMessageMarker validationMessageMarker = new ValidationMessageMarker(messageMarker);
        this.doAddMessageMarker(validationMessageMarker);
    }

    public void addValidationMessage(String message, IValidator validationRule) {
        this.addValidationMessage((IMessageMarker)new MessageMarker(message), validationRule);
    }

    public void addValidationMessage(IMessageMarker messageMarker, IValidator validationRule) {
        ValidationMessageMarker validationMessageMarker = new ValidationMessageMarker(messageMarker, validationRule);
        this.doAddMessageMarker(validationMessageMarker);
    }

    public void removeValidationMessage(String message) {
        this.removeValidationMessage((IMessageMarker)new MessageMarker(message));
    }

    public void removeValidationMessage(IMessageMarker messageMarker) {
        ValidationMessageMarker validationMessageMarker = new ValidationMessageMarker(messageMarker);
        this.validationMessageMarkers.remove((Object)validationMessageMarker);
        if (this.isErrorMarked()) {
            this.removeValidationMessageMarker(validationMessageMarker);
        }
    }

    public void removeValidationMessage(String message, IValidator validationRule) {
        this.removeValidationMessage((IMessageMarker)new MessageMarker(message), validationRule);
    }

    public void removeValidationMessage(IMessageMarker messageMarker, IValidator validationRule) {
        ValidationMessageMarker validationMessageMarker = new ValidationMessageMarker(messageMarker, validationRule);
        this.validationMessageMarkers.remove((Object)validationMessageMarker);
        if (this.isErrorMarked()) {
            this.removeValidationMessageMarker(validationMessageMarker);
        }
    }

    private void addValidationMessageMarker(ValidationMessageMarker validationMessageMarker) {
        if (validationMessageMarker.getValidationRule() == null || this.isSourceOf(validationMessageMarker.getValidationRule(), this.lastValidationStatus)) {
            this.markable.addMarker((IMarker)validationMessageMarker);
        }
    }

    private void doAddMessageMarker(ValidationMessageMarker messageMarker) {
        this.validationMessageMarkers.add(messageMarker);
        if (this.isErrorMarked()) {
            this.addValidationMessageMarker(messageMarker);
        }
    }

    private boolean isErrorMarked() {
        return this.markable.getMarkers().contains(this.errorMarker);
    }

    private boolean isSourceOf(IValidator validationRule, IStatus status) {
        if (status instanceof ValidationRuleStatus) {
            return validationRule.equals(((ValidationRuleStatus)status).getSource());
        }
        if (status instanceof MultiStatus) {
            IStatus[] iStatusArray = ((MultiStatus)status).getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus childStatus = iStatusArray[n2];
                if (this.isSourceOf(validationRule, childStatus)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private void removeValidationMessageMarker(ValidationMessageMarker validationMessageMarker) {
        this.markable.removeMarker((IMarker)validationMessageMarker);
    }

    private void updateValidationMessageMarkers(IStatus status) {
        this.lastValidationStatus = status;
        for (ValidationMessageMarker validationMessageMarker : this.validationMessageMarkers) {
            this.removeValidationMessageMarker(validationMessageMarker);
            if (status.isOK()) continue;
            this.addValidationMessageMarker(validationMessageMarker);
        }
    }
}

