/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.databinding;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.riena.ui.ridgets.databinding.ConversionFailure;

public class StringToDateConverter
extends Converter {
    private final DateFormat format;
    private final TimeZone timezone;

    public StringToDateConverter(String pattern) {
        super(String.class, Date.class);
        this.format = new SimpleDateFormat(pattern);
        this.timezone = !this.hasTimeZone(pattern) ? TimeZone.getDefault() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object convert(Object fromObject) {
        if (fromObject == null || "".equals(fromObject)) {
            return null;
        }
        try {
            DateFormat dateFormat = this.format;
            synchronized (dateFormat) {
                Date parsedDate = this.format.parse((String)fromObject);
                return this.createGMTDate(parsedDate);
            }
        }
        catch (ParseException e) {
            throw new ConversionFailure("Cannot convert \"" + fromObject + "\" to a java.util.Date.", e);
        }
    }

    private Date createGMTDate(Date date) {
        Date result = date;
        if (this.timezone != null) {
            long time = date.getTime();
            int offset = this.timezone.getOffset(time);
            result = new Date(time + (long)offset);
        }
        return result;
    }

    private boolean hasTimeZone(String pattern) {
        return pattern.contains("zzz") || pattern.contains("ZZZZ");
    }
}

