/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.riena.ui.common.IComplexComponent;
import org.eclipse.riena.ui.swt.Messages;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;
import org.eclipse.riena.ui.swt.utils.UIControlsFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MasterDetailsComposite
extends Composite
implements IComplexComponent {
    public static final String BIND_ID_TABLE = "mdTable";
    public static final String BIND_ID_NEW = "mdNewButton";
    public static final String BIND_ID_REMOVE = "mdRemoveButton";
    public static final String BIND_ID_APPLY = "mdApplyButton";
    private final List<Object> controls = new ArrayList<Object>();
    private Table table;
    private Composite details;

    public MasterDetailsComposite(Composite parent, int style) {
        this(parent, style, 1024);
    }

    public MasterDetailsComposite(Composite parent, int style, int orientation) {
        super(parent, style);
        this.checkOrientation(orientation);
        this.setLayout((Layout)new GridLayout(1, false));
        if (orientation == 128) {
            this.details = this.createComposite(this.getDetailsStyle());
            this.createDetails(this.details);
        }
        Composite master = this.createComposite(this.getMasterStyle());
        this.createMaster(master);
        if (orientation == 1024) {
            this.details = this.createComposite(this.getDetailsStyle());
            this.createDetails(this.details);
        }
        this.setBackground(LnfManager.getLnf().getColor("SubModule.background"));
    }

    public final Button getButtonApply() {
        return (Button)this.getUIControl(BIND_ID_APPLY);
    }

    public final Button getButtonNew() {
        return (Button)this.getUIControl(BIND_ID_NEW);
    }

    public final Button getButtonRemove() {
        return (Button)this.getUIControl(BIND_ID_REMOVE);
    }

    public final Composite getDetails() {
        return this.details;
    }

    public final Table getTable() {
        return this.table;
    }

    public final List<Object> getUIControls() {
        return Collections.unmodifiableList(this.controls);
    }

    public final void addUIControl(Object uiControl, String bindingId) {
        Assert.isNotNull((Object)uiControl);
        Assert.isNotNull((Object)bindingId);
        this.controls.add(uiControl);
        SWTBindingPropertyLocator.getInstance().setBindingProperty(uiControl, bindingId);
    }

    protected Button createButtonNew(Composite compButton) {
        return UIControlsFactory.createButton(compButton, Messages.MasterDetailsComposite_buttonNew);
    }

    protected Button createButtonRemove(Composite compButton) {
        return UIControlsFactory.createButton(compButton, Messages.MasterDetailsComposite_buttonRemove);
    }

    protected Button createButtonApply(Composite compButton) {
        return UIControlsFactory.createButton(compButton, Messages.MasterDetailsComposite_buttonApply);
    }

    protected Composite createButtons(Composite parent) {
        Button btnApply;
        Button btnRemove;
        Composite result = UIControlsFactory.createComposite(parent);
        GridDataFactory.fillDefaults().applyTo((Control)result);
        RowLayout buttonLayout = new RowLayout(512);
        buttonLayout.marginTop = 0;
        buttonLayout.marginLeft = 0;
        buttonLayout.marginRight = 0;
        buttonLayout.fill = true;
        result.setLayout((Layout)buttonLayout);
        Button btnNew = this.createButtonNew(result);
        if (btnNew != null) {
            this.addUIControl(btnNew, BIND_ID_NEW);
        }
        if ((btnRemove = this.createButtonRemove(result)) != null) {
            this.addUIControl(btnRemove, BIND_ID_REMOVE);
        }
        if ((btnApply = this.createButtonApply(result)) != null) {
            this.addUIControl(btnApply, BIND_ID_APPLY);
        }
        return result;
    }

    protected void createDetails(Composite details) {
    }

    protected Table createTable(Composite compTable, TableColumnLayout layout) {
        Table result = new Table(compTable, 67588);
        result.setHeaderVisible(true);
        result.setLinesVisible(true);
        return result;
    }

    protected int getDetailsStyle() {
        return 0;
    }

    protected int getMasterStyle() {
        return 0;
    }

    private void checkOrientation(int orientation) {
        int[] allowedValues;
        int[] nArray = allowedValues = new int[]{128, 1024};
        int n = allowedValues.length;
        int n2 = 0;
        while (n2 < n) {
            int value = nArray[n2];
            if (orientation == value) {
                return;
            }
            ++n2;
        }
        throw new IllegalArgumentException("unsupported orientation: " + orientation);
    }

    private Composite createComposite(int style) {
        Composite result = UIControlsFactory.createComposite(this, style);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)result);
        return result;
    }

    private void createMaster(Composite parent) {
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(parent);
        Composite compTable = this.createTableComposite(parent);
        Composite compButton = this.createButtons(parent);
        if (compButton == null) {
            ((GridData)compTable.getLayoutData()).horizontalSpan = 2;
        }
    }

    private Composite createTableComposite(Composite parent) {
        Composite result = UIControlsFactory.createComposite(parent);
        TableColumnLayout layout = new TableColumnLayout();
        result.setLayout((Layout)layout);
        this.table = this.createTable(result, layout);
        int wHint = 200;
        int hHint = this.table.getItemHeight() * 8 + this.table.getHeaderHeight();
        GridDataFactory.fillDefaults().grab(true, false).hint(wHint, hHint).applyTo((Control)result);
        this.addUIControl(this.table, BIND_ID_TABLE);
        return result;
    }

    private Control getUIControl(String id) {
        Control result = null;
        SWTBindingPropertyLocator bpLocator = SWTBindingPropertyLocator.getInstance();
        Iterator<Object> iter = this.controls.iterator();
        while (result == null && iter.hasNext()) {
            Control control = (Control)iter.next();
            if (!id.equals(bpLocator.locateBindingProperty(control))) continue;
            result = control;
        }
        Assert.isNotNull(result);
        return result;
    }
}

