/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.communication.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.riena.communication.core.util.CommunicationUtil;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteServiceDescription {
    private State state = State.REGISTERED;
    private transient Class<?> serviceInterfaceClass;
    private transient Object service;
    private transient ServiceReference serviceRef;
    private String path;
    private String version;
    private String bundleName;
    private String serviceInterfaceClassName;
    private String url;
    private String protocol;
    private Map<String, Object> properties = new HashMap<String, Object>();

    public RemoteServiceDescription() {
    }

    public RemoteServiceDescription(ServiceReference serviceRef, Object service, Class<?> serverInterface) {
        this();
        String[] keys;
        this.serviceRef = serviceRef;
        this.service = service;
        String[] stringArray = keys = serviceRef.getPropertyKeys();
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            if (key.equals("objectClass")) {
                this.serviceInterfaceClass = serverInterface;
                this.serviceInterfaceClassName = this.serviceInterfaceClass.getName();
            } else if (key.equals("riena.remote.protocol")) {
                this.protocol = CommunicationUtil.accessProperty(serviceRef.getProperty("riena.remote.protocol"), null);
            } else if (key.equals("riena.remote.path")) {
                this.path = CommunicationUtil.accessProperty(serviceRef.getProperty("riena.remote.path"), null);
            } else {
                this.setProperty(key, CommunicationUtil.accessProperty(serviceRef.getProperty(key), null));
            }
            ++n2;
        }
        this.bundleName = serviceRef.getBundle().getSymbolicName();
    }

    public void dispose() {
        this.bundleName = null;
        this.service = null;
        this.serviceRef = null;
        this.serviceInterfaceClass = null;
        this.serviceInterfaceClassName = null;
        this.path = null;
        this.url = null;
        this.version = null;
        this.protocol = null;
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public String getPath() {
        return this.path;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public Object getService() {
        return this.service;
    }

    public Class<?> getServiceInterfaceClass() {
        return this.serviceInterfaceClass;
    }

    public String getServiceInterfaceClassName() {
        return this.serviceInterfaceClassName;
    }

    public ServiceReference getServiceRef() {
        return this.serviceRef;
    }

    public State getState() {
        return this.state;
    }

    public String getURL() {
        return this.url;
    }

    public String getVersion() {
        return this.version;
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public void setBundleName(String bundleName) {
        this.bundleName = bundleName;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setService(Object service) {
        this.service = service;
    }

    public void setServiceInterfaceClass(Class<?> interfaceClass) {
        this.serviceInterfaceClass = interfaceClass;
    }

    public void setServiceInterfaceClassName(String interfaceClassName) {
        this.serviceInterfaceClassName = interfaceClassName;
    }

    public void setServiceRef(ServiceReference serviceRef) {
        this.serviceRef = serviceRef;
    }

    public void setState(State type) {
        this.state = type;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String toString() {
        return "protocol=" + this.protocol + ", url=" + this.url + ", interface=" + this.serviceInterfaceClassName;
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        REGISTERED,
        MODIFIED,
        UNREGISTERED;

    }
}

