/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.RienaConstants;
import org.eclipse.riena.core.RienaPlugin;
import org.eclipse.riena.core.exception.IExceptionHandlerManager;
import org.eclipse.riena.core.wire.Wire;
import org.eclipse.riena.internal.core.StartupsSafeRunnable;
import org.eclipse.riena.internal.core.exceptionmanager.SimpleExceptionHandlerManager;
import org.eclipse.riena.internal.core.logging.LoggerMill;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceRegistration;

public class Activator
extends RienaPlugin {
    public static final String PLUGIN_ID = "org.eclipse.riena.core";
    private boolean active = false;
    private ServiceRegistration loggerMillServiceReg;
    private LoggerMill loggerMill;
    private static Activator plugin;

    public Activator() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.startLogging();
        this.logStage(this.getLogger(Activator.class));
        this.startStartupListener();
        this.startExceptionHandling();
    }

    private void startLogging() {
        this.loggerMill = new LoggerMill();
        Wire.instance(this.loggerMill).andStart(this.getContext());
        this.loggerMillServiceReg = this.getContext().registerService(LoggerMill.class.getName(), (Object)this.loggerMill, RienaConstants.newDefaultServiceProperties());
    }

    private void logStage(Logger logger) {
        String stage;
        IStringVariableManager variableManager = VariablesPlugin.getDefault().getStringVariableManager();
        try {
            stage = variableManager.performStringSubstitution("Riena is running in stage '${riena.stage}'.");
        }
        catch (CoreException coreException) {
            stage = "No stage information set.";
        }
        logger.log(3, stage);
    }

    private void startStartupListener() {
        StartupBundleListener bundleListener = new StartupBundleListener();
        this.getContext().addBundleListener((BundleListener)bundleListener);
    }

    private void startExceptionHandling() {
        SimpleExceptionHandlerManager handlerManager = new SimpleExceptionHandlerManager();
        Wire.instance(handlerManager).andStart(this.getContext());
        this.getContext().registerService(IExceptionHandlerManager.class.getName(), (Object)handlerManager, RienaConstants.newDefaultServiceProperties());
    }

    public void stop(BundleContext context) throws Exception {
        this.active = false;
        plugin = null;
        context.ungetService(this.loggerMillServiceReg.getReference());
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public boolean isActive() {
        return this.active;
    }

    private class StartupBundleListener
    implements BundleListener {
        private StartupBundleListener() {
        }

        public void bundleChanged(BundleEvent event) {
            if (Activator.getDefault() == null) {
                return;
            }
            if (event.getBundle() == Activator.this.getContext().getBundle() && event.getType() == 2) {
                Activator.this.active = true;
                StartupsSafeRunnable safeRunnable = new StartupsSafeRunnable();
                Wire.instance(safeRunnable).andStart(Activator.this.getContext());
                SafeRunner.run((ISafeRunnable)safeRunnable);
                Activator.this.getContext().removeBundleListener((BundleListener)this);
            }
        }
    }
}

