/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.controllers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import org.eclipse.riena.beans.common.Person;
import org.eclipse.riena.beans.common.PersonFactory;
import org.eclipse.riena.beans.common.PersonManager;
import org.eclipse.riena.internal.example.client.beans.PersonModificationBean;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.IComboRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;

public class ComboSubModuleController
extends SubModuleController {
    private final PersonManager manager = new PersonManager((Collection)PersonFactory.createPersonList());
    private final PersonModificationBean value;
    private IComboRidget comboOne;
    private ITextRidget textFirst;
    private ITextRidget textLast;

    public ComboSubModuleController() {
        this(null);
    }

    public ComboSubModuleController(ISubModuleNode navigationNode) {
        super(navigationNode);
        this.manager.setSelectedPerson((Person)this.manager.getPersons().iterator().next());
        this.value = new PersonModificationBean();
    }

    public void afterBind() {
        super.afterBind();
        this.bindModels();
    }

    private void bindModels() {
        this.comboOne.bindToModel((Object)this.manager, "persons", String.class, null, (Object)this.manager, "selectedPerson");
        this.comboOne.updateFromModel();
        this.textFirst.bindToModel((Object)this.value, "firstName");
        this.textFirst.updateFromModel();
        this.textLast.bindToModel((Object)this.value, "lastName");
        this.textLast.updateFromModel();
    }

    public void configureRidgets() {
        this.comboOne = (IComboRidget)this.getRidget("comboOne");
        this.value.setPerson(this.manager.getSelectedPerson());
        this.textFirst = (ITextRidget)this.getRidget("textFirst");
        this.textLast = (ITextRidget)this.getRidget("textLast");
        this.comboOne.addPropertyChangeListener("selection", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                Person selectedPerson = (Person)evt.getNewValue();
                ComboSubModuleController.this.value.setPerson(selectedPerson);
                ComboSubModuleController.this.textFirst.updateFromModel();
                ComboSubModuleController.this.textLast.updateFromModel();
            }
        });
        IActionRidget buttonSave = (IActionRidget)this.getRidget("buttonSave");
        buttonSave.setText("&Save");
        buttonSave.addListener(new IActionListener(){

            public void callback() {
                ComboSubModuleController.this.value.update();
                ComboSubModuleController.this.comboOne.updateFromModel();
            }
        });
    }
}

