/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.component;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.listener.ApplicationNodeListener;
import org.eclipse.riena.navigation.listener.INavigationNodeListener;
import org.eclipse.riena.navigation.listener.SubApplicationNodeListener;
import org.eclipse.riena.navigation.ui.swt.component.SubApplicationItem;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.SubApplicationSwitcherRenderer;
import org.eclipse.riena.ui.core.marker.DisabledMarker;
import org.eclipse.riena.ui.core.marker.HiddenMarker;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubApplicationSwitcherWidget
extends Canvas {
    private List<SubApplicationItem> items;
    private TabSelector tabSelector;
    private PaintDelegation paintDelegation;
    private Control control = this;
    private ApplicationListener applicationListener;
    private SubApplicationListener subApplicationListener;

    public SubApplicationSwitcherWidget(Composite parent, int style, IApplicationNode application) {
        super(parent, style | 0x20000000);
        this.items = new ArrayList<SubApplicationItem>();
        this.applicationListener = new ApplicationListener();
        this.subApplicationListener = new SubApplicationListener();
        this.registerItems(application);
        this.addListeners();
    }

    private void addListeners() {
        this.tabSelector = new TabSelector();
        this.addMouseListener((MouseListener)this.tabSelector);
        this.paintDelegation = new PaintDelegation();
        this.addPaintListener(this.paintDelegation);
    }

    private void removeListeners() {
        this.removePaintListener(this.paintDelegation);
        this.removeMouseListener((MouseListener)this.tabSelector);
    }

    private SubApplicationItem getItem(Point point) {
        for (SubApplicationItem item : this.getItems()) {
            if (!item.getBounds().contains(point)) continue;
            return item;
        }
        return null;
    }

    private boolean isTabEnabled(SubApplicationItem item) {
        if (item == null) {
            return false;
        }
        if (!item.getMarkersOfType(HiddenMarker.class).isEmpty()) {
            return false;
        }
        return item.getMarkersOfType(DisabledMarker.class).isEmpty();
    }

    private List<SubApplicationItem> getItems() {
        return this.items;
    }

    private void registerItems(IApplicationNode applicationModel) {
        applicationModel.addListener((INavigationNodeListener)this.applicationListener);
        List subApps = applicationModel.getChildren();
        for (ISubApplicationNode subApp : subApps) {
            this.registerSubApplication(subApp);
        }
    }

    private void registerSubApplication(ISubApplicationNode subApp) {
        subApp.addListener((INavigationNodeListener)this.subApplicationListener);
        SubApplicationItem item = new SubApplicationItem((Composite)this, subApp);
        item.setIcon(subApp.getIcon());
        item.setLabel(subApp.getLabel());
        this.getItems().add(item);
    }

    private void unregisterSubApplication(ISubApplicationNode subApp) {
        subApp.removeListener((INavigationNodeListener)this.subApplicationListener);
        SubApplicationItem itemToRemove = null;
        for (SubApplicationItem item : this.getItems()) {
            if (!item.getSubApplicationNode().equals(subApp)) continue;
            itemToRemove = item;
            break;
        }
        if (itemToRemove != null) {
            this.getItems().remove(itemToRemove);
        }
    }

    private SubApplicationSwitcherRenderer getRenderer() {
        return (SubApplicationSwitcherRenderer)LnfManager.getLnf().getRenderer("SubApplication.switcherRenderer");
    }

    public void dispose() {
        this.removeListeners();
        super.dispose();
    }

    private final class ApplicationListener
    extends ApplicationNodeListener {
        private ApplicationListener() {
        }

        public void childRemoved(IApplicationNode source, ISubApplicationNode childRemoved) {
            SubApplicationSwitcherWidget.this.unregisterSubApplication(childRemoved);
            SubApplicationSwitcherWidget.this.redraw();
        }

        public void childAdded(IApplicationNode source, ISubApplicationNode childAdded) {
            SubApplicationSwitcherWidget.this.registerSubApplication(childAdded);
            SubApplicationSwitcherWidget.this.redraw();
        }
    }

    private class PaintDelegation
    implements PaintListener {
        private PaintDelegation() {
        }

        public void paintControl(PaintEvent e) {
            GC gc = e.gc;
            SubApplicationSwitcherWidget.this.getRenderer().setBounds(SubApplicationSwitcherWidget.this.getParent().getBounds());
            SubApplicationSwitcherWidget.this.getRenderer().setItems(SubApplicationSwitcherWidget.this.getItems());
            SubApplicationSwitcherWidget.this.getRenderer().paint(gc, SubApplicationSwitcherWidget.this.control);
        }
    }

    private final class SubApplicationListener
    extends SubApplicationNodeListener {
        private SubApplicationListener() {
        }

        public void markerChanged(ISubApplicationNode source, IMarker marker) {
            SubApplicationSwitcherWidget.this.redraw();
        }

        public void disposed(ISubApplicationNode source) {
            SubApplicationSwitcherWidget.this.unregisterSubApplication(source);
            SubApplicationSwitcherWidget.this.redraw();
        }
    }

    private class TabSelector
    extends MouseAdapter {
        private TabSelector() {
        }

        public void mouseDown(MouseEvent e) {
            SubApplicationItem item = SubApplicationSwitcherWidget.this.getItem(new Point(e.x, e.y));
            if (SubApplicationSwitcherWidget.this.isTabEnabled(item)) {
                item.getSubApplicationNode().activate();
                SubApplicationSwitcherWidget.this.redraw();
            }
        }
    }
}

