/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.lnf.renderer;

import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.internal.navigation.ui.swt.Activator;
import org.eclipse.riena.ui.swt.lnf.AbstractLnfRenderer;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.utils.ImageStore;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;

public class ShellLogoRenderer
extends AbstractLnfRenderer {
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), ShellLogoRenderer.class);

    public void paint(GC gc, Object value) {
        Image logo = this.getLogoImage();
        if (logo == null) {
            return;
        }
        int logoWidth = logo.getBounds().width;
        int logoHeight = logo.getBounds().height;
        int hMargin = ShellLogoRenderer.getHorizontalLogoMargin();
        int vMargin = this.getVerticalLogoMargin();
        int x = this.getBounds().x;
        Integer hPos = this.getHorizontalLogoPosition();
        switch (hPos) {
            case 0x1000000: {
                x = this.getBounds().width / 2 - logoWidth / 2;
                break;
            }
            case 131072: {
                x = this.getBounds().width - logoWidth - hMargin;
                break;
            }
            default: {
                x = hMargin;
            }
        }
        int y = this.getBounds().y;
        Integer vPos = this.getVerticalLogoPosition();
        switch (vPos) {
            case 0x1000000: {
                y = this.getBounds().height / 2 - logoHeight / 2;
                y += vMargin;
                break;
            }
            case 1024: {
                y = this.getBounds().height - logoHeight - vMargin;
                break;
            }
            default: {
                y = vMargin;
            }
        }
        gc.drawImage(logo, x, y);
    }

    public void dispose() {
    }

    public static Integer getHorizontalLogoMargin() {
        Integer margin = LnfManager.getLnf().getIntegerSetting("TitlelessShell.horizontalLogoMargin");
        if (margin == null) {
            margin = 0;
        }
        return margin;
    }

    private Integer getVerticalLogoMargin() {
        Integer margin = LnfManager.getLnf().getIntegerSetting("TitlelessShell.verticalLogoMargin");
        if (margin == null) {
            margin = 0;
        }
        return margin;
    }

    private int getHorizontalLogoPosition() {
        Integer hPos = LnfManager.getLnf().getIntegerSetting("TitlelessShell.horizontalLogoPosition");
        if (hPos == null) {
            hPos = 16384;
        }
        return hPos;
    }

    private int getVerticalLogoPosition() {
        Integer hPos = LnfManager.getLnf().getIntegerSetting("TitlelessShell.verticalLogoPosition");
        if (hPos == null) {
            hPos = 128;
        }
        return hPos;
    }

    private Image getLogoImage() {
        Image logoImage = LnfManager.getLnf().getImage("TitlelessShell.logo");
        if (logoImage == null) {
            String message = "The image of the logo wasn't found! A dummy image is used.";
            LOGGER.log(2, message);
            logoImage = ImageStore.getInstance().getMissingImage();
        }
        return logoImage;
    }
}

