/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import java.lang.reflect.Constructor;
import org.eclipse.riena.navigation.IModuleGroupNode;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.ui.controllers.ModuleController;
import org.eclipse.riena.navigation.ui.controllers.ModuleGroupController;
import org.eclipse.riena.navigation.ui.swt.views.IViewFactory;
import org.eclipse.riena.navigation.ui.swt.views.ModuleGroupView;
import org.eclipse.riena.navigation.ui.swt.views.ModuleView;
import org.eclipse.riena.navigation.ui.swt.views.SWTModuleController;
import org.eclipse.riena.navigation.ui.swt.views.desc.IModuleDesc;
import org.eclipse.riena.navigation.ui.swt.views.desc.IModuleGroupDesc;
import org.eclipse.swt.widgets.Composite;

public class NavigationViewFactory
implements IViewFactory {
    private IModuleDesc moduleDesc;
    private IModuleGroupDesc moduleGroupDesc;

    public void update(IModuleDesc moduleView) {
        this.moduleDesc = moduleView;
    }

    public void update(IModuleGroupDesc moduleGroup) {
        this.moduleGroupDesc = moduleGroup;
    }

    public ModuleGroupView createModuleGroupView(Composite parent) {
        Class<ModuleGroupView> moduleGroupClazz;
        if (this.moduleGroupDesc != null && (moduleGroupClazz = this.moduleGroupDesc.getView()) != null) {
            try {
                Constructor<ModuleGroupView> constructor = moduleGroupClazz.getConstructor(Composite.class, Integer.TYPE);
                return constructor.newInstance(parent, 0);
            }
            catch (Exception e) {
                throw new RuntimeException("Instantiating the configured ModuleGroupView " + moduleGroupClazz + " failed.", e);
            }
        }
        return new ModuleGroupView(parent, 0);
    }

    public ModuleGroupController createModuleGroupController(IModuleGroupNode moduleGroupNode) {
        Class<ModuleGroupController> moduleGroupClazz;
        if (this.moduleGroupDesc != null && (moduleGroupClazz = this.moduleGroupDesc.getController()) != null) {
            try {
                Constructor<ModuleGroupController> constructor = moduleGroupClazz.getConstructor(IModuleGroupNode.class);
                return constructor.newInstance(moduleGroupNode);
            }
            catch (Exception e) {
                throw new RuntimeException("Instantiating the configured ModuleGroupController " + moduleGroupClazz + " failed.", e);
            }
        }
        return new ModuleGroupController(moduleGroupNode);
    }

    public ModuleView createModuleView(Composite parent) {
        if (this.moduleDesc != null) {
            Class<ModuleView> moduleViewClazz = this.moduleDesc.getView();
            try {
                Constructor<ModuleView> constructor = moduleViewClazz.getConstructor(Composite.class);
                return constructor.newInstance(parent);
            }
            catch (Exception e) {
                throw new RuntimeException("Instantiating the configured ModuleView " + moduleViewClazz + " failed.", e);
            }
        }
        return new ModuleView(parent);
    }

    public ModuleController createModuleController(IModuleNode moduleNode) {
        Class<ModuleController> moduleViewClazz;
        if (this.moduleDesc != null && (moduleViewClazz = this.moduleDesc.getController()) != null) {
            try {
                Constructor<ModuleController> constructor = moduleViewClazz.getConstructor(IModuleNode.class);
                return constructor.newInstance(moduleNode);
            }
            catch (Exception e) {
                throw new RuntimeException("Instantiating the configured ModuleController " + moduleViewClazz + " failed.", e);
            }
        }
        return new SWTModuleController(moduleNode);
    }
}

