/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.communication.core.hooks;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.Subject;
import org.eclipse.riena.communication.core.hooks.Adder;
import org.eclipse.riena.communication.core.hooks.FreeAdder;
import org.eclipse.riena.communication.core.hooks.HooksProxy;
import org.eclipse.riena.communication.core.hooks.IAdder;
import org.eclipse.riena.core.util.ReflectionFailure;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.tests.RienaTestCase;
import org.eclipse.riena.tests.collect.NonUITestCase;

@NonUITestCase
public class AbstractHooksProxyTest
extends RienaTestCase {
    public void testProxySameInterfaceAsDelegate() {
        IAdder adder = (IAdder)this.newHooksProxy(new Adder());
        AbstractHooksProxyTest.assertEquals((String)"Hello World", (String)adder.add("Hello ", "World"));
        AbstractHooksProxyTest.assertEquals((String)"12", (String)adder.add((Number)1, (Number)2));
        AbstractHooksProxyTest.assertEquals((String)"3", (String)adder.add(1, 2));
        this.assertMethodTableUsage(false, adder);
    }

    public void testProxySameInterfaceAsDelegateWithSubject() {
        IAdder adder = (IAdder)this.newHooksProxy(new Adder(), new Subject());
        AbstractHooksProxyTest.assertEquals((String)"Hello World", (String)adder.add("Hello ", "World"));
        AbstractHooksProxyTest.assertEquals((String)"12", (String)adder.add((Number)1, (Number)2));
        AbstractHooksProxyTest.assertEquals((String)"3", (String)adder.add(1, 2));
        this.assertMethodTableUsage(false, adder);
    }

    public void testProxyCallsProxyWithSameInterface() {
        IAdder adder = (IAdder)this.newHooksProxy(this.newHooksProxy(new Adder()));
        AbstractHooksProxyTest.assertEquals((String)"Hello World", (String)adder.add("Hello ", "World"));
        AbstractHooksProxyTest.assertEquals((String)"12", (String)adder.add((Number)1, (Number)2));
        AbstractHooksProxyTest.assertEquals((String)"3", (String)adder.add(1, 2));
        this.assertMethodTableUsage(false, adder);
    }

    public void testProxyCallsProxyWithSameInterfaceWithSubject() {
        IAdder adder = (IAdder)this.newHooksProxy(this.newHooksProxy(new Adder(), new Subject()));
        AbstractHooksProxyTest.assertEquals((String)"Hello World", (String)adder.add("Hello ", "World"));
        AbstractHooksProxyTest.assertEquals((String)"12", (String)adder.add((Number)1, (Number)2));
        AbstractHooksProxyTest.assertEquals((String)"3", (String)adder.add(1, 2));
        this.assertMethodTableUsage(false, adder);
    }

    public void testProxyCallsObjectWithSameMethodButNotInInterface() {
        IAdder adder = (IAdder)this.newHooksProxy(new FreeAdder());
        AbstractHooksProxyTest.assertEquals((String)"Hello World", (String)adder.add("Hello ", "World"));
        AbstractHooksProxyTest.assertEquals((String)"12", (String)adder.add((Number)1, (Number)2));
        AbstractHooksProxyTest.assertEquals((String)"3", (String)adder.add(1, 2));
        this.assertMethodTableUsage(true, adder);
    }

    public void testProxyCallsObjectWithSameMethodButNotInInterfaceWithSubject() {
        IAdder adder = (IAdder)this.newHooksProxy(new FreeAdder(), new Subject());
        AbstractHooksProxyTest.assertEquals((String)"Hello World", (String)adder.add("Hello ", "World"));
        AbstractHooksProxyTest.assertEquals((String)"12", (String)adder.add((Number)1, (Number)2));
        AbstractHooksProxyTest.assertEquals((String)"3", (String)adder.add(1, 2));
        this.assertMethodTableUsage(true, adder);
    }

    private Object newHooksProxy(Object delegate) {
        return Proxy.newProxyInstance(AbstractHooksProxyTest.class.getClassLoader(), new Class[]{IAdder.class}, (InvocationHandler)((Object)new HooksProxy(delegate)));
    }

    private Object newHooksProxy(Object delegate, Subject subject) {
        return Proxy.newProxyInstance(AbstractHooksProxyTest.class.getClassLoader(), new Class[]{IAdder.class}, (InvocationHandler)((Object)new HooksProxy(delegate, subject)));
    }

    private void assertMethodTableUsage(boolean expected, Object proxy) {
        InvocationHandler handler = Proxy.getInvocationHandler(proxy);
        try {
            AtomicReference ref = (AtomicReference)ReflectionUtils.getHidden((Object)handler, (String)"methodTableRef");
            AbstractHooksProxyTest.assertEquals((boolean)expected, (ref.get() != null ? 1 : 0) != 0);
        }
        catch (ReflectionFailure reflectionFailure) {
            System.err.println("Culd not access 'methodTableRef' field.");
        }
    }
}

