/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.wire;

import java.lang.reflect.Method;
import org.eclipse.riena.core.injector.extension.ExtensionInjector;
import org.eclipse.riena.core.injector.extension.IData;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.core.wire.InjectExtension;
import org.eclipse.riena.internal.core.wire.ExtensionInjectorBuilder;
import org.eclipse.riena.tests.RienaTestCase;
import org.eclipse.riena.tests.collect.NonUITestCase;

@NonUITestCase
public class ExtensionInjectorBuilderTest
extends RienaTestCase {
    public void testBuildForUpdate1() throws NoSuchMethodException {
        Method bindMethod = ExtensionInjectorBuilderTest.class.getDeclaredMethod("update1", IData.class);
        ExtensionInjectorBuilder builder = new ExtensionInjectorBuilder((Object)this, bindMethod);
        ExtensionInjector injector = builder.build();
        ExtensionInjectorBuilderTest.assertNotNull((Object)injector);
        ExtensionInjectorBuilderTest.assertEquals((String)"test", (String)this.id(injector));
        ExtensionInjectorBuilderTest.assertEquals(IData.class, (Object)this.useType(injector));
        ExtensionInjectorBuilderTest.assertEquals((int)1, (int)this.getMin(injector));
        ExtensionInjectorBuilderTest.assertEquals((int)1, (int)this.getMax(injector));
        ExtensionInjectorBuilderTest.assertTrue((boolean)this.getHomogenious(injector));
        ExtensionInjectorBuilderTest.assertSame((Object)((Object)this), (Object)this.getBean(injector));
        ExtensionInjectorBuilderTest.assertEquals((String)"update1", (String)this.getUpdate(injector));
        ExtensionInjectorBuilderTest.assertFalse((boolean)this.getDoNotReplaceSymbols(injector));
        ExtensionInjectorBuilderTest.assertFalse((boolean)this.getSpecific(injector));
    }

    @InjectExtension(id="test")
    public void update1(IData data) {
    }

    public void testBuildForUpdate2() throws NoSuchMethodException {
        Method bindMethod = ExtensionInjectorBuilderTest.class.getDeclaredMethod("update2", IData[].class);
        ExtensionInjectorBuilder builder = new ExtensionInjectorBuilder((Object)this, bindMethod);
        ExtensionInjector injector = builder.build();
        ExtensionInjectorBuilderTest.assertNotNull((Object)injector);
        ExtensionInjectorBuilderTest.assertEquals((String)"test", (String)this.id(injector));
        ExtensionInjectorBuilderTest.assertEquals(IData.class, (Object)this.useType(injector));
        ExtensionInjectorBuilderTest.assertEquals((int)2, (int)this.getMin(injector));
        ExtensionInjectorBuilderTest.assertEquals((int)5, (int)this.getMax(injector));
        ExtensionInjectorBuilderTest.assertFalse((boolean)this.getHomogenious(injector));
        ExtensionInjectorBuilderTest.assertSame((Object)((Object)this), (Object)this.getBean(injector));
        ExtensionInjectorBuilderTest.assertEquals((String)"update2", (String)this.getUpdate(injector));
        ExtensionInjectorBuilderTest.assertTrue((boolean)this.getDoNotReplaceSymbols(injector));
        ExtensionInjectorBuilderTest.assertTrue((boolean)this.getSpecific(injector));
    }

    @InjectExtension(id="test", doNotReplaceSymbols=true, heterogeneous=true, specific=true, min=2, max=5)
    public void update2(IData[] data) {
    }

    private String id(ExtensionInjector injector) {
        Object extensionDescriptor = ReflectionUtils.getHidden((Object)injector, (String)"extensionDesc");
        return (String)ReflectionUtils.getHidden((Object)extensionDescriptor, (String)"extensionPointId");
    }

    private Object useType(ExtensionInjector injector) {
        Object extensionDescriptor = ReflectionUtils.getHidden((Object)injector, (String)"extensionDesc");
        return ReflectionUtils.getHidden((Object)extensionDescriptor, (String)"interfaceType");
    }

    private int getMin(ExtensionInjector injector) {
        Object extensionDescriptor = ReflectionUtils.getHidden((Object)injector, (String)"extensionDesc");
        return (Integer)ReflectionUtils.getHidden((Object)extensionDescriptor, (String)"minOccurences");
    }

    private int getMax(ExtensionInjector injector) {
        Object extensionDescriptor = ReflectionUtils.getHidden((Object)injector, (String)"extensionDesc");
        return (Integer)ReflectionUtils.getHidden((Object)extensionDescriptor, (String)"maxOccurences");
    }

    private boolean getHomogenious(ExtensionInjector injector) {
        Object extensionDescriptor = ReflectionUtils.getHidden((Object)injector, (String)"extensionDesc");
        return (Boolean)ReflectionUtils.getHidden((Object)extensionDescriptor, (String)"homogeneous");
    }

    private Object getBean(ExtensionInjector injector) {
        return ReflectionUtils.getHidden((Object)injector, (String)"target");
    }

    private String getUpdate(ExtensionInjector injector) {
        return (String)ReflectionUtils.getHidden((Object)injector, (String)"updateMethodName");
    }

    private boolean getDoNotReplaceSymbols(ExtensionInjector injector) {
        return (Boolean)ReflectionUtils.getHidden((Object)injector, (String)"symbolReplace") == false;
    }

    private boolean getSpecific(ExtensionInjector injector) {
        return (Boolean)ReflectionUtils.getHidden((Object)injector, (String)"nonSpecific") == false;
    }
}

