/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.controllers;

import java.beans.PropertyChangeSupport;
import java.util.Collection;
import junit.framework.TestCase;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.LabelRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.TextRidget;
import org.eclipse.riena.navigation.INavigationProcessor;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.model.NavigationProcessor;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.tests.collect.UITestCase;
import org.eclipse.riena.ui.core.marker.DisabledMarker;
import org.eclipse.riena.ui.core.marker.ErrorMarker;
import org.eclipse.riena.ui.core.marker.HiddenMarker;
import org.eclipse.riena.ui.core.marker.MandatoryMarker;
import org.eclipse.riena.ui.core.marker.OutputMarker;
import org.eclipse.riena.ui.ridgets.AbstractCompositeRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class NavigationNodeControllerTest
extends TestCase {
    private MyNavigationNodeController controller;
    private SubModuleNode node;
    private Shell shell;

    protected void setUp() throws Exception {
        Display display = Display.getDefault();
        this.shell = new Shell(display);
        this.shell.pack();
        this.shell.setVisible(true);
        Realm realm = SWTObservables.getRealm((Display)display);
        NavigationNodeControllerTest.assertNotNull((Object)realm);
        ReflectionUtils.invokeHidden((Object)realm, (String)"setDefault", (Object[])new Object[]{realm});
        this.node = new SubModuleNode();
        this.node.setNavigationProcessor((INavigationProcessor)new NavigationProcessor());
        this.controller = new MyNavigationNodeController((ISubModuleNode)this.node);
    }

    protected void tearDown() throws Exception {
        this.controller = null;
        this.node = null;
        SwtUtilities.disposeWidget((Widget)this.shell);
    }

    public void testAddRidget() {
        LabelRidget ridget = new LabelRidget();
        this.controller.addRidget("4711", (IRidget)ridget);
        NavigationNodeControllerTest.assertNotNull((Object)this.controller.getRidgets());
        NavigationNodeControllerTest.assertEquals((int)1, (int)this.controller.getRidgets().size());
        PropertyChangeSupport support = (PropertyChangeSupport)ReflectionUtils.getHidden((Object)ridget, (String)"propertyChangeSupport");
        NavigationNodeControllerTest.assertNotNull((Object)support.getPropertyChangeListeners());
        NavigationNodeControllerTest.assertEquals((int)2, (int)support.getPropertyChangeListeners().length);
    }

    public void testUpdateNavigationNodeMarkers() {
        this.node.addMarker((IMarker)new HiddenMarker());
        this.controller.updateNavigationNodeMarkers();
        NavigationNodeControllerTest.assertTrue((boolean)this.node.getMarkers().isEmpty());
        this.node.addMarker((IMarker)new HiddenMarker());
        TextRidget ridget = new TextRidget();
        ridget.setUIControl((Object)new Text((Composite)this.shell, 0));
        ridget.addMarker((IMarker)new ErrorMarker());
        this.controller.addRidget("4711", (IRidget)ridget);
        this.controller.updateNavigationNodeMarkers();
        NavigationNodeControllerTest.assertFalse((boolean)this.node.getMarkers().isEmpty());
        NavigationNodeControllerTest.assertTrue((boolean)this.node.getMarkersOfType(HiddenMarker.class).isEmpty());
        NavigationNodeControllerTest.assertFalse((boolean)this.node.getMarkersOfType(ErrorMarker.class).isEmpty());
        ridget.addMarker((IMarker)new MandatoryMarker());
        this.controller.updateNavigationNodeMarkers();
        NavigationNodeControllerTest.assertFalse((boolean)this.node.getMarkers().isEmpty());
        NavigationNodeControllerTest.assertFalse((boolean)this.node.getMarkersOfType(ErrorMarker.class).isEmpty());
        NavigationNodeControllerTest.assertFalse((boolean)this.node.getMarkersOfType(MandatoryMarker.class).isEmpty());
        ridget.setText("testtext");
        this.controller.updateNavigationNodeMarkers();
        NavigationNodeControllerTest.assertFalse((boolean)this.node.getMarkers().isEmpty());
        NavigationNodeControllerTest.assertFalse((boolean)this.node.getMarkersOfType(ErrorMarker.class).isEmpty());
        NavigationNodeControllerTest.assertTrue((boolean)this.node.getMarkersOfType(MandatoryMarker.class).isEmpty());
    }

    public void testGetRidgetMarkers() {
        TextRidget ridget = new TextRidget();
        ridget.setUIControl((Object)new Text((Composite)this.shell, 0));
        this.controller.addRidget("4711", (IRidget)ridget);
        TextRidget ridget2 = new TextRidget();
        ridget2.setUIControl((Object)new Text((Composite)this.shell, 0));
        this.controller.addRidget("0815", (IRidget)ridget2);
        Collection markers = (Collection)ReflectionUtils.invokeHidden((Object)((Object)this.controller), (String)"getRidgetMarkers", null);
        NavigationNodeControllerTest.assertNotNull((Object)markers);
        ErrorMarker errorMarker = new ErrorMarker();
        ridget.addMarker((IMarker)errorMarker);
        OutputMarker outputMarker = new OutputMarker();
        ridget2.addMarker((IMarker)outputMarker);
        markers = (Collection)ReflectionUtils.invokeHidden((Object)((Object)this.controller), (String)"getRidgetMarkers", null);
        NavigationNodeControllerTest.assertNotNull((Object)markers);
        NavigationNodeControllerTest.assertEquals((int)2, (int)markers.size());
        NavigationNodeControllerTest.assertTrue((boolean)markers.contains(errorMarker));
        NavigationNodeControllerTest.assertTrue((boolean)markers.contains(outputMarker));
        CompositeRidget compositeRidget = new CompositeRidget();
        TextRidget ridget3 = new TextRidget();
        ridget3.setUIControl((Object)new Text((Composite)this.shell, 0));
        compositeRidget.addRidget("label3", (IRidget)ridget3);
        this.controller.addRidget("comp", (IRidget)compositeRidget);
        MandatoryMarker mandatoryMarker = new MandatoryMarker();
        ridget3.addMarker((IMarker)mandatoryMarker);
        markers = (Collection)ReflectionUtils.invokeHidden((Object)((Object)this.controller), (String)"getRidgetMarkers", null);
        NavigationNodeControllerTest.assertNotNull((Object)markers);
        NavigationNodeControllerTest.assertEquals((int)3, (int)markers.size());
        NavigationNodeControllerTest.assertTrue((boolean)markers.contains(mandatoryMarker));
    }

    public void testHiddenAndDisabledMarkersBlockAllRidgetMarkers() throws Exception {
        TextRidget ridget = new TextRidget();
        ridget.setUIControl((Object)new Text((Composite)this.shell, 0));
        this.controller.addRidget("4711", (IRidget)ridget);
        TextRidget ridget2 = new TextRidget();
        ridget2.setUIControl((Object)new Text((Composite)this.shell, 0));
        this.controller.addRidget("0815", (IRidget)ridget2);
        ErrorMarker errorMarker = new ErrorMarker();
        MandatoryMarker mandatoryMarker = new MandatoryMarker();
        HiddenMarker hiddenMarker = new HiddenMarker();
        DisabledMarker disabledMarker = new DisabledMarker();
        ridget.addMarker((IMarker)errorMarker);
        ridget.addMarker((IMarker)mandatoryMarker);
        Collection markers = (Collection)ReflectionUtils.invokeHidden((Object)((Object)this.controller), (String)"getRidgetMarkers", null);
        NavigationNodeControllerTest.assertEquals((int)2, (int)markers.size());
        NavigationNodeControllerTest.assertTrue((boolean)markers.contains(errorMarker));
        NavigationNodeControllerTest.assertTrue((boolean)markers.contains(mandatoryMarker));
        ridget.addMarker((IMarker)hiddenMarker);
        markers = (Collection)ReflectionUtils.invokeHidden((Object)((Object)this.controller), (String)"getRidgetMarkers", null);
        NavigationNodeControllerTest.assertTrue((boolean)markers.isEmpty());
        ridget2.addMarker((IMarker)errorMarker);
        ridget2.addMarker((IMarker)mandatoryMarker);
        markers = (Collection)ReflectionUtils.invokeHidden((Object)((Object)this.controller), (String)"getRidgetMarkers", null);
        NavigationNodeControllerTest.assertEquals((int)2, (int)markers.size());
        NavigationNodeControllerTest.assertTrue((boolean)markers.contains(errorMarker));
        NavigationNodeControllerTest.assertTrue((boolean)markers.contains(mandatoryMarker));
        ridget2.addMarker((IMarker)disabledMarker);
        markers = (Collection)ReflectionUtils.invokeHidden((Object)((Object)this.controller), (String)"getRidgetMarkers", null);
        NavigationNodeControllerTest.assertTrue((boolean)markers.isEmpty());
        ridget.removeMarker((IMarker)hiddenMarker);
        markers = (Collection)ReflectionUtils.invokeHidden((Object)((Object)this.controller), (String)"getRidgetMarkers", null);
        NavigationNodeControllerTest.assertEquals((int)2, (int)markers.size());
        NavigationNodeControllerTest.assertTrue((boolean)markers.contains(errorMarker));
        NavigationNodeControllerTest.assertTrue((boolean)markers.contains(mandatoryMarker));
    }

    private static class CompositeRidget
    extends AbstractCompositeRidget {
        private CompositeRidget() {
        }
    }

    private static class MyNavigationNodeController
    extends SubModuleController {
        public MyNavigationNodeController(ISubModuleNode navigationNode) {
            super(navigationNode);
        }

        public void updateNavigationNodeMarkers() {
            super.updateNavigationNodeMarkers();
        }
    }
}

