/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.security.services.itest.authentication;

import java.net.URL;
import javax.security.auth.login.LoginException;
import org.eclipse.equinox.security.auth.ILoginContext;
import org.eclipse.equinox.security.auth.LoginContextFactory;
import org.eclipse.riena.communication.core.IRemoteServiceRegistration;
import org.eclipse.riena.communication.core.factory.Register;
import org.eclipse.riena.internal.tests.Activator;
import org.eclipse.riena.security.authentication.callbackhandler.TestLocalCallbackHandler;
import org.eclipse.riena.security.common.authentication.IAuthenticationService;
import org.eclipse.riena.tests.RienaTestCase;
import org.eclipse.riena.tests.collect.IntegrationTestCase;

@IntegrationTestCase
public class AuthenticationLoginModuleITest
extends RienaTestCase {
    private IRemoteServiceRegistration authenticationService;
    private static final String JAAS_CONFIG_FILE = "config/sample_jaas.config";

    protected void setUp() throws Exception {
        super.setUp();
        this.startBundles("org\\.eclipse\\.riena.communication.core", null);
        this.startBundles("org\\.eclipse\\.riena.communication.factory.hessian", null);
        this.startBundles("org\\.eclipse\\.riena.communication.registry", null);
        this.authenticationService = Register.remoteProxy(IAuthenticationService.class).usingUrl("http://localhost:8080/hessian/AuthenticationService").withProtocol("hessian").andStart(Activator.getDefault().getContext());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.authenticationService.unregister();
    }

    public void testRemoteLogin() throws LoginException {
        TestLocalCallbackHandler.setSuppliedCredentials("testuser", "testpass");
        URL configUrl = Activator.getDefault().getContext().getBundle().getEntry(JAAS_CONFIG_FILE);
        ILoginContext secureContext = LoginContextFactory.createContext((String)"Remote", (URL)configUrl);
        secureContext.login();
        AuthenticationLoginModuleITest.assertNotNull((Object)secureContext.getSubject());
        AuthenticationLoginModuleITest.assertNotNull(secureContext.getSubject().getPrincipals());
        AuthenticationLoginModuleITest.assertTrue((secureContext.getSubject().getPrincipals().size() > 0 ? 1 : 0) != 0);
        System.out.println("subject:" + secureContext.getSubject());
        System.out.println("login in sucessful");
        secureContext.logout();
        System.out.println("logoff sucessful");
    }
}

