/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.validation.tests;

import java.text.DecimalFormat;
import java.util.Locale;
import org.eclipse.riena.tests.RienaTestCase;
import org.eclipse.riena.tests.TestUtils;
import org.eclipse.riena.tests.collect.NonUITestCase;
import org.eclipse.riena.ui.ridgets.validation.MaxNumberLength;
import org.eclipse.riena.ui.ridgets.validation.ValidationFailure;

@NonUITestCase
public class MaxNumberLengthTest
extends RienaTestCase {
    public void testUSLocale() throws Exception {
        MaxNumberLength maxNumberLength = new MaxNumberLength(7, Locale.US);
        try {
            maxNumberLength.validate(new Object());
            MaxNumberLengthTest.fail((String)("expected thrown " + ValidationFailure.class.getName()));
        }
        catch (ValidationFailure validationFailure) {
            this.ok("passed test");
        }
        catch (RuntimeException runtimeException) {
            MaxNumberLengthTest.fail((String)("expected thrown " + ValidationFailure.class.getName()));
        }
        MaxNumberLengthTest.assertTrue((boolean)maxNumberLength.validate(null).isOK());
        MaxNumberLengthTest.assertTrue((boolean)maxNumberLength.validate((Object)"1234567").isOK());
        MaxNumberLengthTest.assertTrue((boolean)maxNumberLength.validate((Object)"1,234,567").isOK());
        MaxNumberLengthTest.assertTrue((boolean)maxNumberLength.validate((Object)"1234567").isOK());
        MaxNumberLengthTest.assertFalse((boolean)maxNumberLength.validate((Object)"12,345,678").isOK());
        MaxNumberLengthTest.assertTrue((boolean)maxNumberLength.validate((Object)"-1234567").isOK());
        MaxNumberLengthTest.assertTrue((boolean)maxNumberLength.validate((Object)"-1,234,567").isOK());
        MaxNumberLengthTest.assertTrue((boolean)maxNumberLength.validate((Object)"- 1234567").isOK());
        MaxNumberLengthTest.assertTrue((boolean)maxNumberLength.validate((Object)"- 1,234,567").isOK());
        MaxNumberLengthTest.assertFalse((boolean)maxNumberLength.validate((Object)"-12345678").isOK());
        MaxNumberLengthTest.assertFalse((boolean)maxNumberLength.validate((Object)"-12,345.678").isOK());
        MaxNumberLengthTest.assertTrue((boolean)maxNumberLength.validate((Object)"- 1234567").isOK());
        MaxNumberLengthTest.assertTrue((boolean)maxNumberLength.validate((Object)"- 1,234,567").isOK());
        MaxNumberLengthTest.assertFalse((boolean)maxNumberLength.validate((Object)"- 12345678").isOK());
        MaxNumberLengthTest.assertFalse((boolean)maxNumberLength.validate((Object)"- 12,345.678").isOK());
    }

    public void testGermanLocale() throws Exception {
        MaxNumberLength maxNumberLength = new MaxNumberLength(7, Locale.GERMANY);
        try {
            maxNumberLength.validate(new Object());
            MaxNumberLengthTest.fail((String)("expected thrown " + ValidationFailure.class.getName()));
        }
        catch (ValidationFailure validationFailure) {
            this.ok("passed test");
        }
        catch (RuntimeException runtimeException) {
            MaxNumberLengthTest.fail((String)("expected thrown " + ValidationFailure.class.getName()));
        }
        MaxNumberLengthTest.assertTrue((boolean)maxNumberLength.validate(null).isOK());
        MaxNumberLengthTest.assertTrue((boolean)maxNumberLength.validate((Object)"1234567").isOK());
        MaxNumberLengthTest.assertTrue((boolean)maxNumberLength.validate((Object)"1.234.567").isOK());
        MaxNumberLengthTest.assertTrue((boolean)maxNumberLength.validate((Object)"1234567").isOK());
        MaxNumberLengthTest.assertFalse((boolean)maxNumberLength.validate((Object)"12.345.678").isOK());
        MaxNumberLengthTest.assertTrue((boolean)maxNumberLength.validate((Object)"-1234567").isOK());
        MaxNumberLengthTest.assertTrue((boolean)maxNumberLength.validate((Object)"-1.234.567").isOK());
        MaxNumberLengthTest.assertTrue((boolean)maxNumberLength.validate((Object)"- 1234567").isOK());
        MaxNumberLengthTest.assertTrue((boolean)maxNumberLength.validate((Object)"- 1.234.567").isOK());
        MaxNumberLengthTest.assertFalse((boolean)maxNumberLength.validate((Object)"-12345678").isOK());
        MaxNumberLengthTest.assertFalse((boolean)maxNumberLength.validate((Object)"-12.345.678").isOK());
        MaxNumberLengthTest.assertFalse((boolean)maxNumberLength.validate((Object)"- 12345678").isOK());
        MaxNumberLengthTest.assertFalse((boolean)maxNumberLength.validate((Object)"- 12.345.678").isOK());
    }

    public void testFrenchLocale() throws Exception {
        MaxNumberLength maxNumberLength = new MaxNumberLength(7, Locale.FRANCE);
        try {
            maxNumberLength.validate(new Object());
            MaxNumberLengthTest.fail((String)("expected thrown " + ValidationFailure.class.getName()));
        }
        catch (ValidationFailure validationFailure) {
            this.ok("passed test");
        }
        catch (RuntimeException runtimeException) {
            MaxNumberLengthTest.fail((String)("expected thrown " + ValidationFailure.class.getName()));
        }
        MaxNumberLengthTest.assertTrue((boolean)maxNumberLength.validate(null).isOK());
        MaxNumberLengthTest.assertTrue((boolean)maxNumberLength.validate((Object)"1234567").isOK());
        MaxNumberLengthTest.assertTrue((boolean)maxNumberLength.validate((Object)"1 234 567").isOK());
        MaxNumberLengthTest.assertTrue((boolean)maxNumberLength.validate((Object)"1234567").isOK());
        MaxNumberLengthTest.assertFalse((boolean)maxNumberLength.validate((Object)"12 345 678").isOK());
        MaxNumberLengthTest.assertTrue((boolean)maxNumberLength.validate((Object)"-1234567").isOK());
        MaxNumberLengthTest.assertTrue((boolean)maxNumberLength.validate((Object)"-1 234 567").isOK());
        MaxNumberLengthTest.assertTrue((boolean)maxNumberLength.validate((Object)"- 1234567").isOK());
        MaxNumberLengthTest.assertTrue((boolean)maxNumberLength.validate((Object)"- 1 234 567").isOK());
        MaxNumberLengthTest.assertFalse((boolean)maxNumberLength.validate((Object)"-12345678").isOK());
        MaxNumberLengthTest.assertFalse((boolean)maxNumberLength.validate((Object)"-12 345 678").isOK());
        MaxNumberLengthTest.assertFalse((boolean)maxNumberLength.validate((Object)"- 12345678").isOK());
        MaxNumberLengthTest.assertFalse((boolean)maxNumberLength.validate((Object)"- 12 345 678").isOK());
        MaxNumberLengthTest.assertTrue((boolean)maxNumberLength.validate((Object)DecimalFormat.getInstance(Locale.FRANCE).format(1234567L)).isOK());
        MaxNumberLengthTest.assertFalse((boolean)maxNumberLength.validate((Object)DecimalFormat.getInstance(Locale.FRANCE).format(12345678L)).isOK());
    }

    public void testArabLocale() throws Exception {
        if (!TestUtils.isArabLocaleAvailable()) {
            System.err.println(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".testArabLocale(): Skipping test because no Arab locale is available. Use international JRE to run all tests.");
            return;
        }
        MaxNumberLength maxNumberLength = new MaxNumberLength(7, new Locale("ar", "AE"));
        try {
            maxNumberLength.validate(new Object());
            MaxNumberLengthTest.fail((String)("expected thrown " + ValidationFailure.class.getName()));
        }
        catch (ValidationFailure validationFailure) {
            this.ok("passed test");
        }
        catch (RuntimeException runtimeException) {
            MaxNumberLengthTest.fail((String)("expected thrown " + ValidationFailure.class.getName()));
        }
        MaxNumberLengthTest.assertTrue((boolean)maxNumberLength.validate(null).isOK());
        MaxNumberLengthTest.assertTrue((boolean)maxNumberLength.validate((Object)"1234567").isOK());
        MaxNumberLengthTest.assertTrue((boolean)maxNumberLength.validate((Object)"1,234,567").isOK());
        MaxNumberLengthTest.assertTrue((boolean)maxNumberLength.validate((Object)"1234567").isOK());
        MaxNumberLengthTest.assertFalse((boolean)maxNumberLength.validate((Object)"12,345,678").isOK());
        MaxNumberLengthTest.assertTrue((boolean)maxNumberLength.validate((Object)"1234567-").isOK());
        MaxNumberLengthTest.assertTrue((boolean)maxNumberLength.validate((Object)"1,234,567-").isOK());
        MaxNumberLengthTest.assertTrue((boolean)maxNumberLength.validate((Object)"1234567 -").isOK());
        MaxNumberLengthTest.assertTrue((boolean)maxNumberLength.validate((Object)"1,234,567 -").isOK());
        MaxNumberLengthTest.assertFalse((boolean)maxNumberLength.validate((Object)"12345678-").isOK());
        MaxNumberLengthTest.assertFalse((boolean)maxNumberLength.validate((Object)"12,345,678-").isOK());
        MaxNumberLengthTest.assertFalse((boolean)maxNumberLength.validate((Object)"12345678 -").isOK());
        MaxNumberLengthTest.assertFalse((boolean)maxNumberLength.validate((Object)"12,345,678 -").isOK());
        MaxNumberLengthTest.assertTrue((boolean)maxNumberLength.validate((Object)DecimalFormat.getInstance(new Locale("ar", "AE")).format(1234567L)).isOK());
        MaxNumberLengthTest.assertFalse((boolean)maxNumberLength.validate((Object)DecimalFormat.getInstance(new Locale("ar", "AE")).format(12345678L)).isOK());
    }

    public void testSetInitializationData() throws Exception {
        MaxNumberLength rule = new MaxNumberLength();
        MaxNumberLengthTest.assertTrue((boolean)rule.validate((Object)"").isOK());
        MaxNumberLengthTest.assertFalse((boolean)rule.validate((Object)"1").isOK());
        rule = new MaxNumberLength();
        rule.setInitializationData(null, null, (Object)"5");
        MaxNumberLengthTest.assertTrue((boolean)rule.validate((Object)"1").isOK());
        MaxNumberLengthTest.assertTrue((boolean)rule.validate((Object)"12345").isOK());
        MaxNumberLengthTest.assertFalse((boolean)rule.validate((Object)"123456").isOK());
        rule = new MaxNumberLength();
        String localString = String.valueOf(Locale.GERMANY.getLanguage()) + "," + Locale.GERMANY.getCountry();
        rule.setInitializationData(null, null, (Object)("5," + localString));
        MaxNumberLengthTest.assertTrue((boolean)rule.validate((Object)"10000").isOK());
        MaxNumberLengthTest.assertFalse((boolean)rule.validate((Object)"100000").isOK());
        MaxNumberLengthTest.assertTrue((boolean)rule.validate((Object)"10.000").isOK());
        MaxNumberLengthTest.assertFalse((boolean)rule.validate((Object)"10,000").isOK());
        MaxNumberLengthTest.assertFalse((boolean)rule.validate((Object)"100.000").isOK());
        MaxNumberLengthTest.assertTrue((boolean)rule.validate((Object)"1,012").isOK());
        MaxNumberLengthTest.assertTrue((boolean)rule.validate((Object)"123,0").isOK());
        MaxNumberLengthTest.assertFalse((boolean)rule.validate((Object)"12345,0").isOK());
        rule = new MaxNumberLength();
        localString = String.valueOf(Locale.US.getLanguage()) + "," + Locale.US.getCountry();
        rule.setInitializationData(null, null, (Object)("5," + localString));
        MaxNumberLengthTest.assertTrue((boolean)rule.validate((Object)"10000").isOK());
        MaxNumberLengthTest.assertFalse((boolean)rule.validate((Object)"100000").isOK());
        MaxNumberLengthTest.assertTrue((boolean)rule.validate((Object)"10,000").isOK());
        MaxNumberLengthTest.assertFalse((boolean)rule.validate((Object)"10.000").isOK());
        MaxNumberLengthTest.assertFalse((boolean)rule.validate((Object)"100,000").isOK());
    }
}

