/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.conversion.NumberToStringConverter;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.NumericTextRidget;
import org.eclipse.riena.ui.ridgets.IDecimalTextRidget;

public class DecimalTextRidget
extends NumericTextRidget
implements IDecimalTextRidget {
    public DecimalTextRidget() {
        this.setMaxLength(10);
        this.setPrecision(2);
        this.setText("0");
        this.setSigned(true);
    }

    protected void checkNumber(String number) {
        if (!"".equals(number)) {
            BigDecimal value = this.checkIsNumber(number);
            this.checkSigned(value);
            this.checkMaxLength(number);
            this.checkPrecision(number);
        }
    }

    protected boolean isNegative(String text) {
        BigDecimal value = new BigDecimal(this.localStringToBigDecimal(text));
        return value.compareTo(BigDecimal.ZERO) < 0;
    }

    protected boolean isNotEmpty(String text) {
        String stripped = DecimalTextRidget.removeLeadingCruft(DecimalTextRidget.removeTrailingPadding(text));
        return stripped.length() > 0;
    }

    public synchronized int getMaxLength() {
        return super.getMaxLength();
    }

    public synchronized int getPrecision() {
        return super.getPrecision();
    }

    public final synchronized void setMaxLength(int maxLength) {
        Assert.isLegal((maxLength > 0 ? 1 : 0) != 0, (String)("maxLength must be greater than zero: " + maxLength));
        int oldValue = this.getMaxLength();
        if (oldValue != maxLength) {
            super.setMaxLength(maxLength);
            this.firePropertyChange("maxLength", oldValue, maxLength);
        }
    }

    public final synchronized void setPrecision(int numberOfFractionDigits) {
        Assert.isLegal((numberOfFractionDigits > -1 ? 1 : 0) != 0, (String)("numberOfFractionDigits must > -1: " + numberOfFractionDigits));
        int oldValue = this.getPrecision();
        if (oldValue != numberOfFractionDigits) {
            super.setPrecision(numberOfFractionDigits);
            this.firePropertyChange("precision", oldValue, numberOfFractionDigits);
        }
    }

    public synchronized void updateFromModel() {
        this.checkValue();
        super.updateFromModel();
    }

    private BigDecimal checkIsNumber(String number) {
        try {
            return new BigDecimal(this.localStringToBigDecimal(number));
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException("Not a valid decimal: " + number);
        }
    }

    private void checkMaxLength(String number) {
        int length;
        int maxLength = this.getMaxLength();
        int decSepIndex = number.indexOf(DECIMAL_SEPARATOR);
        if (decSepIndex != -1) {
            String decimalPart = number.substring(0, decSepIndex);
            length = decimalPart.length() - StringUtils.count((String)decimalPart, (char)GROUPING_SEPARATOR);
        } else {
            length = number.length() - StringUtils.count((String)number, (char)GROUPING_SEPARATOR);
        }
        if (maxLength < length) {
            String msg = String.format("Length (%d) exceeded: %s", maxLength, number);
            throw new NumberFormatException(msg);
        }
    }

    private void checkPrecision(String number) {
        int fractionalDigits;
        int precision;
        int decSepIndex = number.indexOf(DECIMAL_SEPARATOR);
        if (decSepIndex != -1 && (precision = this.getPrecision()) < (fractionalDigits = number.substring(decSepIndex).length() - 1)) {
            String msg = String.format("Precision (%d) exceeded: %s", precision, number);
            throw new NumberFormatException(msg);
        }
    }

    private void checkSigned(BigDecimal value) {
        if (!this.isSigned() && value.compareTo(BigDecimal.ZERO) == -1) {
            throw new NumberFormatException("Negative numbers not allowed: " + value);
        }
    }

    private void checkValue() {
        IConverter converter;
        Object value = this.getValueBindingSupport().getModelObservable().getValue();
        if (value != null && (converter = this.getConverter(value)) != null) {
            this.checkNumber((String)converter.convert(value));
        }
    }

    private IConverter getConverter(Object value) {
        Assert.isNotNull((Object)value);
        IConverter result = this.getValueBindingSupport().getModelToUIControlConverter();
        if (result == null) {
            if (value instanceof BigDecimal) {
                result = NumberToStringConverter.fromBigDecimal();
            } else if (value instanceof BigInteger) {
                result = NumberToStringConverter.fromBigInteger();
            } else if (value instanceof Byte) {
                result = NumberToStringConverter.fromByte((boolean)false);
            } else if (value instanceof Double) {
                result = NumberToStringConverter.fromDouble((boolean)false);
            } else if (value instanceof Float) {
                result = NumberToStringConverter.fromFloat((boolean)false);
            } else if (value instanceof Integer) {
                result = NumberToStringConverter.fromInteger((boolean)false);
            } else if (value instanceof Long) {
                result = NumberToStringConverter.fromLong((boolean)false);
            } else if (value instanceof Short) {
                result = NumberToStringConverter.fromShort((boolean)false);
            }
        }
        return result;
    }

    private String localStringToBigDecimal(String number) {
        return DecimalTextRidget.ungroup(number).replace(DECIMAL_SEPARATOR, '.');
    }
}

