/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import org.eclipse.riena.core.injector.Inject;
import org.eclipse.riena.internal.ui.ridgets.swt.Activator;
import org.eclipse.riena.internal.ui.ridgets.swt.uiprocess.DefaultProcessDetailComparator;
import org.eclipse.riena.internal.ui.ridgets.swt.uiprocess.IProcessDetailComparatorContrib;
import org.eclipse.riena.internal.ui.ridgets.swt.uiprocess.ProcessDetail;
import org.eclipse.riena.internal.ui.ridgets.swt.uiprocess.TimerUtil;
import org.eclipse.riena.ui.core.uiprocess.IProgressVisualizer;
import org.eclipse.riena.ui.ridgets.AbstractRidget;
import org.eclipse.riena.ui.ridgets.IContextUpdateListener;
import org.eclipse.riena.ui.ridgets.IStatuslineUIProcessRidget;
import org.eclipse.riena.ui.ridgets.IVisualContextManager;
import org.eclipse.riena.ui.ridgets.swt.AbstractSWTRidget;
import org.eclipse.riena.ui.swt.StatuslineUIProcess;
import org.eclipse.riena.ui.swt.uiprocess.ProcessState;
import org.eclipse.riena.ui.swt.uiprocess.ProgressInfoDataObject;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatuslineUIProcessRidget
extends AbstractRidget
implements IStatuslineUIProcessRidget {
    private static final String EXTENSION_ID_PROCESSDETAIL_COMPARATOR = "org.eclipse.riena.ui.ridgets.swt.processdetail";
    private static final DefaultProcessDetailComparator DEFAULT_PROCESS_DETAIL_COMPARATOR = new DefaultProcessDetailComparator();
    private StatuslineUIProcess uiControl;
    private ProcessDetailManager processManager = new ProcessDetailManager();
    private TimerTask timedTrigger;
    private IVisualContextManager contextLocator;
    private Comparator<ProcessDetail> processDetailComparator;
    private Map<IProgressVisualizer, IContextUpdateListener> visualizer2ContextListener = new HashMap<IProgressVisualizer, IContextUpdateListener>();

    public StatuslineUIProcessRidget() {
        this.inject();
        this.buildTrigger();
    }

    private void inject() {
        BundleContext context = Activator.getDefault().getContext();
        Inject.extension((String)EXTENSION_ID_PROCESSDETAIL_COMPARATOR).expectingMinMax(0, 1).into((Object)this).andStart(context);
    }

    public void update(IProcessDetailComparatorContrib contribution) {
        if (contribution != null) {
            this.processDetailComparator = contribution.createComporatorInstance();
        }
    }

    protected Comparator<ProcessDetail> getProcessDetailComparator() {
        return this.processDetailComparator != null ? this.processDetailComparator : DEFAULT_PROCESS_DETAIL_COMPARATOR;
    }

    private void buildTrigger() {
        this.timedTrigger = new TimedTrigger();
    }

    protected ProcessDetailManager getProcessManager() {
        return this.processManager;
    }

    public StatuslineUIProcess getUIControl() {
        return this.uiControl;
    }

    public void setUIControl(Object uiControl) {
        this.checkUIControl(uiControl);
        this.unbindUIControl();
        this.uiControl = (StatuslineUIProcess)StatuslineUIProcess.class.cast(uiControl);
        this.bindUIControl();
    }

    protected void checkUIControl(Object uiControl) {
        AbstractSWTRidget.assertType(uiControl, StatuslineUIProcess.class);
    }

    protected void bindUIControl() {
    }

    protected void unbindUIControl() {
    }

    public String getToolTipText() {
        return "";
    }

    public boolean hasFocus() {
        return false;
    }

    public boolean isFocusable() {
        return false;
    }

    public boolean isVisible() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    public void requestFocus() {
    }

    public void setFocusable(boolean focusable) {
    }

    public void setToolTipText(String toolTipText) {
    }

    public void setVisible(boolean visible) {
    }

    public void setEnabled(boolean enabled) {
    }

    public String getID() {
        return null;
    }

    public boolean isBlocked() {
        return false;
    }

    public void setBlocked(boolean blocked) {
    }

    public synchronized void updateProgress(IProgressVisualizer visualizer, int progress) {
        this.checkTrigger();
        this.getProcessManager().saveProgress(visualizer, progress);
        this.updateUserInterface();
    }

    private void checkTrigger() {
        if (this.getProcessManager().getPending().size() == 1) {
            TimerUtil.stop(this.timedTrigger);
            this.buildTrigger();
        }
    }

    private void updateUserInterface() {
        if (Display.getDefault().getThread().equals(Thread.currentThread())) {
            this.updateBaseAndList();
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                StatuslineUIProcessRidget.this.updateBaseAndList();
            }
        });
    }

    private void updateBaseAndList() {
        this.triggerUIBaseUpdate();
        this.triggerUIListUpdate();
    }

    private void triggerUIBaseUpdate() {
        ProcessDetail pDetailBase = this.getProcessManager().getStatuslineRelevant();
        if (pDetailBase == null) {
            return;
        }
        this.getUIControl().triggerBaseUpdate(pDetailBase.toPido());
    }

    private void triggerUIListUpdate() {
        List<ProgressInfoDataObject> pidos = this.getProcessManager().getPidos(new IProcessDetailFilter(){

            public boolean accept(ProcessDetail procDetail) {
                return true;
            }
        });
        this.getUIControl().triggerListUpdate(pidos);
    }

    public synchronized void finalUpdateUI(IProgressVisualizer visualizer) {
        this.checkTrigger();
        this.getProcessManager().detailForVisualizer(visualizer).setState(visualizer.getProcessInfo().isCanceled() ? ProcessState.CANCELED : ProcessState.FINISHED);
        this.checkStillNeeded(visualizer);
        this.updateUserInterface();
    }

    private boolean checkStillNeeded(IProgressVisualizer visualizer) {
        ArrayList<Object> contexts = new ArrayList<Object>(1);
        contexts.add(visualizer.getProcessInfo().getContext());
        ProcessDetail detail = this.getProcessManager().detailForVisualizer(visualizer);
        if (detail != null && (detail.getState().equals((Object)ProcessState.FINISHED) || detail.getState().equals((Object)ProcessState.CANCELED)) && this.contextLocator.getActiveContexts(contexts).size() == 1) {
            this.getProcessManager().unregister(this.getProcessManager().detailForVisualizer(visualizer));
            this.unregisterContextUpdateListener(visualizer, false);
            return false;
        }
        return true;
    }

    private void unregisterContextUpdateListener(IProgressVisualizer visualizer, boolean removeFromContextLocator) {
        IContextUpdateListener contextListener = this.visualizer2ContextListener.get(visualizer);
        if (removeFromContextLocator) {
            this.contextLocator.removeContextUpdateListener(contextListener, visualizer.getProcessInfo().getContext());
        }
        this.visualizer2ContextListener.remove(visualizer);
    }

    public void setActiveProgressVisualizer(IProgressVisualizer visualizer) {
    }

    public void setContextLocator(IVisualContextManager contextLocator) {
        this.contextLocator = contextLocator;
    }

    public void addProgressVisualizer(IProgressVisualizer visualizer) {
    }

    public List<IProgressVisualizer> getProgressVisualizers() {
        return this.getProcessManager().getAlVisualizers();
    }

    public synchronized void initialUpdateUI(IProgressVisualizer visualizer, int totalWork) {
        this.createAndRegisterProcessDetail(visualizer);
        if (this.getProcessManager().getPending().size() == 1) {
            TimerUtil.schedule(this.timedTrigger, 0, 200);
        }
    }

    private void createAndRegisterProcessDetail(IProgressVisualizer visualizer) {
        this.getProcessManager().register(new ProcessDetail(StatuslineUIProcessRidget.timeStamp(), visualizer));
        this.observeContext(visualizer);
    }

    private void observeContext(final IProgressVisualizer visualizer) {
        IContextUpdateListener listener = new IContextUpdateListener(){

            public void beforeContextUpdate(Object context) {
            }

            public boolean contextUpdated(Object context) {
                boolean needed = StatuslineUIProcessRidget.this.checkStillNeeded(visualizer);
                StatuslineUIProcessRidget.this.updateUserInterface();
                return !needed;
            }
        };
        Object context = visualizer.getProcessInfo().getContext();
        this.contextLocator.addContextUpdateListener(listener, context);
        this.saveMapping(visualizer, listener);
    }

    private void saveMapping(IProgressVisualizer visualizer, IContextUpdateListener listener) {
        this.visualizer2ContextListener.put(visualizer, listener);
    }

    public void triggerTimedUpdate() {
        if (this.getProcessManager().getPending().size() > 0) {
            this.getProcessManager().updatePending();
            this.updateUserInterface();
        }
    }

    private static long timeStamp() {
        return System.currentTimeMillis();
    }

    public void removeProgressVisualizer(IProgressVisualizer visualizer) {
    }

    static interface IProcessDetailFilter {
        public boolean accept(ProcessDetail var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ProcessDetailManager {
        private List<ProcessDetail> processDetails = Collections.synchronizedList(new ArrayList());

        ProcessDetailManager() {
        }

        void register(ProcessDetail detail) {
            this.processDetails.add(detail);
            this.sort();
        }

        void unregister(ProcessDetail detail) {
            this.processDetails.remove(detail);
            this.sort();
        }

        private void sort() {
            Collections.sort(this.processDetails, StatuslineUIProcessRidget.this.getProcessDetailComparator());
        }

        List<ProcessDetail> getProcessDetails() {
            return Collections.unmodifiableList(this.processDetails);
        }

        List<ProgressInfoDataObject> getPidos(IProcessDetailFilter pidoFilter) {
            ArrayList<ProgressInfoDataObject> pidos = new ArrayList<ProgressInfoDataObject>();
            for (ProcessDetail procDetail : this.processDetails) {
                if (!pidoFilter.accept(procDetail)) continue;
                pidos.add(procDetail.toPido());
            }
            return pidos;
        }

        ProcessDetail getStatuslineRelevant() {
            if (this.processDetails.size() > 0) {
                return this.getProcessDetails().get(0);
            }
            return null;
        }

        boolean isRelevantForStatusline(IProgressVisualizer visualizer) {
            return visualizer != null && visualizer.equals(this.getStatuslineRelevant().getVisualizer());
        }

        List<IProgressVisualizer> getAlVisualizers() {
            ArrayList<IProgressVisualizer> visualizers = new ArrayList<IProgressVisualizer>(this.processDetails.size());
            for (ProcessDetail pDetail : this.processDetails) {
                visualizers.add(pDetail.getVisualizer());
            }
            return visualizers;
        }

        ProcessDetail detailForVisualizer(IProgressVisualizer visualizer) {
            if (visualizer == null) {
                return null;
            }
            for (ProcessDetail pDetail : this.processDetails) {
                if (!visualizer.equals(pDetail.getVisualizer())) continue;
                return pDetail;
            }
            return null;
        }

        List<ProcessDetail> getPending() {
            ArrayList<ProcessDetail> pending = new ArrayList<ProcessDetail>();
            for (ProcessDetail pDetail : this.processDetails) {
                if (!pDetail.isPending()) continue;
                pending.add(pDetail);
            }
            return pending;
        }

        void updatePending() {
            for (ProcessDetail pendingDetail : this.getPending()) {
                pendingDetail.triggerPending();
            }
        }

        public void saveProgress(IProgressVisualizer visualizer, int progress) {
            ProcessDetail pDetail = this.detailForVisualizer(visualizer);
            assert (pDetail != null) : "no ProcessDetail for visualizer " + visualizer;
            if (pDetail.isPending()) {
                pDetail.setState(ProcessState.RUNNING);
            }
            pDetail.setProgress(progress);
        }
    }

    class TimedTrigger
    extends TimerTask {
        TimedTrigger() {
        }

        public void run() {
            StatuslineUIProcessRidget.this.triggerTimedUpdate();
        }
    }
}

