/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateListStrategy;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.databinding.viewers.IViewerObservableList;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.AbstractListViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.riena.core.util.ListenerList;
import org.eclipse.riena.internal.ui.ridgets.swt.MarkerSupport;
import org.eclipse.riena.internal.ui.ridgets.swt.OutputAwareValidator;
import org.eclipse.riena.ui.common.ISortableByColumn;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IColumnFormatter;
import org.eclipse.riena.ui.ridgets.IMarkableRidget;
import org.eclipse.riena.ui.ridgets.ITableRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractSWTWidgetRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractSelectableIndexedRidget;
import org.eclipse.riena.ui.ridgets.swt.SortableComparator;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractListRidget
extends AbstractSelectableIndexedRidget
implements ITableRidget {
    protected SelectionListener selectionTypeEnforcer;
    protected final MouseListener doubleClickForwarder = new DoubleClickForwarder();
    private ListenerList<IActionListener> doubleClickListeners;
    private DataBindingContext dbc;
    private Binding viewerSSB;
    private Binding viewerMSB;
    private Class<?> rowBeanClass;
    private IObservableList modelObservables;
    private IObservableList viewerObservables;
    private String renderingMethod;
    private boolean isSortedAscending = true;
    private int sortedColumn = -1;
    private ViewerComparator comparator;

    public AbstractListRidget() {
        this.getSingleSelectionObservable().addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                AbstractListRidget.this.disableMandatoryMarkers(AbstractListRidget.this.hasInput());
            }
        });
        this.getMultiSelectionObservable().addListChangeListener(new IListChangeListener(){

            public void handleListChange(ListChangeEvent event) {
                AbstractListRidget.this.disableMandatoryMarkers(AbstractListRidget.this.hasInput());
            }
        });
        this.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                boolean isEnabled = (Boolean)evt.getNewValue();
                AbstractListRidget.this.updateEnabled(isEnabled);
            }
        });
        this.addPropertyChangeListener("output", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (AbstractListRidget.this.isOutputOnly()) {
                    AbstractListRidget.this.disposeMultipleSelectionBinding();
                } else {
                    AbstractListRidget.this.createMultipleSelectionBinding();
                }
            }
        });
    }

    protected abstract void updateEnabled(boolean var1);

    @Override
    protected void unbindUIControl() {
        super.unbindUIControl();
        if (this.dbc != null) {
            this.disposeSelectionBindings();
            this.dbc.dispose();
            this.dbc = null;
        }
    }

    @Override
    protected List<?> getRowObservables() {
        return this.viewerObservables;
    }

    public void addDoubleClickListener(IActionListener listener) {
        Assert.isNotNull((Object)listener, (String)"listener is null");
        if (this.doubleClickListeners == null) {
            this.doubleClickListeners = new ListenerList(IActionListener.class);
        }
        this.doubleClickListeners.add((Object)listener);
    }

    public void bindToModel(IObservableList rowValues, Class<? extends Object> rowClass, String[] columnPropertyNames, String[] columnHeaders) {
        this.unbindUIControl();
        this.rowBeanClass = rowClass;
        this.modelObservables = rowValues;
        this.viewerObservables = null;
        this.renderingMethod = columnPropertyNames[0];
        this.bindUIControl();
    }

    public void bindToModel(Object listHolder, String listPropertyName, Class<? extends Object> rowClass, String[] columnPropertyNames, String[] columnHeaders) {
        IObservableList rowValues = AbstractSWTWidgetRidget.isBean(rowClass) ? BeansObservables.observeList((Object)listHolder, (String)listPropertyName) : PojoObservables.observeList((Object)listHolder, (String)listPropertyName);
        this.bindToModel(rowValues, rowClass, columnPropertyNames, columnHeaders);
    }

    public void updateFromModel() {
        super.updateFromModel();
        if (this.modelObservables != null) {
            ArrayList copy = new ArrayList(this.modelObservables);
            this.viewerObservables = new WritableList(copy, this.rowBeanClass);
        }
        if (this.hasViewer() && this.viewerObservables != null) {
            AbstractListViewer viewer = this.getViewer();
            viewer.getControl().setRedraw(false);
            StructuredSelection currentSelection = new StructuredSelection(this.getSelection());
            try {
                this.configureViewer(viewer);
            }
            finally {
                viewer.setSelection((ISelection)currentSelection);
                viewer.getControl().setRedraw(true);
            }
        }
    }

    protected void configureViewer(AbstractListViewer viewer) {
        ObservableListContentProvider viewerCP = new ObservableListContentProvider();
        String[] propertyNames = new String[]{this.renderingMethod};
        IObservableMap[] attributeMap = AbstractSWTWidgetRidget.isBean(this.rowBeanClass) ? BeansObservables.observeMaps((IObservableSet)viewerCP.getKnownElements(), this.rowBeanClass, (String[])propertyNames) : PojoObservables.observeMaps((IObservableSet)viewerCP.getKnownElements(), this.rowBeanClass, (String[])propertyNames);
        viewer.setLabelProvider((IBaseLabelProvider)new ListLabelProvider(attributeMap));
        viewer.setContentProvider((IContentProvider)viewerCP);
        viewer.setInput((Object)this.viewerObservables);
    }

    public IObservableList getObservableList() {
        return this.viewerObservables;
    }

    public void removeDoubleClickListener(IActionListener listener) {
        if (this.doubleClickListeners != null) {
            this.doubleClickListeners.remove((Object)listener);
        }
    }

    public void setComparator(int columnIndex, Comparator<Object> comparator) {
        Assert.isLegal((columnIndex == 0 ? 1 : 0) != 0, (String)"columnIndex out of bounds (must be 0)");
        if (comparator != null) {
            SortableComparator sortableComparator = new SortableComparator((ISortableByColumn)this, comparator);
            this.comparator = new ViewerComparator((Comparator)sortableComparator);
        } else {
            this.comparator = null;
        }
        this.updateComparator();
    }

    public int getSortedColumn() {
        return this.comparator != null && this.sortedColumn == 0 ? 0 : -1;
    }

    public boolean isColumnSortable(int columnIndex) {
        Assert.isLegal((columnIndex == 0 ? 1 : 0) != 0, (String)"columnIndex out of bounds (must be 0)");
        return this.comparator != null;
    }

    @Override
    public boolean isDisableMandatoryMarker() {
        return this.hasInput();
    }

    public boolean isSortedAscending() {
        return this.isSortedAscending;
    }

    public final void setColumnSortable(int columnIndex, boolean sortable) {
        throw new UnsupportedOperationException();
    }

    public void setSortedAscending(boolean ascending) {
        if (ascending != this.isSortedAscending) {
            boolean oldSortedAscending = this.isSortedAscending;
            this.isSortedAscending = ascending;
            if (this.hasViewer()) {
                this.refreshViewer();
            }
            this.firePropertyChange("sortAscending", oldSortedAscending, this.isSortedAscending);
        }
    }

    protected boolean hasViewer() {
        return this.getViewer() != null;
    }

    protected boolean hasViewerModel() {
        return this.viewerObservables != null;
    }

    protected void refreshViewer() {
        this.getViewer().refresh();
    }

    public final void setSortedColumn(int columnIndex) {
        String msg = "columnIndex out of range (-1 - 0): " + columnIndex;
        Assert.isLegal((columnIndex >= -1 && columnIndex <= 0 ? 1 : 0) != 0, (String)msg);
        if (this.sortedColumn != columnIndex) {
            int oldSortedColumn = this.sortedColumn;
            this.sortedColumn = columnIndex;
            this.updateComparator();
            this.firePropertyChange("sortedColumn", oldSortedColumn, this.sortedColumn);
        }
    }

    @Override
    public int getSelectionIndex() {
        return this.getUIControl() == null ? -1 : this.getUIControlSelectionIndex();
    }

    protected abstract int getUIControlSelectionIndex();

    @Override
    public int[] getSelectionIndices() {
        return this.getUIControl() == null ? new int[]{} : this.getUIControlSelectionIndices();
    }

    protected abstract int[] getUIControlSelectionIndices();

    @Override
    public int indexOfOption(Object option) {
        if (this.getUIControl() != null) {
            int optionCount = this.getUIControlItemCount();
            int i = 0;
            while (i < optionCount) {
                if (this.getViewer().getElementAt(i).equals(option)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    protected abstract int getUIControlItemCount();

    public final boolean hasMoveableColumns() {
        return false;
    }

    public final void setMoveableColumns(boolean moveableColumns) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void setColumnFormatter(int columnIndex, IColumnFormatter formatter) {
        throw new UnsupportedOperationException();
    }

    private void createMultipleSelectionBinding() {
        if (this.viewerMSB == null && this.dbc != null && this.hasViewer()) {
            StructuredSelection currentSelection = new StructuredSelection(this.getSelection());
            IViewerObservableList viewerSelections = ViewersObservables.observeMultiSelection((Viewer)this.getViewer());
            this.viewerMSB = this.dbc.bindList((IObservableList)viewerSelections, this.getMultiSelectionObservable(), new UpdateListStrategy(UpdateListStrategy.POLICY_UPDATE), new UpdateListStrategy(UpdateListStrategy.POLICY_UPDATE));
            this.getViewer().setSelection((ISelection)currentSelection);
        }
    }

    protected abstract AbstractListViewer getViewer();

    private void disposeMultipleSelectionBinding() {
        if (this.viewerMSB != null) {
            this.viewerMSB.dispose();
            this.dbc.removeBinding(this.viewerMSB);
            this.viewerMSB = null;
        }
    }

    protected void createSelectionBindings() {
        this.dbc = new DataBindingContext();
        IViewerObservableValue viewerSelection = ViewersObservables.observeSingleSelection((Viewer)this.getViewer());
        this.viewerSSB = this.dbc.bindValue((IObservableValue)viewerSelection, this.getSingleSelectionObservable(), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setAfterGetValidator((IValidator)new OutputAwareValidator((IMarkableRidget)this)), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE));
        this.viewerMSB = null;
        if (!this.isOutputOnly()) {
            this.createMultipleSelectionBinding();
        }
    }

    protected void disposeSelectionBindings() {
        if (this.viewerSSB != null && !this.viewerSSB.isDisposed()) {
            this.viewerSSB.dispose();
        }
        this.disposeMultipleSelectionBinding();
    }

    private boolean hasInput() {
        return !this.getSelection().isEmpty();
    }

    protected void updateComparator() {
        if (this.hasViewer()) {
            if (this.sortedColumn == 0) {
                this.getViewer().setComparator(this.comparator);
            } else {
                this.getViewer().setComparator(null);
            }
        }
    }

    private final class DoubleClickForwarder
    extends MouseAdapter {
        private DoubleClickForwarder() {
        }

        public void mouseDoubleClick(MouseEvent e) {
            if (AbstractListRidget.this.doubleClickListeners != null) {
                IActionListener[] iActionListenerArray = (IActionListener[])AbstractListRidget.this.doubleClickListeners.getListeners();
                int n = iActionListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IActionListener listener = iActionListenerArray[n2];
                    listener.callback();
                    ++n2;
                }
            }
        }
    }

    private final class ListLabelProvider
    extends ObservableMapLabelProvider {
        public ListLabelProvider(IObservableMap[] attributeMap) {
            super(attributeMap);
        }

        public String getColumnText(Object element, int columnIndex) {
            if (MarkerSupport.HIDE_DISABLED_RIDGET_CONTENT && !AbstractListRidget.this.isEnabled()) {
                return "";
            }
            return super.getColumnText(element, columnIndex);
        }
    }
}

