/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.core.marker.IMarkerAttributeChangeListener;
import org.eclipse.riena.core.marker.Markable;
import org.eclipse.riena.ui.core.marker.DisabledMarker;
import org.eclipse.riena.ui.core.marker.HiddenMarker;
import org.eclipse.riena.ui.core.marker.IMarkerPropertyChangeEvent;
import org.eclipse.riena.ui.core.marker.OutputMarker;
import org.eclipse.riena.ui.ridgets.IBasicMarkableRidget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMarkerSupport {
    private Set<IMarker> markers;
    private IBasicMarkableRidget ridget;
    private PropertyChangeSupport propertyChangeSupport;
    private IMarkerAttributeChangeListener markerAttributeChangeListener;

    public AbstractMarkerSupport(IBasicMarkableRidget ridget, PropertyChangeSupport propertyChangeSupport) {
        this.ridget = ridget;
        this.propertyChangeSupport = propertyChangeSupport;
        this.markerAttributeChangeListener = new MarkerAttributeChangeListener();
    }

    public abstract void updateMarkers();

    public void addMarker(IMarker marker) {
        if (marker == null) {
            return;
        }
        Collection<IMarker> oldValue = this.getMarkers();
        if (this.markers == null) {
            this.markers = new HashSet<IMarker>(1, 1.0f);
        }
        if (this.markers.add(marker)) {
            this.updateMarkers();
            this.fireMarkerPropertyChangeEvent(oldValue);
            this.fireOutputPropertyChangeEvent(oldValue);
            this.fireEnabledPropertyChangeEvent(oldValue);
            marker.addAttributeChangeListener(this.markerAttributeChangeListener);
        }
    }

    public Collection<IMarker> getMarkers() {
        if (this.markers != null) {
            return new HashSet<IMarker>(this.markers);
        }
        return Collections.emptySet();
    }

    public <T extends IMarker> Collection<T> getMarkersOfType(Class<T> type) {
        return Markable.getMarkersOfType(this.getMarkers(), type);
    }

    public void removeAllMarkers() {
        if (this.markers != null && !this.getMarkers().isEmpty()) {
            Collection<IMarker> oldValue = this.getMarkers();
            for (IMarker marker : this.markers) {
                marker.removeAttributeChangeListener(this.markerAttributeChangeListener);
            }
            this.markers.clear();
            if (oldValue.size() > 0) {
                this.updateMarkers();
                this.fireMarkerPropertyChangeEvent(oldValue);
                this.fireOutputPropertyChangeEvent(oldValue);
                this.fireEnabledPropertyChangeEvent(oldValue);
            }
        }
    }

    public void removeMarker(IMarker marker) {
        if (this.markers != null && !this.getMarkers().isEmpty()) {
            Collection<IMarker> oldValue = this.getMarkers();
            if (this.markers.remove(marker)) {
                this.updateMarkers();
                this.fireMarkerPropertyChangeEvent(oldValue);
                this.fireOutputPropertyChangeEvent(oldValue);
                this.fireEnabledPropertyChangeEvent(oldValue);
                marker.removeAttributeChangeListener(this.markerAttributeChangeListener);
            }
        }
    }

    protected Object getUIControl() {
        return this.getRidget().getUIControl();
    }

    protected IBasicMarkableRidget getRidget() {
        return this.ridget;
    }

    protected void handleMarkerAttributesChanged() {
        this.propertyChangeSupport.firePropertyChange(new MarkerPropertyChangeEvent(true, this.getRidget(), (Object)this.getMarkers()));
    }

    private Boolean isEnabled(Collection<IMarker> markers) {
        boolean result = true;
        if (markers != null) {
            Iterator<IMarker> iter = markers.iterator();
            while (result && iter.hasNext()) {
                boolean bl = result = !(iter.next() instanceof DisabledMarker);
            }
        }
        return result;
    }

    private Boolean isOutput(Collection<IMarker> markers) {
        boolean result = false;
        if (markers != null) {
            Iterator<IMarker> iter = markers.iterator();
            while (!result && iter.hasNext()) {
                result = iter.next() instanceof OutputMarker;
            }
        }
        return result;
    }

    private void fireEnabledPropertyChangeEvent(Collection<IMarker> oldMarkers) {
        Boolean newValue;
        Boolean oldValue = this.isEnabled(oldMarkers);
        if (!oldValue.equals(newValue = this.isEnabled(this.getMarkers()))) {
            PropertyChangeEvent evt = new PropertyChangeEvent(this.getRidget(), "enabled", oldValue, newValue);
            this.propertyChangeSupport.firePropertyChange(evt);
        }
    }

    private void fireMarkerPropertyChangeEvent(Collection<IMarker> oldValue) {
        this.propertyChangeSupport.firePropertyChange(new MarkerPropertyChangeEvent(oldValue, this.getRidget(), this.getMarkers()));
    }

    private void fireOutputPropertyChangeEvent(Collection<IMarker> oldMarkers) {
        Boolean newValue;
        Boolean oldValue = this.isOutput(oldMarkers);
        if (!oldValue.equals(newValue = this.isOutput(this.getMarkers()))) {
            PropertyChangeEvent evt = new PropertyChangeEvent(this.getRidget(), "output", oldValue, newValue);
            this.propertyChangeSupport.firePropertyChange(evt);
        }
    }

    public void fireShowingPropertyChangeEvent() {
        this.propertyChangeSupport.firePropertyChange("showing", !this.ridget.isVisible(), this.ridget.isVisible());
        this.updateMarkers();
    }

    protected boolean hasHiddenMarkers() {
        return !this.getRidget().getMarkersOfType(HiddenMarker.class).isEmpty();
    }

    private final class MarkerAttributeChangeListener
    implements IMarkerAttributeChangeListener {
        private MarkerAttributeChangeListener() {
        }

        public void attributesChanged() {
            AbstractMarkerSupport.this.handleMarkerAttributesChanged();
        }
    }

    private static final class MarkerPropertyChangeEvent
    extends PropertyChangeEvent
    implements IMarkerPropertyChangeEvent {
        private static final long serialVersionUID = 1L;
        private boolean attributeRelated = false;

        private MarkerPropertyChangeEvent(Object oldValue, IBasicMarkableRidget source, Object newValue) {
            super(source, "marker", oldValue, newValue);
        }

        private MarkerPropertyChangeEvent(boolean attributeRelated, IBasicMarkableRidget source, Object newValue) {
            this(null, source, newValue);
            this.attributeRelated = attributeRelated;
        }

        public boolean isAttributeRelated() {
            return this.attributeRelated;
        }
    }
}

