/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.demo.client.controllers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import org.eclipse.riena.beans.common.TypedComparator;
import org.eclipse.riena.core.wire.InjectService;
import org.eclipse.riena.demo.client.controllers.EmailsResult;
import org.eclipse.riena.demo.common.Customer;
import org.eclipse.riena.demo.common.Email;
import org.eclipse.riena.demo.common.ICustomerService;
import org.eclipse.riena.demo.common.IEmailService;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationArgument;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.ILabelRidget;
import org.eclipse.riena.ui.ridgets.ITableRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;

public class AbstractEmailController
extends SubModuleController {
    protected IEmailService mailDemoService;
    protected Email selectedEmail;
    private ICustomerService customerDemoService;
    protected EmailsResult emailsResult = new EmailsResult();

    @InjectService(useRanking=true)
    public void bind(IEmailService mailDemoService) {
        this.mailDemoService = mailDemoService;
    }

    public void unbind(IEmailService mailDemoService) {
        this.mailDemoService = null;
    }

    @InjectService(useRanking=true)
    public void bind(ICustomerService customerDemoService) {
        this.customerDemoService = customerDemoService;
    }

    public void unbind(ICustomerService customerDemoService) {
        this.customerDemoService = null;
    }

    public void configureRidgets() {
        final ITableRidget emails = (ITableRidget)this.getRidget("emailsTable");
        final ILabelRidget emailSubject = (ILabelRidget)this.getRidget("emailSubject");
        final ILabelRidget emailFrom = (ILabelRidget)this.getRidget("emailFrom");
        final ILabelRidget emailTo = (ILabelRidget)this.getRidget("emailTo");
        final ILabelRidget emailDate = (ILabelRidget)this.getRidget("emailDate");
        final ITextRidget emailBody = (ITextRidget)this.getRidget("emailBody");
        emails.setComparator(3, (Comparator)new TypedComparator());
        emails.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == "selection") {
                    AbstractEmailController.this.selectedEmail = (Email)emails.getSelection().get(0);
                    emailSubject.setText(AbstractEmailController.this.selectedEmail.getEmailSubject());
                    emailFrom.setText(AbstractEmailController.this.selectedEmail.getEmailFrom());
                    emailBody.setText(AbstractEmailController.this.selectedEmail.getEmailBody());
                    emailTo.setText(AbstractEmailController.this.selectedEmail.getEmailTo());
                    SimpleDateFormat formatter = new SimpleDateFormat("E dd.MM.yyyy HH:mm");
                    emailDate.setText(formatter.format(AbstractEmailController.this.selectedEmail.getEmailDate()));
                }
            }
        });
        ((IActionRidget)this.getRidget("openCustomer")).addListener(new IActionListener(){

            public void callback() {
                String selectedEmailAddress;
                if (AbstractEmailController.this.selectedEmail != null && (selectedEmailAddress = AbstractEmailController.this.openCustomerWithEmailAddress()) != null) {
                    Customer customer = AbstractEmailController.this.customerDemoService.findCustomerWithEmailAddress(selectedEmailAddress);
                    System.out.println("customer " + customer);
                    if (customer != null) {
                        ((ISubModuleNode)AbstractEmailController.this.getNavigationNode()).navigate(new NavigationNodeId("riena.demo.client.CustomerRecord", selectedEmailAddress), new NavigationArgument((Object)customer));
                    }
                }
            }
        });
    }

    protected String openCustomerWithEmailAddress() {
        return this.selectedEmail.getEmailFrom();
    }
}

