/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.controllers;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.core.uiprocess.UIProcess;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;

public class UIProcessDemoSubModuleController
extends SubModuleController {
    private boolean registered;

    public UIProcessDemoSubModuleController() {
        this(null);
    }

    public UIProcessDemoSubModuleController(ISubModuleNode navigationNode) {
        super(navigationNode);
    }

    public IActionRidget getActionRidget() {
        return (IActionRidget)this.getRidget("actionRidget");
    }

    public IActionRidget getActionRidgetJob() {
        return (IActionRidget)this.getRidget("actionRidgetJob");
    }

    public void configureRidgets() {
        if (this.getActionRidget() != null && !this.registered) {
            this.initUIProcessAction();
            this.initJobAction();
            this.registered = true;
        }
    }

    private void initJobAction() {
        this.getActionRidgetJob().setText("start job");
        this.getActionRidgetJob().addListener((IActionListener)new JobProcessAction());
    }

    private void initUIProcessAction() {
        this.getActionRidget().setText("start UIProcess");
        this.getActionRidget().addListener((IActionListener)new UIProcessAction());
    }

    void runUIProcess() {
        UIProcess p = new UIProcess("sample uiProcess", true, this.getNavigationNode()){

            public void initialUpdateUI(int totalWork) {
                super.initialUpdateUI(totalWork);
                UIProcessDemoSubModuleController.this.setBlocked(true);
            }

            public boolean runJob(IProgressMonitor monitor) {
                try {
                    Thread.sleep(2500L);
                }
                catch (InterruptedException e1) {
                    e1.getCause();
                }
                int i = 0;
                while (i <= 10) {
                    if (monitor.isCanceled()) {
                        monitor.done();
                        return false;
                    }
                    try {
                        Thread.sleep(800L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    this.setTitle("sample uiProcess worked [" + i + "]");
                    monitor.worked(i);
                    ++i;
                }
                return true;
            }

            public void finalUpdateUI() {
                super.finalUpdateUI();
                UIProcessDemoSubModuleController.this.setBlocked(false);
            }

            protected int getTotalWork() {
                return 10;
            }
        };
        p.setNote("sample uiProcess note " + ((ISubModuleNode)this.getNavigationNode()).getLabel() + "..");
        p.setTitle("sample uiProcess");
        p.start();
    }

    void runJob() {
        Job job = new Job("eclipse job"){

            public IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask("eclipse job", 10);
                    int i = 0;
                    while (i <= 10) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        monitor.worked(i);
                        if (monitor.isCanceled()) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        ++i;
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        job.setProperty(UIProcess.PROPERTY_CONTEXT, (Object)this.getNavigationNode());
        job.setUser(true);
        job.schedule();
    }

    private class JobProcessAction
    implements IActionListener {
        private JobProcessAction() {
        }

        public void callback() {
            UIProcessDemoSubModuleController.this.runJob();
        }
    }

    private class UIProcessAction
    implements IActionListener {
        private UIProcessAction() {
        }

        public void callback() {
            UIProcessDemoSubModuleController.this.runUIProcess();
        }
    }
}

