/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.views;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.riena.example.client.controllers.MarkerSubModuleController;
import org.eclipse.riena.navigation.ui.swt.views.SubModuleView;
import org.eclipse.riena.ui.common.IComplexComponent;
import org.eclipse.riena.ui.swt.ChoiceComposite;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;
import org.eclipse.riena.ui.swt.utils.UIControlsFactory;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.nebula.widgets.compositetable.AbstractNativeHeader;
import org.eclipse.swt.nebula.widgets.compositetable.CompositeTable;
import org.eclipse.swt.nebula.widgets.compositetable.ResizableGridRowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkerSubModuleView
extends SubModuleView<MarkerSubModuleController> {
    public static final String ID = MarkerSubModuleView.class.getName();

    protected void basicCreatePartControl(Composite parent) {
        parent.setBackground(LnfManager.getLnf().getColor("SubModule.background"));
        parent.setLayout((Layout)new GridLayout(2, false));
        Group group1 = this.createMarkerOptionsGroup(parent);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group1);
        Group group2 = this.createVisibilityOptionsGroup(parent);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group2);
        Group group3 = this.createControlsGroup(parent);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)group3);
    }

    private Group createMarkerOptionsGroup(Composite parent) {
        Group group = UIControlsFactory.createGroup((Composite)parent, (String)"Marker Options:");
        group.setLayout((Layout)this.createGridLayout(4));
        Button checkMandatory = UIControlsFactory.createButtonCheck((Composite)group);
        this.addUIControl(checkMandatory, "checkMandatory");
        Button checkError = UIControlsFactory.createButtonCheck((Composite)group);
        this.addUIControl(checkError, "checkError");
        Button checkDisabled = UIControlsFactory.createButtonCheck((Composite)group);
        this.addUIControl(checkDisabled, "checkDisabled");
        Button checkOutput = UIControlsFactory.createButtonCheck((Composite)group);
        this.addUIControl(checkOutput, "checkOutput");
        return group;
    }

    private Group createVisibilityOptionsGroup(Composite parent) {
        Group group = UIControlsFactory.createGroup((Composite)parent, (String)"Visibility Options:");
        group.setLayout((Layout)this.createGridLayout(2));
        Button checkHidden = UIControlsFactory.createButtonCheck((Composite)group);
        this.addUIControl(checkHidden, "checkHidden");
        Button checkHiddenParent = UIControlsFactory.createButtonCheck((Composite)group);
        this.addUIControl(checkHiddenParent, "checkHiddenParent");
        return group;
    }

    private Group createControlsGroup(Composite parent) {
        Group group = UIControlsFactory.createGroup((Composite)parent, (String)"UI-Controls:");
        int defaultVSpacing = new GridLayout().verticalSpacing;
        GridLayoutFactory.swtDefaults().numColumns(2).equalWidth(false).margins(20, 20).spacing(10, defaultVSpacing).applyTo((Composite)group);
        GridDataFactory hFillFactory = GridDataFactory.fillDefaults().grab(true, false);
        UIControlsFactory.createLabel((Composite)group, (String)"Name:", (String)"labeltextName");
        Text textName = UIControlsFactory.createText((Composite)group);
        hFillFactory.applyTo((Control)textName);
        this.addUIControl(textName, "textName");
        UIControlsFactory.createLabel((Composite)group, (String)"Price:", (String)"labeltextPrice");
        Text textPrice = UIControlsFactory.createTextDecimal((Composite)group);
        hFillFactory.applyTo((Control)textPrice);
        this.addUIControl(textPrice, "textPrice");
        UIControlsFactory.createLabel((Composite)group, (String)"Amount:", (String)"labeltextAmount");
        Text textAmount = UIControlsFactory.createTextNumeric((Composite)group);
        hFillFactory.applyTo((Control)textAmount);
        this.addUIControl(textAmount, "textAmount");
        UIControlsFactory.createLabel((Composite)group, (String)"Production Date:", (String)"labeltextDate");
        Composite cmpDate = this.createComposite(group, 3, true);
        Text textDate = UIControlsFactory.createTextDate((Composite)cmpDate);
        hFillFactory.applyTo((Control)textDate);
        this.addUIControl(textDate, "textDate");
        DateTime dtDate = new DateTime(cmpDate, 65572);
        hFillFactory.applyTo((Control)dtDate);
        this.addUIControl(dtDate, "dtDate");
        UIControlsFactory.createLabel((Composite)group, (String)"Age:", (String)"labelcomboAge");
        Combo comboAge = UIControlsFactory.createCombo((Composite)group);
        hFillFactory.applyTo((Control)comboAge);
        this.addUIControl(comboAge, "comboAge");
        UIControlsFactory.createLabel((Composite)group, (String)"Type:", (String)"labelchoiceType");
        ChoiceComposite choiceType = new ChoiceComposite((Composite)group, 2048, false);
        choiceType.setOrientation(256);
        this.addUIControl(choiceType, "choiceType");
        UIControlsFactory.createLabel((Composite)group, (String)"Flavor:", (String)"labelchoiceFlavor");
        ChoiceComposite choiceFlavor = new ChoiceComposite((Composite)group, 2048, true);
        choiceFlavor.setOrientation(256);
        this.addUIControl(choiceFlavor, "choiceFlavor");
        Label lblReviewed = UIControlsFactory.createLabel((Composite)group, (String)"Reviewed by:", (String)"labellistPersons");
        GridDataFactory.fillDefaults().align(1, 1).applyTo((Control)lblReviewed);
        Composite cmpReviewed = this.createComposite(group, 3, true);
        org.eclipse.swt.widgets.List listPersons = UIControlsFactory.createList((Composite)cmpReviewed, (boolean)false, (boolean)true);
        int hHint = UIControlsFactory.getHeightHint((org.eclipse.swt.widgets.List)listPersons, (int)5);
        hFillFactory.hint(150, hHint).applyTo((Control)listPersons);
        this.addUIControl(listPersons, "listPersons");
        Table tablePersons = UIControlsFactory.createTable((Composite)cmpReviewed, (int)68096);
        tablePersons.setLinesVisible(true);
        tablePersons.setHeaderVisible(true);
        TableColumn tac1 = new TableColumn(tablePersons, 0);
        tac1.setWidth(100);
        TableColumn tac2 = new TableColumn(tablePersons, 0);
        tac2.setWidth(70);
        hFillFactory.hint(170, hHint).applyTo((Control)tablePersons);
        this.addUIControl(tablePersons, "tablePersons");
        CompositeTable compTable = UIControlsFactory.createCompositeTable((Composite)cmpReviewed, (int)2048);
        new Header((Composite)compTable, 0);
        new Row((Composite)compTable, 0);
        compTable.setRunTime(true);
        this.addUIControl(compTable, "compTable");
        hFillFactory.hint(200, hHint).applyTo((Control)compTable);
        UIControlsFactory.createLabel((Composite)group, (String)"");
        Composite cmpReviewed2 = this.createComposite(group, 3, true);
        Tree treePersons = UIControlsFactory.createTree((Composite)cmpReviewed2, (int)68096);
        hFillFactory.hint(150, hHint).applyTo((Control)treePersons);
        this.addUIControl(treePersons, "treePersons");
        Tree treeWCols = UIControlsFactory.createTree((Composite)cmpReviewed2, (int)68098);
        treeWCols.setLinesVisible(true);
        treeWCols.setHeaderVisible(true);
        TreeColumn trc1 = new TreeColumn(treeWCols, 0);
        trc1.setWidth(120);
        TreeColumn trc2 = new TreeColumn(treeWCols, 0);
        trc2.setWidth(40);
        hFillFactory.hint(200, hHint).applyTo((Control)treeWCols);
        this.addUIControl(treeWCols, "treeWCols");
        UIControlsFactory.createLabel((Composite)cmpReviewed2, (String)"");
        UIControlsFactory.createLabel((Composite)group, (String)"Buttons:", (String)"labelbuttonToggle");
        Composite cmpButtons = this.createComposite(group, 5, false);
        Button buttonToggle = UIControlsFactory.createButtonToggle((Composite)cmpButtons);
        this.addUIControl(buttonToggle, "buttonToggle");
        Button buttonPush = UIControlsFactory.createButton((Composite)cmpButtons);
        buttonPush.setText("Push");
        this.addUIControl(buttonPush, "buttonPush");
        Button buttonRadioA = UIControlsFactory.createButtonRadio((Composite)cmpButtons);
        buttonRadioA.setText("Radio A");
        this.addUIControl(buttonRadioA, "buttonRadioA");
        Button buttonRadioB = UIControlsFactory.createButtonRadio((Composite)cmpButtons);
        buttonRadioB.setText("Radio B");
        this.addUIControl(buttonRadioB, "buttonRadioB");
        Button buttonCheck = UIControlsFactory.createButtonCheck((Composite)cmpButtons);
        buttonCheck.setText("Check");
        this.addUIControl(buttonCheck, "buttonCheck");
        return group;
    }

    private Composite createComposite(Group group, int numColumns, boolean equalWidth) {
        Composite composite = new Composite((Composite)group, 0);
        composite.setBackground(LnfManager.getLnf().getColor("SubModule.background"));
        GridLayoutFactory.fillDefaults().numColumns(numColumns).equalWidth(equalWidth).spacing(10, 0).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        return composite;
    }

    private GridLayout createGridLayout(int numColumns) {
        GridLayout layout = new GridLayout(numColumns, false);
        layout.marginWidth = 20;
        layout.marginHeight = 20;
        return layout;
    }

    private static final class Header
    extends AbstractNativeHeader {
        public Header(Composite parent, int style) {
            super(parent, style);
            this.setWeights(new int[]{100, 100});
            this.setColumnText(new String[]{"Last Name", "First Name"});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Row
    extends Composite
    implements IComplexComponent {
        private final Text txtLast;
        private final Text txtFirst;

        public Row(Composite parent, int style) {
            super(parent, style);
            this.setLayout((Layout)new ResizableGridRowLayout());
            this.txtLast = new Text((Composite)this, 2048);
            SWTBindingPropertyLocator.getInstance().setBindingProperty((Object)this.txtLast, "txtLast");
            this.txtFirst = new Text((Composite)this, 2048);
            SWTBindingPropertyLocator.getInstance().setBindingProperty((Object)this.txtFirst, "txtFirst");
        }

        public List<Object> getUIControls() {
            return Arrays.asList(this.txtLast, this.txtFirst);
        }
    }
}

