/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.monitor.client;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.log.ExtendedLogEntry;
import org.eclipse.equinox.log.ExtendedLogReaderService;
import org.eclipse.riena.core.util.PropertiesUtils;
import org.eclipse.riena.core.wire.WireWith;
import org.eclipse.riena.monitor.client.AbstractCollector;
import org.eclipse.riena.monitor.client.LogServiceCollectorWiring;
import org.eclipse.riena.monitor.client.Range;
import org.eclipse.riena.monitor.common.LogEntryTransferObject;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;

@WireWith(value=LogServiceCollectorWiring.class)
public class LogServiceCollector
extends AbstractCollector
implements IExecutableExtension {
    private Range collectRange;
    private Range triggerRange;
    private ExtendedLogReaderService extendedLogReaderService;
    private final LogListener logListener = this.newLogListener();
    private static final String TRIGGER_RANGE = "triggerRange";
    private static final String COLLECT_RANGE = "collectRange";

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        Map properties = null;
        try {
            properties = PropertiesUtils.asMap((Object)data, (String[])new String[]{COLLECT_RANGE, TRIGGER_RANGE});
            this.collectRange = new Range((String)properties.get(COLLECT_RANGE));
            this.triggerRange = new Range((String)properties.get(TRIGGER_RANGE));
        }
        catch (IllegalArgumentException e) {
            throw this.configurationException("Bad configuration.", e);
        }
    }

    protected void doStart() {
        if (this.extendedLogReaderService == null) {
            return;
        }
        this.extendedLogReaderService.addLogListener(this.logListener);
    }

    protected void doStop() {
        if (this.extendedLogReaderService == null) {
            return;
        }
        this.extendedLogReaderService.removeLogListener(this.logListener);
    }

    public void bind(ExtendedLogReaderService extendedLogReaderService) {
        this.extendedLogReaderService = extendedLogReaderService;
    }

    public void unbind(ExtendedLogReaderService extendedLogReaderService) {
        extendedLogReaderService.removeLogListener(this.logListener);
        this.extendedLogReaderService = null;
    }

    private LogListener newLogListener() {
        return new LogListener(){

            public void logged(LogEntry entry) {
                if (!LogServiceCollector.this.collectRange.matches(entry.getLevel())) {
                    return;
                }
                LogServiceCollector.this.collect(new LogEntryTransferObject((ExtendedLogEntry)entry));
                if (LogServiceCollector.this.triggerRange.matches(entry.getLevel())) {
                    LogServiceCollector.this.triggerTransfer();
                }
            }
        };
    }

    private CoreException configurationException(String message, Exception e) {
        return new CoreException((IStatus)new Status(4, "org.eclipse.riena.monitor.client", message, (Throwable)e));
    }
}

