/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.monitor.client;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class Range {
    private final List<Match> list = new ArrayList<Match>();
    private static final String DELIM = ",";
    private static final String TILL = "..";

    public Range(String range) {
        StringTokenizer tokenizer = new StringTokenizer(range, DELIM);
        String token = null;
        try {
            while (tokenizer.hasMoreTokens()) {
                token = tokenizer.nextToken().trim();
                if (token.contains(TILL)) {
                    this.list.add(new Interval(token));
                    continue;
                }
                this.list.add(new Value(token));
            }
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Error parsing range '" + range + "' with token '" + token + "'.", t);
        }
    }

    public boolean matches(int value) {
        for (Match match : this.list) {
            if (!match.matches(value)) continue;
            return true;
        }
        return false;
    }

    private static class Interval
    implements Match {
        protected final int lower;
        protected final int upper;

        public Interval(String token) {
            int dotdot = token.indexOf(Range.TILL);
            assert (dotdot > 0);
            this.lower = Integer.valueOf(token.substring(0, dotdot).trim());
            this.upper = Integer.valueOf(token.substring(dotdot + Range.TILL.length()).trim());
        }

        public boolean matches(int value) {
            return this.lower <= value && value <= this.upper;
        }
    }

    private static interface Match {
        public boolean matches(int var1);
    }

    public static class ParseException
    extends Exception {
        private static final long serialVersionUID = -7362170629769240938L;

        public ParseException(String string, Throwable t) {
            super(string, t);
        }
    }

    private static class Value
    implements Match {
        private final int value;

        public Value(String token) {
            this.value = Integer.valueOf(token);
        }

        public boolean matches(int value) {
            return this.value == value;
        }
    }
}

